/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.security.properties.ldap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum LdapProtocolItem {
    PLAIN("PLAIN"),
    STARTTLS("STARTTLS"),
    SSL("SSL");

    private final String value;
    private static final Map<String, LdapProtocolItem> CONSTANTS;

    private LdapProtocolItem(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static LdapProtocolItem fromValue(String value) {
        LdapProtocolItem constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, LdapProtocolItem>();
        for (LdapProtocolItem c : LdapProtocolItem.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

