/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TreeType {
    INVENTORY(99),
    FOLDER(0),
    WORKFLOW(1),
    JOBCLASS(2),
    LOCK(4),
    SCHEDULE(7),
    JOBTEMPLATE(8),
    FILEORDERSOURCE(9),
    JOBRESOURCE(10),
    NOTICEBOARD(11),
    INCLUDESCRIPT(12),
    DEPLOYMENTDESCRIPTOR(13),
    DESCRIPTORFOLDER(14),
    REPORT(15),
    DOCUMENTATION(20),
    WORKINGDAYSCALENDAR(60),
    NONWORKINGDAYSCALENDAR(61);

    private final Integer intValue;
    private static final Map<String, TreeType> CONSTANTS;
    private static final Map<Integer, TreeType> INTCONSTANTS;

    private TreeType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static TreeType fromValue(String value) {
        TreeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static TreeType fromValue(Integer intValue) {
        TreeType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TreeType>();
        INTCONSTANTS = new HashMap<Integer, TreeType>();
        for (TreeType c : TreeType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (TreeType c : TreeType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

