/*
 * Decompiled with CFR 0.152.
 */
package com.sos.monitoring.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OrderNotificationRange {
    WORKFLOW(0),
    WORKFLOW_JOB(1);

    private final Integer intValue;
    private static final Map<String, OrderNotificationRange> CONSTANTS;
    private static final Map<Integer, OrderNotificationRange> INTCONSTANTS;

    private OrderNotificationRange(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static OrderNotificationRange fromValue(String value) {
        OrderNotificationRange constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static OrderNotificationRange fromValue(Integer intValue) {
        OrderNotificationRange constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OrderNotificationRange>();
        INTCONSTANTS = new HashMap<Integer, OrderNotificationRange>();
        for (OrderNotificationRange c : OrderNotificationRange.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (OrderNotificationRange c : OrderNotificationRange.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

