/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Annotations.JSOptionClass;
import com.sos.JSHelper.Annotations.JSOptionDefinition;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionValueList;
import com.sos.JSHelper.Options.SOSOptionBoolean;
import com.sos.JSHelper.Options.SOSOptionElement;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import com.sos.JSHelper.Options.SOSOptionInFileName;
import com.sos.JSHelper.Options.SOSOptionLocale;
import com.sos.JSHelper.Options.SOSOptionLogFileName;
import com.sos.JSHelper.Options.SOSOptionRegExp;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.JSHelper.Options.SOSOptionTime;
import com.sos.JSHelper.Options.SOSOptionUserName;
import com.sos.i18n.I18NBase;
import com.sos.i18n.Msg;
import com.sos.i18n.annotation.I18NResourceBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.StrTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="com_sos_JSHelper_Messages", defaultLocale="en")
@JSOptionClass(name="JSOptionsClass", description="JSOptionsClass")
public class JSOptionsClass
extends I18NBase
implements Serializable {
    private static final long serialVersionUID = 8497293387023797049L;
    private static final String CLASS_NAME = JSOptionsClass.class.getSimpleName();
    private static final Logger LOGGER = LoggerFactory.getLogger(JSOptionsClass.class);
    public Class<?> currentClass = this.getClass();
    private static Properties properties = new Properties();
    private HashMap<String, String> settings = null;
    private final StringBuilder buffer = new StringBuilder("");
    private final String optionNamePrefix = "-";
    private final String filePathSeparator = File.separator;
    private HashMap<String, String> processedOptions = null;
    private Preferences preferenceStore = null;
    private String alternativePrefix = "";
    private String[] commandLineArgs;
    private String currentNodeName = "";
    @JSOptionDefinition(name="BaseDirectory", description="A Base Directory for all relative FileNames used by SOSOptionFileName", key="Base_Directory", type="SOSOptionFolderName", mandatory=false)
    public SOSOptionFolderName baseDirectory = new SOSOptionFolderName(this, CLASS_NAME + ".Base_Directory", "A Base Directory for all relative FileNames used by SOSOptionFileName", "env:user.dir", "env:user.dir", false);
    @JSOptionDefinition(name="DateFormatMask", description="General Mask for date fomatting", key="Date_Format_Mask", type="SOSOptionString", mandatory=false)
    public SOSOptionString dateFormatMask = new SOSOptionString(this, CLASS_NAME + ".Date_Format_Mask", "General Mask for date fomatting", "yyyy-MM-dd", "yyyy-MM-dd", false);
    @JSOptionDefinition(name="TimeFormatMask", description="General Mask for time formatting", key="Time_Format_Mask", type="SOSOptionString", mandatory=false)
    public SOSOptionString timeFormatMask = new SOSOptionString(this, CLASS_NAME + ".Time_Format_Mask", "General Mask for time formatting", "HH:mm:ss", "HH:mm:ss", false);
    @JSOptionDefinition(name="Scheduler_Hot_Folder", description="Pathname to the JobScheduler live-folder", key="Scheduler_Hot_Folder", type="SOSOptionFolderName", mandatory=true)
    public SOSOptionFolderName schedulerHotFolder = new SOSOptionFolderName(this, CLASS_NAME + ".Scheduler_Hot_Folder", "Pathname to the JobScheduler live-folder", "${SCHEDULER_DATA}/config/live", "", true);
    @JSOptionDefinition(name="Scheduler_Data", description="Data Folder of JobScheduler Installation", key="Scheduler_Data", type="SOSOptionFolderName", mandatory=false)
    public SOSOptionFolderName schedulerData = new SOSOptionFolderName(this, CLASS_NAME + ".Scheduler_Data", "Data Folder of JobScheduler Installation", "env:SCHEDULER_DATA", "env:SCHEDULER_DATA", false);
    @JSOptionDefinition(name="Scheduler_Home", description="Home Root Folder of JobScheduler", key="Scheduler_Home", type="SOSOptionFileName", mandatory=true)
    public SOSOptionFolderName schedulerHome = new SOSOptionFolderName(this, CLASS_NAME + ".Scheduler_Home", "Home Root Folder of JobScheduler", "env:SCHEDULER_HOME", "env:SCHEDULER_HOME", false);
    @JSOptionDefinition(name="Local_user", description="I18N is for internationalization of Application", key="Local_user", type="SOSOptionUserName", mandatory=true)
    public SOSOptionUserName userName = new SOSOptionUserName(this, CLASS_NAME + ".local_user", "Name of local user", System.getProperty("user.name"), System.getProperty("user.name"), true);
    @JSOptionDefinition(name="Locale", description="I18N is for internationalization of Application", key="Locale", type="SOSOptionString", mandatory=true)
    public SOSOptionLocale locale = new SOSOptionLocale(this, CLASS_NAME + ".Locale", "I18N is for internationalization of Application", "env:SOS_LOCALE", Locale.getDefault().toString(), true);
    @JSOptionDefinition(name="CheckNotProcessedOptions", description="If this Option is set to true, all not processed or recognized options are reported as a warning", key="CheckNotProcessedOptions", type="SOSOptionBoolean", mandatory=false)
    public SOSOptionBoolean checkNotProcessedOptions = new SOSOptionBoolean(this, CLASS_NAME + ".CheckNotProcessedOptions", "If this Option is set to true, all not processed or recognized options are reported as a warning", "false", "false", false);
    @JSOptionDefinition(name="log_filename", description="Name der Datei mit den Logging-Eintr\u00e4gen", key="log_filename", type="SOSOptionFileName", mandatory=false)
    public SOSOptionLogFileName logFilename = new SOSOptionLogFileName(this, CLASS_NAME + ".log_filename", "Name der Datei mit den Logging-Eintr\u00e4gen", "stdout", "stdout", false);
    @JSOptionDefinition(name="log4jPropertyFileName", description="Name of the LOG4J Property File", key="log4j_Property_FileName", type="SOSOptionInFileName", mandatory=false)
    public SOSOptionInFileName log4jPropertyFileName = new SOSOptionInFileName(this, CLASS_NAME + ".log4j_Property_FileName", "Name of the LOG4J Property File", "env:log4j.configurationFile", "../lib/log4j2.xml", false);

    public JSOptionsClass() {
        try {
            new Msg(new Msg.BundleBaseName(this.getClass().getAnnotation(I18NResourceBundle.class).baseName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSOptionsClass(HashMap<String, String> settings) {
        this();
        this.setAllOptions(settings);
    }

    private void loadProperties(String fileName) {
        String method = CLASS_NAME + "::LoadProperties ";
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(fileName));
            this.message(method + ": PropertyFile read. Name '" + fileName + "'.");
            this.getSettings();
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                String value;
                if (property.getValue() == null || (value = property.getValue().toString()) == null || value.isEmpty() || ".".equalsIgnoreCase(value)) continue;
                this.settings.put(property.getKey().toString(), value);
            }
            this.message(method + ": Property-File loaded");
            this.setAllCommonOptions(this.settings);
        }
        catch (Exception e) {
            throw new JobSchedulerException(e);
        }
    }

    public void loadProperties(Properties properties) {
        this.getSettings();
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = property.getKey().toString();
            if (property.getValue() == null) continue;
            String value = property.getValue().toString();
            LOGGER.debug("Property " + key + " = " + value);
            if (value == null || value.isEmpty() || ".".equalsIgnoreCase(value)) continue;
            this.settings.put(key, value);
        }
        this.setAllCommonOptions(this.settings);
    }

    public HashMap<String, String> getSettings() {
        if (this.settings == null) {
            this.settings = new HashMap();
        }
        return this.settings;
    }

    public void setAllOptions(HashMap<String, String> params, String prefix) throws Exception {
        this.settings = params;
        if (this.alternativePrefix.isEmpty()) {
            this.alternativePrefix = prefix;
        }
        this.setAllCommonOptions(this.settings, this.alternativePrefix);
    }

    public void setAllOptions(HashMap<String, String> params) {
        this.settings = params;
        this.setAllCommonOptions(this.settings);
    }

    private void setAllCommonOptions(HashMap<String, String> params) {
        this.setAllCommonOptions(params, null);
    }

    private void setAllCommonOptions(HashMap<String, String> params, String prefix) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[setAllCommonOptions][%s]%s", this.getClass().getSimpleName(), prefix == null ? "" : prefix));
        }
        this.settings = params;
        if (this.currentClass != null) {
            this.iterateAllDataElementsByAnnotation(this.currentClass, this, IterationTypes.setRecord, this.buffer, prefix);
        }
    }

    public String getItem(String pstrKey) {
        String strMapKey;
        String strTemp = "";
        String strKey = pstrKey;
        if (this.isEmpty(pstrKey)) {
            return strTemp;
        }
        if (this.processedOptions == null) {
            this.processedOptions = new HashMap();
        }
        strKey = strKey.replaceAll("_", "");
        String strLSKey = "";
        if (!this.currentNodeName.isEmpty()) {
            strLSKey = this.currentNodeName + "/" + pstrKey.replaceAll("_", "");
            for (Map.Entry<String, String> mapItem : this.settings.entrySet()) {
                strMapKey = mapItem.getKey();
                if (!strLSKey.equalsIgnoreCase(strMapKey = strMapKey.replaceAll("_", ""))) continue;
                strTemp = mapItem.getValue() != null ? mapItem.getValue() : null;
                this.processedOptions.put(strMapKey, strTemp);
                return strTemp;
            }
        }
        for (Map.Entry<String, String> mapItem : this.settings.entrySet()) {
            strMapKey = mapItem.getKey();
            String lstrMapKey = strMapKey.replaceAll("_", "");
            if (!strKey.equalsIgnoreCase(lstrMapKey)) continue;
            strTemp = mapItem.getValue() != null ? mapItem.getValue() : null;
            this.processedOptions.put(strMapKey, strTemp);
            return strTemp;
        }
        int i = strKey.indexOf(46);
        if (i > 0) {
            String lstrMapKey;
            String strMapKey2;
            strLSKey = "";
            strKey = strKey.substring(++i);
            if (!this.currentNodeName.isEmpty()) {
                strLSKey = this.currentNodeName + "/" + strKey;
                for (Map.Entry<String, String> mapItem : this.settings.entrySet()) {
                    strMapKey2 = mapItem.getKey();
                    lstrMapKey = strMapKey2.replaceAll("_", "");
                    if (!strLSKey.equalsIgnoreCase(lstrMapKey)) continue;
                    strTemp = mapItem.getValue() != null ? mapItem.getValue() : null;
                    this.processedOptions.put(strMapKey2, strTemp);
                    return strTemp;
                }
            }
            for (Map.Entry<String, String> mapItem : this.settings.entrySet()) {
                strMapKey2 = mapItem.getKey();
                lstrMapKey = strMapKey2.replaceAll("_", "");
                if (!strLSKey.isEmpty() && strLSKey.equalsIgnoreCase(lstrMapKey)) {
                    strTemp = mapItem.getValue() != null ? mapItem.getValue() : null;
                    this.processedOptions.put(strMapKey2, strTemp);
                    return strTemp;
                }
                if (!strKey.equalsIgnoreCase(lstrMapKey)) continue;
                strTemp = mapItem.getValue() != null ? mapItem.getValue().toString() : null;
                this.processedOptions.put(strMapKey2, strTemp);
                return strTemp;
            }
        }
        if (strTemp == null || strTemp.isEmpty()) {
            strTemp = null;
        }
        return strTemp;
    }

    public boolean checkNotProcessedOptions() {
        boolean result = true;
        if (this.settings != null) {
            for (Map.Entry<String, String> entry : this.settings.entrySet()) {
                String key = entry.getKey();
                if (this.processedOptions.get(key) != null) continue;
                String value = entry.getValue();
                LOGGER.warn(String.format("SOSOPT-W-001: Option '%1$s' with value '%2$s' is unknown and not processed", key, value));
                result = false;
            }
        }
        return result;
    }

    public HashMap<String, String> getProcessedOptions() {
        if (this.processedOptions == null) {
            this.processedOptions = new HashMap();
        }
        return this.processedOptions;
    }

    public void addProcessedOptions(HashMap<String, String> map) {
        this.getProcessedOptions();
        this.processedOptions.putAll(map);
    }

    public String getItem(String key, String defaultValue) {
        String value = this.getItem(key);
        if (this.isEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean string2Bool(String val) {
        return this.isNotEmpty(val) && ("1".equals(val) || "y".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "j".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val) || "wahr".equalsIgnoreCase(val));
    }

    private void toOut(String msg) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            if (msg.contains(CLASS_NAME)) {
                LOGGER.debug(msg);
            } else {
                LOGGER.debug(msg + this.getAllOptionsAsString());
            }
        }
    }

    protected void toOut() {
        try {
            this.toOut(this.getAllOptionsAsString());
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try {
            return this.getAllOptionsAsString();
        }
        catch (Exception e) {
            throw new JobSchedulerException("toString failed", e);
        }
    }

    public String dirtyString() {
        try {
            return "\n" + this.getAllOptionsAsString(IterationTypes.DirtyToString).trim();
        }
        catch (Exception e) {
            throw new JobSchedulerException("dirtyString failed", e);
        }
    }

    private String getAllOptionsAsString(IterationTypes type) {
        StringBuilder sb = new StringBuilder();
        if (this.currentClass != null) {
            sb.append((CharSequence)this.iterateAllDataElementsByAnnotation(this.currentClass, this, type, new StringBuilder(""), null));
        }
        return sb.toString();
    }

    private String getAllOptionsAsString() {
        return this.getAllOptionsAsString(IterationTypes.toString);
    }

    public void checkMandatory() throws Exception {
        if (this.currentClass != null) {
            this.iterateAllDataElementsByAnnotation(this.currentClass, this, IterationTypes.CheckMandatory, this.buffer, null);
        }
    }

    public String substituteVariables(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("//", "/");
    }

    protected String[] splitString(String value) {
        if (value == null) {
            return null;
        }
        return value.trim().split("[;|,]");
    }

    protected void checkNull(String method, String titel, String name, String value) throws Exception {
        if (this.isEmpty(value)) {
            this.signalError(name + " is mandatory, must be not null");
        }
    }

    public void commandLineArgs(String args) {
        this.commandLineArgs(new StrTokenizer(args).getTokenArray());
    }

    public void commandLineArgs(String[] args) {
        String method = CLASS_NAME + "::CommandLineArgs ";
        if (args.length <= 0) {
            throw new JobSchedulerException("missing parameters");
        }
        this.commandLineArgs = args;
        boolean isOption = true;
        String name = null;
        String value = null;
        this.getSettings();
        int l = "-".length();
        for (String arg : this.commandLineArgs) {
            if (isOption) {
                if (arg.length() < l || !arg.substring(0, l).equalsIgnoreCase("-")) continue;
                name = arg.substring(l);
                isOption = false;
                int pos = name.indexOf("=");
                if (pos <= 0) continue;
                value = name.substring(pos + 1);
                value = this.stripQuotes(value);
                name = name.substring(0, pos);
                this.settings.put(name, value);
                if ("password".equalsIgnoreCase(name) || "proxy_password".equalsIgnoreCase(name)) {
                    this.signalDebug(String.format("%1$s: Name = %2$s, Wert = %3$s", method, name, "*****"));
                } else {
                    this.signalDebug(String.format("%1$s: Name = %2$s, Wert = %3$s", method, name, value));
                }
                isOption = true;
                continue;
            }
            if (name == null) continue;
            value = arg;
            isOption = true;
            this.settings.put(name, this.stripQuotes(value));
            if ("password".equalsIgnoreCase(name) || "proxy_password".equalsIgnoreCase(name)) {
                this.signalDebug(String.format("%1$s: Name = %2$s, Wert = %3$s", method, name, "*****"));
            } else {
                this.signalDebug(String.format("%1$s: Name = %2$s, Wert = %3$s", method, name, value));
            }
            name = null;
        }
        String propertyFileName = this.getItem("PropertyFileName", "");
        if (!propertyFileName.isEmpty()) {
            this.loadProperties(propertyFileName);
            name = null;
            isOption = true;
            for (String arg : this.commandLineArgs) {
                if (isOption) {
                    if (!arg.substring(0, l).equalsIgnoreCase("-")) continue;
                    name = arg.substring(l);
                    isOption = false;
                    continue;
                }
                if (name == null) continue;
                value = arg;
                isOption = true;
                this.settings.put(name, value);
                if ("password".equalsIgnoreCase(name) || "proxy_password".equalsIgnoreCase(name)) {
                    this.signalDebug(String.format("%1$s: CmdSettings. Name = %2$s, value = %3$s", method, name, "*****"));
                } else {
                    this.signalDebug(String.format("%1$s: CmdSettings. Name = %2$s, value = %3$s", method, name, value));
                }
                name = null;
            }
            this.message(method + ": Property-File loaded. " + propertyFileName);
        }
        this.dumpSettings();
        this.setAllOptions(this.settings);
    }

    public String[] commandLineArgs() {
        return this.commandLineArgs;
    }

    public String getCurrentNodeName() {
        return this.currentNodeName;
    }

    public JSOptionsClass setCurrentNodeName(String val) {
        this.currentNodeName = val;
        return this;
    }

    private String getOptionByName(String name) {
        String value = null;
        Class<?> clazz = this.getClass();
        value = this.getOptionValue(clazz, name);
        if (value == null) {
            clazz = this.currentClass.getClass();
            value = this.getOptionValue(clazz, name);
        }
        return value;
    }

    private String getOptionValue(Class<?> clazz, String name) {
        String value = null;
        Field field = null;
        try {
            field = clazz.getField(name);
            Object obj = field.get(this);
            if (obj instanceof String) {
                value = (String)field.get(this);
            } else if (obj instanceof SOSOptionElement) {
                SOSOptionElement el = (SOSOptionElement)obj;
                value = el.getValue();
            }
        }
        catch (NoSuchFieldException objException) {
            try {
                Method method = clazz.getMethod(name, new Class[0]);
                method.setAccessible(true);
                value = (String)method.invoke((Object)this, new Object[0]);
            }
            catch (SecurityException exception) {
                LOGGER.error(exception.getMessage(), (Throwable)exception);
            }
            catch (NoSuchMethodException exception) {
            }
            catch (IllegalArgumentException exception) {
                LOGGER.error(exception.getMessage(), (Throwable)exception);
            }
            catch (InvocationTargetException exception) {
                LOGGER.error(exception.getMessage(), (Throwable)exception);
            }
            catch (IllegalAccessException exception) {
                LOGGER.error(exception.getMessage(), (Throwable)exception);
            }
        }
        catch (IllegalAccessException exception) {
            LOGGER.error(exception.toString(), (Throwable)exception);
        }
        return value;
    }

    public Properties getTextProperties() {
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    public String replaceVars(String value) {
        this.getTextProperties();
        try {
            properties.put("date", SOSOptionTime.getCurrentDateAsString(this.dateFormatMask.getValue()));
            properties.put("time", SOSOptionTime.getCurrentTimeAsString(this.timeFormatMask.getValue()));
            properties.put("local_user", System.getProperty("user.name"));
            InetAddress localHost = InetAddress.getLocalHost();
            properties.put("localhost", localHost.getHostName());
            properties.put("local_host_ip", localHost.getHostAddress());
            properties.put("tempdir", System.getProperty("java.io.tmpdir") + this.filePathSeparator);
            properties.put("temp", System.getProperty("java.io.tmpdir") + this.filePathSeparator);
            properties.put("uuid", SOSOptionRegExp.getUUID());
            properties.put("timestamp", SOSOptionRegExp.getUnixTimeStamp());
            properties.put("sqltimestamp", SOSOptionRegExp.getSqlTimeStamp());
            properties.put("weekofyear", SOSOptionTime.getCurrentDateAsString("yyyyw"));
            properties.put("currentweek", SOSOptionTime.getCurrentDateAsString("w"));
        }
        catch (Exception localHost) {
            // empty catch block
        }
        String paramNameEnclosedInPercentSigns = "^.*(\\$|%)\\{([^%\\}]+)\\}.*$";
        String key = "";
        String val = "";
        StringBuilder result = new StringBuilder();
        if (this.isNotNull(value)) {
            try {
                String[] arr;
                for (String string : arr = value.split("\\n")) {
                    while (string.matches(paramNameEnclosedInPercentSigns)) {
                        key = string.replaceFirst(paramNameEnclosedInPercentSigns, "$2");
                        if ("uuid".equalsIgnoreCase(key)) continue;
                        String var = "(\\$|%)\\{" + Matcher.quoteReplacement(key) + "\\}";
                        val = this.getOptionByName(key);
                        if (this.isNotNull(val)) {
                            val = val.replace('\\', '/');
                            string = string.replaceAll(var, Matcher.quoteReplacement(val));
                            continue;
                        }
                        val = (String)properties.get(key);
                        if (val != null) {
                            string = string.replaceAll(var, Matcher.quoteReplacement(val));
                            continue;
                        }
                        val = this.getSettings().get(key);
                        if (val != null) {
                            string = string.replaceAll(var, Matcher.quoteReplacement(val));
                            continue;
                        }
                        string = string.replaceAll(var, "?" + Matcher.quoteReplacement(key) + "?");
                    }
                    result.append(string).append("\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString().replaceFirst("\n$", "");
    }

    private void dumpSettings() {
        String method = CLASS_NAME + "::DumpSettings";
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue();
            if ("ftp_password".equals(key)) {
                value = "***";
                continue;
            }
            if ("password".equalsIgnoreCase(key)) {
                this.signalDebug(method + ": Key = " + key + " --> *****");
                continue;
            }
            this.signalDebug(method + ": Key = " + key + " --> " + value);
        }
    }

    public String getIndexedItem(String key, String description, String delimiter) {
        JSOptionValueList list = new JSOptionValueList(this, key, description, "", true);
        return list.concatenatedValue(delimiter);
    }

    private Object deepCopy(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        byte[] buffer = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    public String getOptionsAsCommandLine() {
        return this.iterate(IterationTypes.getCommandLine).toString();
    }

    public String getOptionsAsQuotedCommandLine() {
        return this.iterate(IterationTypes.getQuotedCommandLine).toString();
    }

    public String getOptionsAsKeyValuePairs() {
        return this.iterate(IterationTypes.getKeyValuePair).toString();
    }

    private StringBuilder iterateAllDataElementsByAnnotation(Class<?> clazz, Object element, IterationTypes enuIterate4What, StringBuilder sb, String prefix) {
        if (clazz == null) {
            throw new JobSchedulerException(String.format("[%s::IterateAllDataElementsByAnnotation]clazz is null", CLASS_NAME));
        }
        SOSOptionElement.gflgProcessHashMap = true;
        try {
            String clazzName = clazz.getName();
            List fields = Arrays.stream(clazz.getFields()).filter(f -> f.isAnnotationPresent(JSOptionDefinition.class)).collect(Collectors.toList());
            for (Field field : fields) {
                try {
                    SOSOptionElement el = (SOSOptionElement)field.get(element);
                    if (el == null) continue;
                    if (enuIterate4What.equals((Object)IterationTypes.setRecord)) {
                        if (prefix != null) {
                            el.setPrefix(prefix);
                        }
                        SOSOptionElement.gflgProcessHashMap = true;
                        el.mapValue();
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.CheckMandatory)) {
                        el.checkMandatory();
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.setPrefix)) {
                        el.setPrefix(this.alternativePrefix);
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.setDefaultValues)) {
                        String val = el.getValue();
                        if (!val.isEmpty()) continue;
                        el.setValue(el.getDefaultValue());
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.LoadValues)) {
                        SOSOptionElement.gflgProcessHashMap = true;
                        el.loadValues();
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.StoreValues)) {
                        el.storeValues();
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.toOut)) {
                        LOGGER.debug(el.toString());
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.toString)) {
                        sb.append(el.toString() + "\n");
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.DirtyToString) && el.isDirty()) {
                        sb.append(el.getDirtyToString() + "\n");
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.clearAllValues)) {
                        el.setValue("");
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.getCommandLine)) {
                        sb.append(el.toCommandLine());
                        continue;
                    }
                    if (enuIterate4What.equals((Object)IterationTypes.getQuotedCommandLine)) {
                        sb.append(el.toQuotedCommandLine());
                        continue;
                    }
                    if (!enuIterate4What.equals((Object)IterationTypes.getKeyValuePair) || !this.isNotEmpty(clazzName = el.toKeyValuePair(this.alternativePrefix))) continue;
                    sb.append(clazzName + "\n");
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            SOSOptionElement.gflgProcessHashMap = false;
        }
        return sb;
    }

    private StringBuilder iterate(IterationTypes enuIterate4What) {
        StringBuilder sb = new StringBuilder();
        if (this.currentClass != null) {
            sb = this.iterateAllDataElementsByAnnotation(this.currentClass, this, enuIterate4What, sb, null);
        }
        return sb;
    }

    public HashMap<String, String> deletePrefix(HashMap<String, String> params, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (params != null) {
            String longPrefix = "/" + prefix;
            for (Map.Entry<String, String> param : params.entrySet()) {
                String key = param.getKey();
                String value = param.getValue();
                if (key.startsWith(prefix)) {
                    if (prefix.equals("ssh_") && key.equals("ssh_provider")) {
                        result.put(key, value);
                        continue;
                    }
                    key = key.replaceAll(prefix, "");
                    result.put(key, value);
                    param.setValue("\n");
                    continue;
                }
                if (key.contains(longPrefix)) {
                    key = key.replace(longPrefix, "/");
                    result.put(key, value);
                    param.setValue("\n");
                    continue;
                }
                result.put(key, value);
            }
        }
        return result;
    }

    public Preferences getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = Preferences.userNodeForPackage(this.currentClass);
        }
        return this.preferenceStore;
    }

    protected void setIfNotDirty(SOSOptionElement el, String value) {
        if (el.isNotDirty() && this.isNotEmpty(value)) {
            LOGGER.trace("setValue = " + value);
            el.setValue(value);
        }
    }

    public SOSOptionLogFileName getLogFilename() {
        return this.logFilename;
    }

    public void setLogFilename(SOSOptionLogFileName val) {
        this.logFilename = val;
    }

    public String getPrefix() {
        return this.alternativePrefix;
    }

    private static enum IterationTypes {
        setRecord,
        getRecord,
        toOut,
        setDefaultValues,
        clearAllValues,
        CheckMandatory,
        setPrefix,
        toString,
        getCommandLine,
        DirtyToString,
        getKeyValuePair,
        LoadValues,
        StoreValues,
        getQuotedCommandLine;

    }
}

