/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionValueList;
import com.sos.JSHelper.Options.JSOptionsClass;

public class SOSOptionProxyProtocol
extends JSOptionValueList {
    private static final long serialVersionUID = 1L;

    public SOSOptionProxyProtocol(JSOptionsClass parent, String key, String description, String value, String defaultValue, boolean isMandatory) {
        super(parent, key, description, value, defaultValue, isMandatory);
    }

    public SOSOptionProxyProtocol(JSOptionsClass parent, String indexedKey, String description, String defaultValue, boolean isMandatory) {
        super(parent, indexedKey, description, defaultValue, isMandatory);
    }

    public boolean isHttp() {
        return this.getValue().equalsIgnoreCase(Protocol.http.name());
    }

    public boolean isSocks4() {
        return this.getValue().equalsIgnoreCase(Protocol.socks4.name());
    }

    public boolean isSocks5() {
        return this.getValue().equalsIgnoreCase(Protocol.socks5.name());
    }

    @Override
    public void setValue(String value) {
        String testValue = value.toLowerCase();
        try {
            Protocol.valueOf(testValue);
        }
        catch (Exception e) {
            throw new JobSchedulerException(String.format("Value \"%s\" is not valid for %s - valid values are %s : %s", testValue, this.strKey, Protocol.asString(), e.toString()));
        }
        super.setValue(testValue);
    }

    public static enum Protocol {
        http,
        socks4,
        socks5;


        public static String asString() {
            StringBuilder result = new StringBuilder();
            result.append("[");
            for (Protocol t : Protocol.values()) {
                if (result.length() > 1) {
                    result.append(", ");
                }
                result.append(t.name());
            }
            result.append("]");
            return result.toString();
        }
    }
}

