/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionElement;
import com.sos.JSHelper.Options.SOSOptionTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSOptionStringWVariables
extends SOSOptionElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSOptionStringWVariables.class);
    private static final long serialVersionUID = 3890065543134955852L;
    protected String strOriginalValue = "";

    public SOSOptionStringWVariables(JSOptionsClass pPobjParent, String pPstrKey, String pPstrDescription, String pPstrValue, String pPstrDefaultValue, boolean pPflgIsMandatory) {
        super(pPobjParent, pPstrKey, pPstrDescription, pPstrValue, pPstrDefaultValue, pPflgIsMandatory);
        this.intOptionType = 0;
    }

    public final String substituteAllDate() throws Exception {
        String temp = this.strValue;
        if (this.strValue.indexOf("[") > -1) {
            String targetFileName = this.strValue;
            temp = this.substituteDateMask(targetFileName);
            while (!targetFileName.equals(temp)) {
                targetFileName = temp;
                temp = this.substituteDateMask(targetFileName);
            }
        }
        return temp;
    }

    private String substituteDateMask(String targetFilename) throws Exception {
        String conVarName = "[date:";
        try {
            int posEnd;
            int posBegin;
            if (targetFilename.matches("(.*)(\\[date:)([^\\]]*)(\\])(.*)") && (posBegin = targetFilename.indexOf("[date:")) > -1 && (posEnd = targetFilename.indexOf("]", posBegin + 6)) > -1) {
                String strDateMask = targetFilename.substring(posBegin + 6, posEnd);
                if (strDateMask.isEmpty()) {
                    strDateMask = SOSOptionTime.dateTimeFormat;
                }
                String strDateTime = SOSOptionTime.getCurrentTimeAsString(strDateMask);
                String strT = (posBegin > 0 ? targetFilename.substring(0, posBegin) : "") + strDateTime;
                if (targetFilename.length() > posEnd) {
                    strT = strT + targetFilename.substring(posEnd + 1);
                }
                targetFilename = strT;
            }
            return targetFilename;
        }
        catch (Exception e) {
            throw new JobSchedulerException("error substituting [date:]: " + e.getMessage(), e);
        }
    }

    public String getOriginalValue() {
        return this.strOriginalValue;
    }

    public void doReSubstitution() {
        try {
            String strT = this.substituteAllDate();
            super.setValue(strT);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getValue() {
        String strT = this.strValue;
        try {
            strT = this.objParentClass != null ? this.substituteAllDate() : this.substituteAllDate();
            super.setValue(strT);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return strT;
    }

    @Override
    public void setValue(String pstrStringValue) {
        this.strOriginalValue = pstrStringValue;
        super.setValue(pstrStringValue);
    }
}

