/*
 * Decompiled with CFR 0.152.
 */
package com.sos.i18n;

import com.sos.i18n.Logger;
import com.sos.i18n.Msg;
import com.sos.i18n.logging.commons.CommonsLogger;
import com.sos.i18n.logging.jdk.JDKLogger;
import com.sos.i18n.logging.log4j.Log4jLogger;
import java.util.Locale;

public class LoggerFactory {
    public static final String SYSPROP_LOGGER_TYPE = "i18nlog.logger-type";
    private static LoggerType LOGGER_TYPE = LoggerFactory.resetLoggerType(null);

    private LoggerFactory() {
    }

    public static Logger getLogger(String name, Msg.BundleBaseName basename, Locale locale) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(name, basename, locale);
            }
            case COMMONS: {
                return new CommonsLogger(name, basename, locale);
            }
        }
        return new JDKLogger(name, basename, locale);
    }

    public static Logger getLogger(Class clazz, Msg.BundleBaseName basename, Locale locale) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(clazz, basename, locale);
            }
            case COMMONS: {
                return new CommonsLogger(clazz, basename, locale);
            }
        }
        return new JDKLogger(clazz, basename, locale);
    }

    public static Logger getLogger(String name, Msg.BundleBaseName basename) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(name, basename);
            }
            case COMMONS: {
                return new CommonsLogger(name, basename);
            }
        }
        return new JDKLogger(name, basename);
    }

    public static Logger getLogger(Class clazz, Msg.BundleBaseName basename) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(clazz, basename);
            }
            case COMMONS: {
                return new CommonsLogger(clazz, basename);
            }
        }
        return new JDKLogger(clazz, basename);
    }

    public static Logger getLogger(String name, Locale locale) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(name, locale);
            }
            case COMMONS: {
                return new CommonsLogger(name, locale);
            }
        }
        return new JDKLogger(name, locale);
    }

    public static Logger getLogger(Class clazz, Locale locale) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(clazz, locale);
            }
            case COMMONS: {
                return new CommonsLogger(clazz, locale);
            }
        }
        return new JDKLogger(clazz, locale);
    }

    public static Logger getLogger(String name) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(name);
            }
            case COMMONS: {
                return new CommonsLogger(name);
            }
        }
        return new JDKLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        switch (LOGGER_TYPE) {
            case LOG4J: {
                return new Log4jLogger(clazz);
            }
            case COMMONS: {
                return new CommonsLogger(clazz);
            }
        }
        return new JDKLogger(clazz);
    }

    public static LoggerType resetLoggerType(LoggerType type) {
        if (type == null) {
            String property = System.getProperty(SYSPROP_LOGGER_TYPE);
            if (property != null) {
                if (LoggerType.LOG4J.toString().equalsIgnoreCase(property)) {
                    type = LoggerType.LOG4J;
                } else if (LoggerType.COMMONS.toString().equalsIgnoreCase(property)) {
                    type = LoggerType.COMMONS;
                } else if (LoggerType.JDK.toString().equalsIgnoreCase(property)) {
                    type = LoggerType.JDK;
                } else {
                    System.err.println("i18nlog.logger-type != [log4j | commons | jdk ]");
                }
            }
            if (type == null) {
                try {
                    Class.forName("org.apache.log4j.Logger", false, LoggerFactory.class.getClassLoader());
                    type = LoggerType.LOG4J;
                }
                catch (Exception e1) {
                    try {
                        Class.forName("org.apache.commons.logging.Log", false, LoggerFactory.class.getClassLoader());
                        type = LoggerType.COMMONS;
                    }
                    catch (Exception e2) {
                        type = LoggerType.JDK;
                    }
                }
            }
        }
        LOGGER_TYPE = type;
        return LOGGER_TYPE;
    }

    public static enum LoggerType {
        LOG4J,
        COMMONS,
        JDK;

    }
}

