/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.function.date;

import com.sos.commons.hibernate.SOSHibernateFactory;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.StandardBasicTypes;

public class SOSHibernateSecondsDiff
extends StandardSQLFunction {
    public static final String NAME = "SOS_SECONDSDIFF";
    private SOSHibernateFactory factory;

    public SOSHibernateSecondsDiff(SOSHibernateFactory factory) {
        super(NAME, StandardBasicTypes.INTEGER);
        this.factory = factory;
    }

    public static String getFunction(String startTimeProperty, String endTimeProperty) {
        return NAME + "(" + startTimeProperty + "," + endTimeProperty + ")";
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) throws QueryException {
        if (arguments == null || arguments.size() < 2) {
            throw new QueryException("missing arguments", null, null);
        }
        switch (this.factory.getDbms()) {
            case MYSQL: {
                sqlAppender.append((CharSequence)"TIMESTAMPDIFF(SECOND,");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)")");
                break;
            }
            case MSSQL: {
                sqlAppender.append((CharSequence)"DATEDIFF(SECOND,");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)")");
                break;
            }
            case ORACLE: {
                sqlAppender.append((CharSequence)"ROUND(24*60*60*(");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)"-");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)"))");
                break;
            }
            case PGSQL: {
                sqlAppender.append((CharSequence)"CAST(EXTRACT(EPOCH FROM(");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)"-");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)")) AS INTEGER)");
                break;
            }
            case H2: {
                sqlAppender.append((CharSequence)"DATEDIFF(ss,");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)")");
                break;
            }
            default: {
                sqlAppender.append((CharSequence)"(");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)"-");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)")");
            }
        }
    }
}

