/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.mail;

import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.mail.SOSMailAuthenticator;
import com.sos.commons.util.SOSString;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSMailReceiver {
    protected SOSMailAuthenticator authenticator = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMailReceiver.class);
    private Store store;
    private Folder folder = null;
    private final Protocol protocol;
    private Integer defaultTimeout = 5000;
    private String host;
    private Integer port;
    private String user;
    private Session session;
    private String password;
    public int READ_ONLY = 1;
    public int READ_WRITE = 2;

    public SOSMailReceiver(Protocol protocol, Map<String, Object> mailProperties) throws SOSRequiredArgumentMissingException {
        this.protocol = protocol;
        this.createSession(mailProperties);
    }

    public SOSMailReceiver(Protocol protocol, String host, Integer port, String user, String password, boolean ssl, int timeout) throws SOSRequiredArgumentMissingException {
        this.host = host;
        this.port = port;
        this.user = user;
        this.protocol = protocol;
        this.password = password;
        this.createSession(this.getProperties(ssl, timeout));
    }

    private Session createSession(Map<String, Object> mailReceiverProps) throws SOSRequiredArgumentMissingException {
        Properties props = System.getProperties();
        if (mailReceiverProps != null) {
            props.putAll(mailReceiverProps);
        }
        this.parseUser(props);
        this.parseHost(props);
        this.parsePassword(props);
        this.parsePort(props);
        if (!this.parseString("timeout", props).isPresent()) {
            props.put("mail." + this.protocol.name() + ".timeout", this.defaultTimeout);
        }
        this.authenticator = new SOSMailAuthenticator(this.user, this.password);
        this.session = Session.getInstance((Properties)props, (Authenticator)this.authenticator);
        return this.session;
    }

    private void parseUser(Properties props) throws SOSRequiredArgumentMissingException {
        if (this.user == null) {
            this.parseString("user", props).ifPresent(val -> {
                this.user = val;
            });
        }
        if (this.user == null) {
            throw new SOSRequiredArgumentMissingException("'mail." + this.protocol.name() + ".user' is missing but required");
        }
    }

    private void parseHost(Properties props) throws SOSRequiredArgumentMissingException {
        if (this.host == null) {
            this.parseString("host", props).ifPresent(val -> {
                this.host = val;
            });
        }
        if (this.host == null) {
            throw new SOSRequiredArgumentMissingException("'mail." + this.protocol.name() + ".host' is missing but required");
        }
    }

    private void parsePassword(Properties props) throws SOSRequiredArgumentMissingException {
        if (this.password == null) {
            this.parseString("password", props).ifPresent(val -> {
                this.password = val;
            });
        }
        if (this.password == null) {
            this.password = "";
        }
    }

    private void parsePort(Properties props) {
        if (this.port == null) {
            this.parse("port", props).ifPresent(val -> {
                this.port = (Integer)val;
            });
        }
    }

    private Optional<String> parseString(String key, Properties props) {
        String propPrefix = "mail." + this.protocol.name() + ".";
        String prop = props.getProperty(propPrefix + key);
        if (!SOSString.isEmpty((String)prop)) {
            return Optional.of(prop);
        }
        prop = props.getProperty("mail." + key);
        if (!SOSString.isEmpty((String)prop)) {
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    private Optional<Object> parse(String key, Properties props) {
        String propPrefix = "mail." + this.protocol.name() + ".";
        Object prop = props.get(propPrefix + key);
        if (prop != null) {
            return Optional.of(prop);
        }
        prop = props.get("mail." + key);
        if (prop != null) {
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    private Map<String, Object> getProperties(boolean ssl, int timeout) {
        String propPrefix = "mail." + this.protocol.name() + ".";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("mail.store.protocol", this.protocol.name());
        if (this.host != null) {
            props.put(propPrefix + "host", this.host);
        }
        if (this.port != null) {
            props.put(propPrefix + "port", this.port);
        }
        if (timeout > 0) {
            props.put(propPrefix + "timeout", timeout);
        }
        if (ssl) {
            props.put(propPrefix + "ssl.enable", true);
        }
        return props;
    }

    public void connect() throws MessagingException {
        this.store = this.session.getStore(this.protocol.name());
        this.store.connect(this.host, this.user, this.password);
        LOGGER.debug("..connection to host [" + this.host + ":" + this.port + "] successfully established.");
    }

    public String getHostPort() {
        return this.host + ":" + this.port;
    }

    public Folder openFolder(String folderName, int mode) throws MessagingException {
        this.folder = this.store.getFolder(folderName);
        if (this.folder == null) {
            throw new MessagingException("Could not open [" + folderName + "]");
        }
        this.folder.open(mode);
        return this.folder;
    }

    public Folder openFolder(int mode) throws MessagingException {
        this.folder = this.store.getDefaultFolder();
        if (this.folder == null) {
            throw new MessagingException("Could not open default folder");
        }
        this.folder.open(mode);
        return this.folder;
    }

    public void closeFolder(boolean expunge) throws MessagingException {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(expunge);
            this.folder = null;
        }
    }

    public void disconnect() throws MessagingException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getFolderName() {
        return this.folder == null ? "" : this.folder.getName();
    }

    public String getDefaultFolderName() throws MessagingException {
        return this.store.getDefaultFolder().getName();
    }

    public Session getSession() {
        return this.session;
    }

    public static enum Protocol {
        pop3,
        imap;

    }
}

