/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.mail;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSMimeBase64 {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMimeBase64.class);
    static String[] BaseTable = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "+", "/"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(String filename, BufferedWriter out) {
        FileInputStream fin = null;
        try {
            File f = new File(filename);
            fin = new FileInputStream(filename);
            byte[] bytes = new byte[(int)f.length()];
            int n = fin.read(bytes);
            if (n < 1) {
                return;
            }
            byte[] buf = new byte[4];
            int n3byt = n / 3;
            int nrest = n % 3;
            int k = n3byt * 3;
            int linelength = 0;
            for (int i = 0; i < k; i += 3) {
                buf[0] = (byte)((bytes[i] & 0xFC) >> 2);
                buf[1] = (byte)((bytes[i] & 3) << 4 | (bytes[i + 1] & 0xF0) >> 4);
                buf[2] = (byte)((bytes[i + 1] & 0xF) << 2 | (bytes[i + 2] & 0xC0) >> 6);
                buf[3] = (byte)(bytes[i + 2] & 0x3F);
                SOSMimeBase64.send(out, BaseTable[buf[0]]);
                SOSMimeBase64.send(out, BaseTable[buf[1]]);
                SOSMimeBase64.send(out, BaseTable[buf[2]]);
                SOSMimeBase64.send(out, BaseTable[buf[3]]);
                if ((linelength += 4) < 76) continue;
                SOSMimeBase64.send(out, "\r\n");
                linelength = 0;
            }
            if (nrest == 2) {
                buf[0] = (byte)((bytes[k] & 0xFC) >> 2);
                buf[1] = (byte)((bytes[k] & 3) << 4 | (bytes[k + 1] & 0xF0) >> 4);
                buf[2] = (byte)((bytes[k + 1] & 0xF) << 2);
            } else if (nrest == 1) {
                buf[0] = (byte)((bytes[k] & 0xFC) >> 2);
                buf[1] = (byte)((bytes[k] & 3) << 4);
            }
            if (nrest > 0) {
                if ((linelength += 4) >= 76) {
                    SOSMimeBase64.send(out, "\r\n");
                }
                SOSMimeBase64.send(out, BaseTable[buf[0]]);
                SOSMimeBase64.send(out, BaseTable[buf[1]]);
                if (nrest == 2) {
                    SOSMimeBase64.send(out, BaseTable[buf[2]]);
                } else {
                    SOSMimeBase64.send(out, "=");
                }
                SOSMimeBase64.send(out, "=");
            }
            out.flush();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void send(BufferedWriter out, String s) {
        try {
            out.write(s);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

