/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.commons.cli;

import com.sos.yade.commons.Yade;
import com.sos.yade.commons.result.YadeTransferResult;
import com.sos.yade.commons.result.YadeTransferResultEntry;
import com.sos.yade.commons.result.YadeTransferResultProtocol;
import com.sos.yade.commons.result.YadeTransferResultSerializer;
import java.io.BufferedWriter;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransferHistory {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
    private static final String ENV_VAR_JS7_RETURN_VALUES = "JS7_RETURN_VALUES";
    private static final String ENV_VAR_JS1_RETURN_VALUES = "SCHEDULER_RETURN_VALUES";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 0;
    private static final int EXIT_STATUS_SUCCESS = 0;
    private static final int EXIT_STATUS_ERROR = 0;
    private static String DELIMITER = ",";
    private static String HOSTNAME;
    private static List<String> UNKNOWN_OPTIONS;
    private static List<String> EMPTY_OPTIONS;
    private static List<String> PARSE_ERRORS;

    public static void main(String[] args) {
        int exitStatus = 0;
        if (args.length == 0 || args.length == 1 && args[0].trim().matches("|-h|--help")) {
            TransferHistory.displayUsage();
        } else {
            exitStatus = TransferHistory.process(args);
        }
        System.exit(exitStatus);
    }

    private static int process(String[] args) {
        UNKNOWN_OPTIONS = new ArrayList<String>();
        EMPTY_OPTIONS = new ArrayList<String>();
        PARSE_ERRORS = new ArrayList<String>();
        YadeTransferResult result = new YadeTransferResult();
        YadeTransferResultProtocol source = new YadeTransferResultProtocol();
        YadeTransferResultProtocol target = new YadeTransferResultProtocol();
        ArrayList<String> entries = new ArrayList<String>();
        boolean hasTarget = false;
        boolean displayUsage = false;
        boolean displayArgs = false;
        boolean displayResult = false;
        boolean dryRun = false;
        block43: for (String arg : args) {
            String[] arr = arg.split("=");
            String pn = arr[0];
            String pv = arr.length > 1 ? TransferHistory.getValue(arr[1].trim()) : "";
            switch (pn) {
                case "-h": 
                case "--help": {
                    displayUsage = true;
                    continue block43;
                }
                case "--display-args": {
                    displayArgs = true;
                    continue block43;
                }
                case "--display-result": {
                    displayResult = true;
                    continue block43;
                }
                case "--dry-run": {
                    displayArgs = true;
                    displayResult = true;
                    dryRun = true;
                    continue block43;
                }
                case "--operation": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    result.setOperation(TransferHistory.getOperation(arg, pv));
                    continue block43;
                }
                case "--start-time": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    result.setStart(TransferHistory.toInstant(arg, pv));
                    continue block43;
                }
                case "--end-time": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    result.setEnd(TransferHistory.toInstant(arg, pv));
                    continue block43;
                }
                case "--error": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                        result.setErrorMessage(null);
                        continue block43;
                    }
                    result.setErrorMessage(pv);
                    continue block43;
                }
                case "--source-protocol": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    source.setProtocol(TransferHistory.getProtocol(arg, pv));
                    continue block43;
                }
                case "--source-account": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    source.setAccount(TransferHistory.getAccount(pv));
                    continue block43;
                }
                case "--source-host": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    source.setHost(pv);
                    continue block43;
                }
                case "--source-port": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    source.setPort(TransferHistory.getPort(arg, pv));
                    continue block43;
                }
                case "--target-protocol": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    target.setProtocol(TransferHistory.getProtocol(arg, pv));
                    hasTarget = true;
                    continue block43;
                }
                case "--target-account": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    target.setAccount(TransferHistory.getAccount(pv));
                    hasTarget = true;
                    continue block43;
                }
                case "--target-host": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    target.setHost(pv);
                    hasTarget = true;
                    continue block43;
                }
                case "--target-port": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                    }
                    target.setPort(TransferHistory.getPort(arg, pv));
                    hasTarget = true;
                    continue block43;
                }
                case "--delimiter": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                        continue block43;
                    }
                    DELIMITER = pv;
                    continue block43;
                }
                case "--transfer-file": {
                    if (TransferHistory.isEmpty(pv)) {
                        EMPTY_OPTIONS.add(pn);
                        continue block43;
                    }
                    entries.add(pv);
                    continue block43;
                }
                default: {
                    UNKNOWN_OPTIONS.add(arg);
                }
            }
        }
        if (displayUsage) {
            TransferHistory.displayUsage();
        }
        if (displayArgs) {
            TransferHistory.displayArguments(args);
        }
        if (UNKNOWN_OPTIONS.size() > 0) {
            System.out.println(String.format("[%s][unknown options]%s", TransferHistory.class.getSimpleName(), String.join((CharSequence)", ", UNKNOWN_OPTIONS)));
        }
        if (EMPTY_OPTIONS.size() > 0) {
            System.out.println(String.format("[%s][empty options]%s", TransferHistory.class.getSimpleName(), String.join((CharSequence)", ", EMPTY_OPTIONS)));
        }
        if (PARSE_ERRORS.size() > 0) {
            System.out.println(String.format("[%s][invalid values]%s", TransferHistory.class.getSimpleName(), String.join((CharSequence)", ", PARSE_ERRORS)));
        }
        try {
            YadeTransferResultSerializer<YadeTransferResult> serializer = new YadeTransferResultSerializer<YadeTransferResult>();
            String serialized = serializer.serialize(TransferHistory.complete(result, source, hasTarget ? target : null, entries));
            if (displayResult) {
                TransferHistory.displayResult(serializer, serialized);
            }
            if (!dryRun) {
                String returnValues = System.getenv(ENV_VAR_JS7_RETURN_VALUES);
                if (returnValues == null && (returnValues = System.getenv(ENV_VAR_JS1_RETURN_VALUES)) == null) {
                    System.err.println("Missing environment variable: JS7_RETURN_VALUES or SCHEDULER_RETURN_VALUES");
                    return 0;
                }
                TransferHistory.serialize2File(returnValues, serialized);
            }
            return 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static void serialize2File(String returnValues, String serialized) throws Exception {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(returnValues, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            writer.write("yade_return_values" + "=" + serialized + System.lineSeparator());
            writer.flush();
        }
    }

    private static String getValue(String val) {
        if (val.startsWith("\"")) {
            int len = val.length();
            int end = -1;
            if (len > 1 && val.endsWith("\"")) {
                end = len - 1;
            }
            return end > 0 ? val.substring(1, end) : val.substring(1);
        }
        return val;
    }

    private static boolean getBoolean(String val, boolean defaultValue) {
        boolean result = defaultValue;
        if (!TransferHistory.isEmpty(val)) {
            try {
                result = Boolean.parseBoolean(val);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private static YadeTransferResult complete(YadeTransferResult result, YadeTransferResultProtocol source, YadeTransferResultProtocol target, List<String> entries) {
        if (TransferHistory.isEmpty(result.getOperation())) {
            result.setOperation(Yade.TransferOperation.COPY.value());
        }
        Yade.TransferOperation operation = Yade.TransferOperation.fromValue(result.getOperation());
        if (result.getStart() == null) {
            result.setStart(Instant.now());
        }
        if (result.getEnd() == null) {
            result.setEnd(Instant.now());
        }
        result.setSource(TransferHistory.complete("--source-", source));
        if (target == null) {
            switch (operation) {
                case COPY: 
                case COPYFROMINTERNET: 
                case COPYTOINTERNET: 
                case RENAME: 
                case MOVE: {
                    target = new YadeTransferResultProtocol();
                    target.setProtocol(source.getProtocol());
                    target.setHost(source.getHost());
                    target.setPort(source.getPort());
                    target.setAccount(source.getAccount());
                    result.setTarget(target);
                    break;
                }
            }
        } else {
            result.setTarget(TransferHistory.complete("--target-", target));
        }
        result.setEntries(TransferHistory.complete(operation, entries));
        return result;
    }

    private static List<YadeTransferResultEntry> complete(Yade.TransferOperation operation, List<String> entries) {
        ArrayList<YadeTransferResultEntry> r = new ArrayList<YadeTransferResultEntry>();
        for (String e : entries) {
            r.add(TransferHistory.getEntry(operation, e));
        }
        return r;
    }

    private static Instant toInstant(String arg, String val) {
        String dateTime = val;
        String format = null;
        switch (val.length()) {
            case 24: {
                dateTime = dateTime.replace(' ', 'T');
                format = "yyyy-MM-dd'T'HH:mm:ssZ";
                break;
            }
            default: {
                format = "yyyy-MM-dd HH:mm:ss";
            }
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(dateTime).toInstant();
        }
        catch (Throwable e) {
            PARSE_ERRORS.add("[" + arg + "]set datetime to now");
            return null;
        }
    }

    private static String getOperation(String arg, String val) {
        try {
            return Yade.TransferOperation.valueOf(val.toUpperCase()).value();
        }
        catch (Throwable e) {
            PARSE_ERRORS.add("[" + arg + "]set operation to UNKNOWN");
            return Yade.TransferOperation.UNKNOWN.value();
        }
    }

    private static String getProtocol(String arg, String val) {
        try {
            return Yade.TransferProtocol.valueOf(val.toUpperCase()).value();
        }
        catch (Throwable e) {
            PARSE_ERRORS.add("[" + arg + "]set protocol to UNKNOWN");
            return Yade.TransferProtocol.UNKNOWN.value();
        }
    }

    private static int getPort(String arg, String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (Throwable e) {
            PARSE_ERRORS.add("[" + arg + "]set port to 0");
            return 0;
        }
    }

    private static String getAccount(String val) {
        return TransferHistory.isEmpty(val) ? "." : val;
    }

    private static YadeTransferResultEntry getEntry(Yade.TransferOperation operation, String val) {
        String[] arr = (String[])Arrays.stream(val.split(DELIMITER, 4)).map(String::trim).toArray(String[]::new);
        YadeTransferResultEntry entry = new YadeTransferResultEntry();
        entry.setSource(arr[0]);
        block2 : switch (arr.length) {
            case 1: {
                switch (operation) {
                    case GETLIST: 
                    case REMOVE: {
                        break block2;
                    }
                }
                entry.setTarget(entry.getSource());
                break;
            }
            case 2: {
                entry.setTarget(arr[1]);
                break;
            }
            case 3: {
                entry.setTarget(arr[1]);
                try {
                    entry.setSize(Long.parseLong(arr[2]));
                }
                catch (Throwable e) {
                    entry.setErrorMessage(arr[2]);
                }
                break;
            }
            case 4: {
                entry.setTarget(arr[1]);
                try {
                    entry.setSize(Long.parseLong(arr[2]));
                    entry.setErrorMessage(arr[3]);
                    break;
                }
                catch (Throwable e) {
                    entry.setErrorMessage(arr[2] + DELIMITER + arr[3]);
                }
            }
        }
        if (TransferHistory.isEmpty(entry.getErrorMessage())) {
            switch (operation) {
                case RENAME: 
                case MOVE: {
                    entry.setState(Yade.TransferEntryState.RENAMED.value());
                    break;
                }
                case REMOVE: {
                    entry.setState(Yade.TransferEntryState.DELETED.value());
                    break;
                }
                default: {
                    entry.setState(Yade.TransferEntryState.TRANSFERRED.value());
                    break;
                }
            }
        } else {
            entry.setState(Yade.TransferEntryState.FAILED.value());
        }
        return entry;
    }

    private static YadeTransferResultProtocol complete(String argPrefix, YadeTransferResultProtocol p) {
        if (p == null) {
            return null;
        }
        if (TransferHistory.isEmpty(p.getHost())) {
            p.setHost(TransferHistory.getHostname());
        }
        if (p.getProtocol() == null || p.getHost().contains("://")) {
            try {
                URL url = new URL(p.getHost());
                if (p.getProtocol() == null) {
                    String pl = url.getProtocol().toLowerCase();
                    if (pl.equals("file")) {
                        p.setProtocol(Yade.TransferProtocol.LOCAL.value());
                    } else {
                        p.setProtocol(Yade.TransferProtocol.fromValue(pl).value());
                    }
                }
                if (!TransferHistory.isEmpty(url.getHost())) {
                    p.setHost(url.getHost());
                }
                if (p.getPort() == null && url.getPort() != -1) {
                    p.setPort(url.getPort());
                }
                if (p.getAccount() == null) {
                    p.setAccount(url.getUserInfo());
                }
            }
            catch (Throwable url) {
                // empty catch block
            }
        }
        if (p.getProtocol() == null) {
            p.setProtocol(Yade.TransferProtocol.LOCAL.value());
        }
        if (p.getPort() == null) {
            String[] arr = p.getHost().split(":");
            if (arr.length > 1) {
                p.setHost(arr[0]);
                p.setPort(TransferHistory.getPort(argPrefix + "host=" + p.getHost(), arr[1]));
            } else {
                p.setPort(0);
            }
        }
        if (p.getAccount() == null) {
            p.setAccount(".");
        }
        return p;
    }

    private static String getHostname() {
        if (HOSTNAME == null) {
            String env = System.getenv(IS_WINDOWS ? "COMPUTERNAME" : "HOSTNAME");
            try {
                HOSTNAME = TransferHistory.isEmpty(env) ? InetAddress.getLocalHost().getHostName() : env;
            }
            catch (Throwable e) {
                HOSTNAME = DEFAULT_HOSTNAME;
            }
        }
        return HOSTNAME;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static void displayUsage() {
        String INDENT = "                                        ";
        System.out.println("Usage: file_transfer_history.sh|.cmd [Options] [Switches] ");
        System.out.println("");
        System.out.println("Options:");
        System.out.print("  --transfer-file=<transfer-spec>    | ");
        System.out.println("optional: the transfer specification can occur any number of times and is made up of the elements:");
        System.out.println(INDENT + "<source-file>,<target-file>[,<file-size>[,<error-message>]]");
        System.out.print("  --operation=<operation-spec>       | ");
        System.out.println("optional: operation to copy, to move, to remove or to get a list of files:");
        System.out.println(INDENT + "copy|move|remove|getlist, default: copy");
        System.out.print("  --source-account=<account>         | ");
        System.out.println("optional: account used for authentication with the system holding source files");
        System.out.print("  --source-protocol=<protocol-spec>  | ");
        System.out.println("optional: one of the protocols for access to source files:");
        System.out.println(INDENT + "local|ftp|ftps|sftp|ssh|http|https|webdav|webdavs|smb, default: local");
        System.out.print("  --source-host=<hostname>           | ");
        System.out.println("optional: hostname, IP address or URL of the host holding source files, default: localhost");
        System.out.print("  --source-port=<number>             | ");
        System.out.println("optional: port used to connect to the system holding source files, default: 0");
        System.out.print("  --target-account=<account>         | ");
        System.out.println("optional: account used for authentication with the system holding target files");
        System.out.print("  --target-protocol=<protocol-spec>  | ");
        System.out.println("optional: one of the protocols for access to target files:");
        System.out.println(INDENT + "local|ftp|ftps|sftp|ssh|http|https|webdav|webdavs|smb, default: local");
        System.out.print("  --target-host=<hostname>           | ");
        System.out.println("optional: hostname, IP address or URL of the host holding target files, default: localhost");
        System.out.print("  --target-port=<number>             | ");
        System.out.println("optional: port used to connect to the system holding target files, default: 0");
        System.out.print("  --start-time=<date-time>           | ");
        System.out.println("optional: ISO date and time for start time of transfer: yyyy-MM-dd hh:mm:ssZ");
        System.out.print("  --end-time=<date-time>             | ");
        System.out.println("optional: ISO date and time for end time of transfer: yyyy-MM-dd hh:mm:ssZ, default: current time");
        System.out.print("  --error=<string>                   | ");
        System.out.println("optional: error message indicating a failed file transfer");
        System.out.print("  --delimiter=<character>            | ");
        System.out.println("optional: delimiter character for entries in the transfer specification, default: comma");
        System.out.println("");
        System.out.println("Switches:");
        System.out.print("  -h | --help                        | ");
        System.out.println("displays usage");
        System.out.print("  --display-args                     | ");
        System.out.println("displays command line arguments");
        System.out.print("  --display-result                   | ");
        System.out.println("displays execution result");
        System.out.print("  --dry-run                          | ");
        System.out.println("sets --display-args and --display-result and does not create entries for the File Transfer History");
    }

    private static void displayArguments(String[] args) {
        System.out.println(String.format("[%s]Arguments(count=%s):", TransferHistory.class.getSimpleName(), args.length));
        int i = 0;
        for (String arg : args) {
            System.out.println(String.format("  %s)%s", ++i, arg));
        }
    }

    private static void displayResult(YadeTransferResultSerializer<YadeTransferResult> serializer, String serialized) {
        try {
            YadeTransferResult r = serializer.deserialize(serialized);
            TransferHistory.displayMeta(r);
            TransferHistory.displayProtocol("Source:", r.getSource());
            TransferHistory.displayProtocol("Target:", r.getTarget());
            TransferHistory.displayEntries("Entries:", r.getEntries());
        }
        catch (Throwable e) {
            System.err.println(String.format("[%s][can't deserialize result]%s", TransferHistory.class.getSimpleName(), e.toString()));
        }
    }

    private static void displayMeta(YadeTransferResult r) {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        l.add((CallSite)((Object)("Operation=" + r.getOperation())));
        l.add((CallSite)((Object)("Start Time(UTC)=" + r.getStart())));
        l.add((CallSite)((Object)("End Time(UTC)=" + r.getEnd())));
        if (r.getErrorMessage() != null) {
            l.add((CallSite)((Object)("Error=" + r.getErrorMessage())));
        }
        System.out.println(String.format("[%s]Result: %s", TransferHistory.class.getSimpleName(), String.join((CharSequence)", ", l)));
    }

    private static void displayProtocol(String header, YadeTransferResultProtocol p) {
        if (p != null) {
            System.out.println(String.format("  %s Protocol=%s, Host=%s, Port=%s, Account=%s", header, p.getProtocol(), p.getHost(), p.getPort(), p.getAccount()));
        }
    }

    private static void displayEntries(String header, List<YadeTransferResultEntry> entries) {
        if (entries != null && entries.size() > 0) {
            System.out.println("  " + header);
            int i = 0;
            for (YadeTransferResultEntry entry : entries) {
                ++i;
                ArrayList<CallSite> l = new ArrayList<CallSite>();
                l.add((CallSite)((Object)("Source=" + entry.getSource())));
                if (entry.getTarget() != null) {
                    l.add((CallSite)((Object)("Target=" + entry.getTarget())));
                }
                l.add((CallSite)((Object)("Size=" + entry.getSize())));
                l.add((CallSite)((Object)("Status=" + entry.getState())));
                if (!TransferHistory.isEmpty(entry.getErrorMessage())) {
                    l.add((CallSite)((Object)("Error=" + entry.getErrorMessage())));
                }
                System.out.println(String.format("    %s)%s", i, String.join((CharSequence)", ", l)));
            }
        }
    }
}

