/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.common;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSPathUtil;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.util.common.SOSEnv;
import com.sos.commons.util.common.SOSTimeout;
import com.sos.commons.util.common.logger.ISOSLogger;
import com.sos.commons.vfs.common.AProviderArguments;
import com.sos.commons.vfs.common.AProviderContext;
import com.sos.commons.vfs.common.IProvider;
import com.sos.commons.vfs.common.file.ProviderFile;
import com.sos.commons.vfs.common.file.ProviderFileBuilder;
import com.sos.commons.vfs.common.file.files.RenameFilesResult;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelectionConfig;
import com.sos.commons.vfs.exception.SOSProviderConnectException;
import com.sos.commons.vfs.exception.SOSProviderException;
import com.sos.commons.vfs.exception.SOSProviderInitializationException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;

public abstract class AProvider<A extends AProviderArguments>
implements IProvider {
    public static long DEFAULT_FILE_ATTR_VALUE = -1L;
    private final ISOSLogger logger;
    private final A arguments;
    private Function<ProviderFileBuilder, ProviderFile> providerFileCreator = builder -> builder.build(this);
    private AProviderContext context;
    private String accessInfo;

    public AProvider(ISOSLogger logger, A arguments) throws SOSProviderInitializationException {
        this.logger = logger;
        this.arguments = arguments;
    }

    @Override
    public void setProviderFileCreator(Function<ProviderFileBuilder, ProviderFile> val) {
        this.providerFileCreator = val;
    }

    @Override
    public void setContext(AProviderContext val) {
        this.context = val;
    }

    @Override
    public AProviderContext getContext() {
        return this.context;
    }

    @Override
    public void ensureConnected() throws SOSProviderConnectException {
        if (!this.isConnected()) {
            this.connect();
        }
    }

    @Override
    public boolean createDirectoriesIfNotExist(Collection<String> paths) throws SOSProviderException {
        if (SOSCollection.isEmpty(paths)) {
            return false;
        }
        boolean result = false;
        for (String path : paths) {
            if (!this.createDirectoriesIfNotExist(path)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public RenameFilesResult renameFileIfExists(String sourcePath, String targetPath) throws SOSProviderException {
        this.checkParam("renameFileIfExists", sourcePath, "sourcePath");
        this.checkParam("renameFileIfExists", targetPath, "targetPath");
        return this.renameFilesIfExist(Collections.singletonMap(sourcePath, targetPath), true);
    }

    @Override
    public String getDirectoryPath(String path) {
        if (SOSString.isEmpty((String)path)) {
            return null;
        }
        return SOSPathUtil.isUnixStylePathSeparator((String)this.getPathSeparator()) ? SOSPathUtil.getUnixStyleDirectoryWithoutTrailingSeparator((String)path) : SOSPathUtil.getWindowsStyleDirectoryWithoutTrailingSeparator((String)path);
    }

    @Override
    public String getDirectoryPathWithTrailingPathSeparator(String path) {
        if (SOSString.isEmpty((String)path)) {
            return null;
        }
        return SOSPathUtil.isUnixStylePathSeparator((String)this.getPathSeparator()) ? SOSPathUtil.getUnixStyleDirectoryWithTrailingSeparator((String)path) : SOSPathUtil.getWindowsStyleDirectoryWithTrailingSeparator((String)path);
    }

    @Override
    public String toPathStyle(String path) {
        return SOSPathUtil.isUnixStylePathSeparator((String)this.getPathSeparator()) ? SOSPathUtil.toUnixStyle((String)path) : SOSPathUtil.toWindowsStyle((String)path);
    }

    @Override
    public SOSCommandResult executeCommand(String command) {
        return this.executeCommand(command, null, null);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout) {
        return this.executeCommand(command, timeout, null);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSEnv env) {
        return this.executeCommand(command, null, env);
    }

    public void setSystemProperties() {
        if (SOSCollection.isEmpty((Collection)((Collection)((AProviderArguments)((Object)this.getArguments())).getSystemPropertyFiles().getValue()))) {
            return;
        }
        String method = "setSystemProperties";
        this.logger.info("%s[%s][files]", new Object[]{this.getLogPrefix(), method, SOSString.join((Collection)((Collection)((AProviderArguments)((Object)this.getArguments())).getSystemPropertyFiles().getValue()), (String)",", f -> f.toString())});
        Properties p = new Properties();
        for (Path file : (List)((AProviderArguments)((Object)this.getArguments())).getSystemPropertyFiles().getValue()) {
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    p.load(reader);
                    this.logger.info("[%s][%s]loaded", new Object[]{method, file});
                }
                catch (Throwable e) {
                    this.logger.warn("[%s][%s][failed]%s", new Object[]{method, file, e.toString()});
                }
                continue;
            }
            this.logger.warn("[%s][%s]does not exist or is not a regular file", new Object[]{method, file});
        }
        for (String n : p.stringPropertyNames()) {
            String v = p.getProperty(n);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[%s]%s=%s", new Object[]{method, n, v});
            }
            System.setProperty(n, v);
        }
    }

    public Function<ProviderFileBuilder, ProviderFile> getProviderFileCreator() {
        return this.providerFileCreator;
    }

    public ProviderFile createProviderFile(String fullPath, long size, long lastModifiedMillis) {
        return this.providerFileCreator.apply(new ProviderFileBuilder().fullPath(fullPath).size(size).lastModifiedMillis(lastModifiedMillis));
    }

    public static ProviderFile createProviderFile(Function<ProviderFileBuilder, ProviderFile> providerFileCreator, String fullPath, long size, long lastModifiedMillis) {
        return providerFileCreator.apply(new ProviderFileBuilder().fullPath(fullPath).size(size).lastModifiedMillis(lastModifiedMillis));
    }

    public List<ProviderFile> selectFiles(String directory) throws SOSProviderException {
        return this.selectFiles(new ProviderFileSelection(new ProviderFileSelectionConfig.Builder().directory(directory).build()));
    }

    public String getLogPrefix() {
        return this.context == null ? "" : this.context.getLogPrefix();
    }

    public String getPathOperationPrefix(String path) {
        return AProvider.getPathOperationPrefix(this.getLogPrefix(), path);
    }

    public static String getPathOperationPrefix(String logPrefix, String path) {
        return logPrefix + "[" + path + "]";
    }

    public void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ISOSLogger getLogger() {
        return this.logger;
    }

    public A getArguments() {
        return this.arguments;
    }

    public static String millis2string(int val) {
        if (val <= 0) {
            return String.valueOf(val).concat("ms");
        }
        try {
            return String.valueOf(Math.round(val / 1000)).concat("s");
        }
        catch (Throwable e) {
            return String.valueOf(val).concat("ms");
        }
    }

    public void checkParam(String method, String paramValue, String msg) throws SOSProviderException {
        if (SOSString.isEmpty((String)paramValue)) {
            throw new SOSProviderException(this.getLogPrefix() + "[" + method + "]" + msg + " missing");
        }
    }

    public static boolean isValidFileSize(long fileSize) {
        return fileSize >= 0L;
    }

    public static boolean isValidModificationTime(long milliseconds) {
        return milliseconds > 0L;
    }

    public void checkModificationTime(String path, long milliseconds) throws SOSProviderException {
        if (!AProvider.isValidModificationTime(milliseconds)) {
            throw new SOSProviderException(this.getLogPrefix() + "[" + path + "][" + milliseconds + "]not valid modification time");
        }
    }

    public String getAccessInfo() {
        return this.accessInfo;
    }

    public void setAccessInfo(String val) {
        this.accessInfo = val;
    }

    public String getConnectMsg() {
        return String.format("%s[connect]%s ...", this.getLogPrefix(), this.accessInfo);
    }

    public String getConnectedMsg() {
        return this.getConnectedMsg(null);
    }

    public String getConnectedMsg(String additionalInfos) {
        String add = SOSString.isEmpty((String)additionalInfos) ? this.accessInfo : "[" + this.accessInfo + "]" + additionalInfos;
        return String.format("%s[connected]%s", this.getLogPrefix(), add);
    }

    public String getDisconnectedMsg() {
        return String.format("%s[disconnected]%s", this.getLogPrefix(), this.accessInfo);
    }
}

