/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.common;

import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.util.common.SOSEnv;
import com.sos.commons.util.common.SOSTimeout;
import com.sos.commons.vfs.common.AProviderContext;
import com.sos.commons.vfs.common.file.ProviderFile;
import com.sos.commons.vfs.common.file.ProviderFileBuilder;
import com.sos.commons.vfs.common.file.files.DeleteFilesResult;
import com.sos.commons.vfs.common.file.files.RenameFilesResult;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exception.SOSProviderConnectException;
import com.sos.commons.vfs.exception.SOSProviderException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface IProvider {
    public void connect() throws SOSProviderConnectException;

    public void ensureConnected() throws SOSProviderConnectException;

    public boolean isConnected();

    public void disconnect();

    public boolean createDirectoriesIfNotExist(String var1) throws SOSProviderException;

    public boolean createDirectoriesIfNotExist(Collection<String> var1) throws SOSProviderException;

    public boolean deleteIfExists(String var1) throws SOSProviderException;

    public DeleteFilesResult deleteFilesIfExist(Collection<String> var1, boolean var2) throws SOSProviderException;

    public RenameFilesResult renameFileIfExists(String var1, String var2) throws SOSProviderException;

    public RenameFilesResult renameFilesIfExist(Map<String, String> var1, boolean var2) throws SOSProviderException;

    public boolean exists(String var1);

    public boolean isDirectory(String var1);

    public boolean isAbsolutePath(String var1);

    public String getDirectoryPath(String var1);

    public String getDirectoryPathWithTrailingPathSeparator(String var1);

    public String toPathStyle(String var1);

    public String getPathSeparator();

    public ProviderFile getFileIfExists(String var1) throws SOSProviderException;

    public ProviderFile rereadFileIfExists(ProviderFile var1) throws SOSProviderException;

    public List<ProviderFile> selectFiles(ProviderFileSelection var1) throws SOSProviderException;

    public String getFileContentIfExists(String var1) throws SOSProviderException;

    public void writeFile(String var1, String var2) throws SOSProviderException;

    public void setFileLastModifiedFromMillis(String var1, long var2) throws SOSProviderException;

    public InputStream getInputStream(String var1) throws SOSProviderException;

    public OutputStream getOutputStream(String var1, boolean var2) throws SOSProviderException;

    public void setProviderFileCreator(Function<ProviderFileBuilder, ProviderFile> var1);

    public void setContext(AProviderContext var1);

    public AProviderContext getContext();

    public SOSCommandResult executeCommand(String var1);

    public SOSCommandResult executeCommand(String var1, SOSTimeout var2);

    public SOSCommandResult executeCommand(String var1, SOSEnv var2);

    public SOSCommandResult executeCommand(String var1, SOSTimeout var2, SOSEnv var3);

    public SOSCommandResult cancelCommands();
}

