/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.common.file.files;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AFileResult {
    private final int totalFiles;
    private int processedFiles = 0;
    private final Set<String> notFound = new LinkedHashSet<String>();
    private final Map<String, Throwable> errors = new LinkedHashMap<String, Throwable>();

    public AFileResult(int totalFiles) {
        this.totalFiles = totalFiles;
    }

    public void addSuccess() {
        ++this.processedFiles;
    }

    public void addNotFound(String path) {
        this.notFound.add(path);
    }

    public void addError(String path, Throwable error) {
        this.errors.put(path, error);
    }

    public boolean allProcessed() {
        return this.errors.isEmpty() && this.processedFiles + this.notFound.size() == this.totalFiles;
    }

    public Map<String, Throwable> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getTotalFiles() {
        return this.totalFiles;
    }

    public int getProcessedFiles() {
        return this.processedFiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("total_files=").append(this.totalFiles);
        sb.append("(processed=").append(this.processedFiles);
        if (!this.notFound.isEmpty()) {
            sb.append(",not_found=").append(String.join((CharSequence)" ,", this.notFound));
        }
        if (this.hasErrors()) {
            sb.append(",errors=").append(this.errors);
        }
        sb.append(")");
        return sb.toString();
    }
}

