/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.local;

import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSPathUtil;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.util.common.SOSEnv;
import com.sos.commons.util.common.SOSTimeout;
import com.sos.commons.util.common.logger.ISOSLogger;
import com.sos.commons.vfs.common.AProvider;
import com.sos.commons.vfs.common.file.ProviderFile;
import com.sos.commons.vfs.common.file.files.DeleteFilesResult;
import com.sos.commons.vfs.common.file.files.RenameFilesResult;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exception.SOSProviderConnectException;
import com.sos.commons.vfs.exception.SOSProviderException;
import com.sos.commons.vfs.exception.SOSProviderInitializationException;
import com.sos.commons.vfs.local.common.LocalProviderArguments;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LocalProvider
extends AProvider<LocalProviderArguments> {
    public LocalProvider(ISOSLogger logger, LocalProviderArguments arguments) throws SOSProviderInitializationException {
        super(logger, arguments);
        if (((LocalProviderArguments)((Object)this.getArguments())).getCredentialStore() != null) {
            // empty if block
        }
    }

    @Override
    public void connect() throws SOSProviderConnectException {
        block2: {
            try {
                ((LocalProviderArguments)((Object)this.getArguments())).getHost().setValue((Object)SOSShell.getHostname());
            }
            catch (UnknownHostException e) {
                ((LocalProviderArguments)((Object)this.getArguments())).getHost().setValue((Object)"UNKNOWN_HOST");
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug("%s[connect]%s", new Object[]{this.getLogPrefix(), e.toString()});
            }
        }
        ((LocalProviderArguments)((Object)this.getArguments())).getUser().setValue((Object)SOSShell.getUsername());
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean createDirectoriesIfNotExist(String path) throws SOSProviderException {
        this.checkParam("createDirectoriesIfNotExist", path, "path");
        try {
            Path p = this.getPath(path);
            if (this.exists(p)) {
                return false;
            }
            Files.createDirectories(p, new FileAttribute[0]);
            return true;
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteIfExists(String path) throws SOSProviderException {
        this.checkParam("deleteIfExists", path, "path");
        try {
            return SOSPath.deleteIfExists((Path)this.getPath(path));
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public DeleteFilesResult deleteFilesIfExist(Collection<String> files, boolean stopOnSingleFileError) throws SOSProviderException {
        if (files == null) {
            return null;
        }
        DeleteFilesResult r = new DeleteFilesResult(files.size());
        for (String file : files) {
            try {
                Path path = this.getPath(file);
                if (this.exists(path)) {
                    SOSPath.delete((Path)path);
                    r.addSuccess();
                    continue;
                }
                r.addNotFound(file);
            }
            catch (Throwable e) {
                r.addError(file, e);
                if (!stopOnSingleFileError) continue;
                break;
            }
        }
        return r;
    }

    @Override
    public RenameFilesResult renameFilesIfExist(Map<String, String> files, boolean stopOnSingleFileError) throws SOSProviderException {
        if (files == null) {
            return null;
        }
        RenameFilesResult r = new RenameFilesResult(files.size());
        for (Map.Entry<String, String> entry : files.entrySet()) {
            String source = entry.getKey();
            String target = entry.getValue();
            try {
                Path p = this.getPath(source);
                if (this.exists(p)) {
                    SOSPath.renameTo((Path)p, (Path)this.getPath(target));
                    r.addSuccess(source, target);
                    continue;
                }
                r.addNotFound(source);
            }
            catch (Throwable e) {
                r.addError(source, e);
                if (!stopOnSingleFileError) continue;
                break;
            }
        }
        return r;
    }

    @Override
    public boolean exists(String path) {
        try {
            this.checkParam("exists", path, "path");
            return this.exists(this.getPath(path));
        }
        catch (Throwable e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[exists=false]%s", new Object[]{this.getPathOperationPrefix(path), e.toString()});
            }
            return false;
        }
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws SOSProviderException {
        Path directory = Paths.get((selection = ProviderFileSelection.createIfNull(selection)).getConfig().getDirectory() == null ? "" : selection.getConfig().getDirectory(), new String[0]);
        List<ProviderFile> result = selection.getConfig().isRecursive() ? this.selectFilesRecursive(selection, directory) : this.selectFilesNonRecursive(selection, directory);
        return result;
    }

    @Override
    public ProviderFile getFileIfExists(String path) throws SOSProviderException {
        this.checkParam("getFileIfExists", path, "path");
        Path p = this.getPath(path);
        ProviderFile file = null;
        try {
            BasicFileAttributes attr = this.readFileAttributes(p);
            if (attr != null) {
                file = this.createProviderFile(p.toString(), attr.size(), this.getFileLastModifiedMillis(attr));
            }
        }
        catch (NoSuchFileException attr) {
        }
        catch (IOException e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
        return file;
    }

    @Override
    public ProviderFile rereadFileIfExists(ProviderFile file) throws SOSProviderException {
        try {
            BasicFileAttributes attr = this.readFileAttributes(Paths.get(file.getFullPath(), new String[0]));
            if (attr != null) {
                file.setSize(attr.size());
                file.setLastModifiedMillis(this.getFileLastModifiedMillis(attr));
            }
        }
        catch (NoSuchFileException e) {
            file = null;
        }
        catch (IOException e) {
            throw new SOSProviderException(this.getPathOperationPrefix(file.getFullPath()), e);
        }
        return file;
    }

    @Override
    public boolean isDirectory(String path) {
        try {
            this.checkParam("isDirectory", path, "path");
            return SOSPath.isDirectory((String)path);
        }
        catch (Throwable e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[isDirectory=false]%s", new Object[]{this.getPathOperationPrefix(path), e.toString()});
            }
            return false;
        }
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws SOSProviderException {
        this.checkParam("setFileLastModifiedFromMillis", path, "path");
        this.checkModificationTime(path, milliseconds);
        try {
            SOSPath.setLastModifiedFromMillis((String)path, (long)milliseconds);
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        return SOSShell.executeCommand((String)command, (SOSTimeout)timeout, (SOSEnv)env);
    }

    @Override
    public SOSCommandResult cancelCommands() {
        return new SOSCommandResult("nop");
    }

    @Override
    public InputStream getInputStream(String path) throws SOSProviderException {
        try {
            return Files.newInputStream(this.getPath(path), new OpenOption[0]);
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws SOSProviderException {
        try {
            Path p = this.getPath(path);
            if (append) {
                return Files.newOutputStream(p, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            return Files.newOutputStream(p, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public String getFileContentIfExists(String path) throws SOSProviderException {
        try {
            Path p = this.getPath(path);
            if (!this.exists(p)) {
                return null;
            }
            return SOSPath.readFile((Path)p);
        }
        catch (IOException e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void writeFile(String path, String content) throws SOSProviderException {
        try {
            SOSPath.overwrite((Path)this.getPath(path), (String)content);
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public String getPathSeparator() {
        return FileSystems.getDefault().getSeparator();
    }

    @Override
    public boolean isAbsolutePath(String path) {
        return SOSPathUtil.isAbsoluteFileSystemPath((String)path);
    }

    @Override
    public String getDirectoryPath(String path) {
        if (SOSString.isEmpty((String)path)) {
            return null;
        }
        return super.getDirectoryPath(SOSPath.toAbsoluteNormalizedPath((String)path).toString());
    }

    @Override
    public String getDirectoryPathWithTrailingPathSeparator(String path) {
        if (SOSString.isEmpty((String)path)) {
            return null;
        }
        return super.getDirectoryPathWithTrailingPathSeparator(SOSPath.toAbsoluteNormalizedPath((String)path).toString());
    }

    private Path getPath(String path) {
        return SOSPath.toAbsoluteNormalizedPath((String)path);
    }

    private boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    private ProviderFile createProviderFile(Path path) throws IOException {
        Path np = path.toAbsolutePath().normalize();
        BasicFileAttributes attr = this.readFileAttributes(np);
        if (attr == null) {
            return null;
        }
        return this.createProviderFile(np.toString(), attr.size(), this.getFileLastModifiedMillis(attr));
    }

    private BasicFileAttributes readFileAttributes(Path path) throws IOException {
        BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        if (attr.isRegularFile() || attr.isSymbolicLink()) {
            return attr;
        }
        return null;
    }

    private long getFileLastModifiedMillis(BasicFileAttributes attr) {
        return attr.lastModifiedTime().to(TimeUnit.MILLISECONDS);
    }

    private List<ProviderFile> selectFilesRecursive(final ProviderFileSelection selection, Path directory) throws SOSProviderException {
        final boolean isDebugEnabled = this.getLogger().isDebugEnabled();
        final boolean isTraceEnabled = this.getLogger().isTraceEnabled();
        final ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                int counterAdded = 0;

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                    if (selection.maxFilesExceeded(this.counterAdded)) {
                        if (isDebugEnabled) {
                            LocalProvider.this.getLogger().debug((Object)String.format("%s[skip][preVisitDirectory][maxFiles=%s]exceeded", LocalProvider.this.getPathOperationPrefix(path.toString()), selection.getConfig().getMaxFiles()));
                        }
                        return FileVisitResult.TERMINATE;
                    }
                    if (selection.checkDirectory(path.toAbsolutePath().toString())) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (isDebugEnabled) {
                        LocalProvider.this.getLogger().debug((Object)String.format("%s[preVisitDirectory][match][excludedDirectories=%s]", LocalProvider.this.getPathOperationPrefix(path.toString()), selection.getConfig().getExcludedDirectoriesPattern().pattern()));
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (!attrs.isDirectory()) {
                        ProviderFile file;
                        String fileName;
                        if (selection.maxFilesExceeded(this.counterAdded)) {
                            if (isDebugEnabled) {
                                LocalProvider.this.getLogger().debug((Object)String.format("%s[skip][preVisitDirectory][maxFiles=%s]exceeded", LocalProvider.this.getPathOperationPrefix(path.toString()), selection.getConfig().getMaxFiles()));
                            }
                            return FileVisitResult.TERMINATE;
                        }
                        if (isTraceEnabled) {
                            LocalProvider.this.getLogger().trace((Object)String.format("%s[visitFile]", LocalProvider.this.getPathOperationPrefix(path.toString())));
                        }
                        if (selection.checkFileName(fileName = path.getFileName().toString()) && selection.checkProviderFileMinMaxSize(file = LocalProvider.this.createProviderFile(path))) {
                            ++this.counterAdded;
                            file.setIndex(this.counterAdded);
                            result.add(file);
                            if (isDebugEnabled) {
                                LocalProvider.this.getLogger().debug((Object)(LocalProvider.this.getPathOperationPrefix(path.toString()) + "added"));
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new SOSProviderException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ProviderFile> selectFilesNonRecursive(ProviderFileSelection selection, Path directory) throws SOSProviderException {
        boolean isDebugEnabled = this.getLogger().isDebugEnabled();
        boolean isTraceEnabled = this.getLogger().isTraceEnabled();
        if (isDebugEnabled) {
            this.getLogger().debug((Object)SOSString.toString((Object)selection.getConfig(), (boolean)true));
        }
        ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
        int counterAdded = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            Iterator<Path> iterator = stream.iterator();
            while (iterator.hasNext()) {
                ProviderFile file;
                String fileName;
                Path path = iterator.next();
                if (selection.maxFilesExceeded(counterAdded)) {
                    if (isDebugEnabled) {
                        this.getLogger().debug((Object)String.format("%s[skip][preVisitDirectory][maxFiles=%s]exceeded", this.getPathOperationPrefix(path.toString()), selection.getConfig().getMaxFiles()));
                    }
                    ArrayList<ProviderFile> arrayList = result;
                    return arrayList;
                }
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                if (isTraceEnabled) {
                    this.getLogger().trace((Object)this.getPathOperationPrefix(path.toString()));
                }
                if (!selection.checkFileName(fileName = path.getFileName().toString()) || !selection.checkProviderFileMinMaxSize(file = this.createProviderFile(path))) continue;
                file.setIndex(++counterAdded);
                result.add(file);
                if (!isDebugEnabled) continue;
                this.getLogger().debug((Object)(this.getPathOperationPrefix(path.toString()) + "added"));
            }
            return result;
        }
        catch (IOException e) {
            throw new SOSProviderException(e);
        }
    }
}

