/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.sshj;

import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.logger.ISOSLogger;
import com.sos.commons.vfs.common.AProvider;
import com.sos.commons.vfs.common.file.ProviderFile;
import com.sos.commons.vfs.common.file.ProviderFileBuilder;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exception.SOSProviderException;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveRunner;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.linguafranca.pwdb.Entry;

public class SSHJProviderUtil {
    protected static KeyProvider getKeyProviderFromKeepass(SSHClient sshClient, SSHProviderArguments args) throws Exception {
        SOSKeePassDatabase kd = args.getKeepassDatabase();
        if (kd == null) {
            throw new Exception("[keepass]keepass_database property is null");
        }
        Entry<?, ?, ?, ?> ke = args.getKeepassDatabaseEntry();
        if (ke == null) {
            throw new Exception(String.format("[keepass][can't find database entry]attachment property name=%s", args.getKeepassAttachmentPropertyName()));
        }
        try {
            String pk = new String(kd.getAttachment(ke, args.getKeepassAttachmentPropertyName()), "UTF-8");
            return sshClient.loadKeys(pk, null, SOSString.isEmpty((String)((String)args.getPassphrase().getValue())) ? null : SSHJProviderUtil.getPasswordFinder((String)args.getPassphrase().getValue()));
        }
        catch (Exception e) {
            String keePassPath = ke.getPath() + "@" + args.getKeepassAttachmentPropertyName();
            throw new Exception(String.format("[keepass][%s]%s", keePassPath, e.toString()), e);
        }
    }

    protected static PasswordFinder getPasswordFinder(final String password) {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return (char[])password.toCharArray().clone();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }

    protected static boolean is(ISOSLogger logger, String logPrefix, SFTPClient sftp, String path, FileMode.Type type) {
        block3: {
            try {
                FileAttributes attr = sftp.stat(path);
                if (attr != null) {
                    return type.equals((Object)attr.getType());
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("%s[is][%s][type=%s]%s", new Object[]{logPrefix, path, type, e.toString()});
            }
        }
        return false;
    }

    protected static void throwException(SFTPException e, String msg) throws Exception {
        Response.StatusCode sc = e.getStatusCode();
        if (sc != null && (sc.equals((Object)Response.StatusCode.NO_SUCH_FILE) || sc.equals((Object)Response.StatusCode.NO_SUCH_PATH))) {
            throw new SOSNoSuchFileException(msg, (Throwable)e);
        }
        throw e;
    }

    protected static void dirInfo(SFTPClient sftp, String path, Deque<RemoteResourceInfo> result, boolean recursive) throws Exception {
        List infos = sftp.ls(path);
        for (RemoteResourceInfo resource : infos) {
            result.push(resource);
            if (!recursive || !resource.isDirectory()) continue;
            SSHJProviderUtil.dirInfo(sftp, resource.getPath(), result, recursive);
        }
    }

    protected static List<String> getConnectedInfos(SSHClient ssh) {
        KeepAlive r;
        ArrayList<String> msg = new ArrayList<String>();
        if (ssh.getTimeout() > 0 || ssh.getConnectTimeout() > 0) {
            msg.add("ConnectTimeout=" + AProvider.millis2string(ssh.getConnectTimeout()) + ", SocketTimeout=" + AProvider.millis2string(ssh.getTimeout()));
        }
        if (ssh.getConnection() != null && (r = ssh.getConnection().getKeepAlive()).getKeepAliveInterval() > 0) {
            if (r instanceof KeepAliveRunner) {
                msg.add("KeepAliveInterval=" + r.getKeepAliveInterval() + "s, MaxAliveCount=" + ((KeepAliveRunner)r).getMaxAliveCount());
            } else {
                msg.add("KeepAliveInterval=" + r.getKeepAliveInterval() + "s");
            }
        }
        return msg;
    }

    protected static long getFileLastModifiedMillis(FileAttributes attr) {
        return attr.getMtime() * 1000L;
    }

    protected static boolean isFileType(FileMode.Type t) {
        return FileMode.Type.REGULAR.equals((Object)t) || FileMode.Type.SYMLINK.equals((Object)t);
    }

    protected static void delete(SFTPClient sftp, String path) throws Exception {
        try {
            path = sftp.canonicalize(path);
        }
        catch (SFTPException e) {
            SSHJProviderUtil.throwException(e, path);
        }
        FileAttributes attr = sftp.stat(path);
        switch (attr.getType()) {
            case DIRECTORY: {
                SSHJProviderUtil.deleteDirectories(sftp, path);
                break;
            }
            case REGULAR: {
                sftp.rm(path);
                break;
            }
        }
    }

    private static void deleteDirectories(SFTPClient sftp, String path) throws Exception {
        LinkedList<RemoteResourceInfo> toRemove = new LinkedList<RemoteResourceInfo>();
        SSHJProviderUtil.dirInfo(sftp, path, toRemove, true);
        while (!toRemove.isEmpty()) {
            RemoteResourceInfo resource = (RemoteResourceInfo)toRemove.pop();
            if (resource.isDirectory()) {
                sftp.rmdir(resource.getPath());
                continue;
            }
            if (!resource.isRegularFile()) continue;
            sftp.rm(resource.getPath());
        }
        sftp.rmdir(path);
    }

    protected static boolean exists(SFTPClient sftp, String path) throws IOException {
        return sftp.statExistence(path) != null;
    }

    protected static List<ProviderFile> selectFiles(ISOSLogger logger, boolean isDebugEnabled, String logPrefix, SSHClient ssh, Function<ProviderFileBuilder, ProviderFile> providerFileCreator, ProviderFileSelection selection, String directoryPath, List<ProviderFile> result) throws SOSProviderException {
        int counterAdded = 0;
        try (SFTPClient sftp = ssh.newSFTPClient();){
            SSHJProviderUtil.list(logger, isDebugEnabled, logPrefix, sftp, providerFileCreator, selection, directoryPath, result, counterAdded);
        }
        catch (Throwable e) {
            throw new SOSProviderException(e);
        }
        return result;
    }

    private static int list(ISOSLogger logger, boolean isDebugEnabled, String logPrefix, SFTPClient sftp, Function<ProviderFileBuilder, ProviderFile> providerFileCreator, ProviderFileSelection selection, String directoryPath, List<ProviderFile> result, int counterAdded) throws SOSProviderException {
        try {
            List subDirInfos = sftp.ls(directoryPath);
            for (RemoteResourceInfo subResource : subDirInfos) {
                if (selection.maxFilesExceeded(counterAdded)) {
                    return counterAdded;
                }
                counterAdded = SSHJProviderUtil.processListEntry(logger, isDebugEnabled, logPrefix, sftp, providerFileCreator, selection, subResource, result, counterAdded);
            }
        }
        catch (Throwable e) {
            throw new SOSProviderException(e);
        }
        return counterAdded;
    }

    private static int processListEntry(ISOSLogger logger, boolean isDebugEnabled, String logPrefix, SFTPClient sftp, Function<ProviderFileBuilder, ProviderFile> providerFileCreator, ProviderFileSelection selection, RemoteResourceInfo resource, List<ProviderFile> result, int counterAdded) throws SOSProviderException {
        if (resource.isDirectory()) {
            if (selection.getConfig().isRecursive() && selection.checkDirectory(resource.getPath())) {
                counterAdded = SSHJProviderUtil.list(logger, isDebugEnabled, logPrefix, sftp, providerFileCreator, selection, resource.getPath(), result, counterAdded);
            }
        } else {
            ProviderFile file;
            String fileName;
            FileAttributes attr = resource.getAttributes();
            if (attr != null && SSHJProviderUtil.isFileType(attr.getType()) && selection.checkFileName(fileName = resource.getName()) && selection.checkProviderFileMinMaxSize(file = AProvider.createProviderFile(providerFileCreator, resource.getPath(), attr.getSize(), SSHJProviderUtil.getFileLastModifiedMillis(attr)))) {
                file.setIndex(++counterAdded);
                result.add(file);
                if (isDebugEnabled) {
                    logger.debug((Object)(AProvider.getPathOperationPrefix(logPrefix, file.getFullPath()) + "added"));
                }
            }
        }
        return counterAdded;
    }

    protected static void put(SFTPClient sftp, String source, String target) throws IOException {
        sftp.put((LocalSourceFile)new FileSystemFile(source), target);
    }

    protected static void rename(SFTPClient sftp, String sourcePath, String targetPath) throws Exception {
        try {
            sourcePath = sftp.canonicalize(sourcePath);
        }
        catch (SFTPException e) {
            SSHJProviderUtil.throwException(e, sourcePath);
        }
        sftp.rename(sourcePath, targetPath);
    }
}

