#! /bin/sh
#  ------------------------------------------------------------
#  Company: Software- und Organisations-Service GmbH
#  Purpose: Watchdog script for JS7 Agent
#  ------------------------------------------------------------

set -e
JS7_AGENT_EXIT=0

start_agent() 
{
  JS7_AGENT_PID=0
  HTTPS_PORT_OPTION=""
  test -z "${JS7_AGENT_HTTPS_PORT}" || HTTPS_PORT_OPTION="--https-port=${JS7_AGENT_HTTPS_PORT}"
  
  echo "\"${JAVABIN}\" -DJS7.Agent=\"${JS7_AGENT_PORT}\" ${JS7_AGENT_JAVA_OPTIONS} -classpath \"${JS7_AGENT_CLASSPATH}\" js7.agent.main.AgentMain --http-port=\"${JS7_AGENT_HTTP_PORT}\" ${HTTPS_PORT_OPTION} --config-directory=\"${JS7_AGENT_CONFIG_DIR}\" --data-directory=\"${JS7_AGENT_DATA}\" --job-working-directory=\"${JS7_AGENT_WORK_DIR}\""
  test -z "${JS7_AGENT_KILL_SCRIPT}" || echo "--kill-script option is not longer supported"
  
  "${JAVABIN}" -DJS7.Agent="${JS7_AGENT_PORT}" ${JS7_AGENT_JAVA_OPTIONS} -classpath "${JS7_AGENT_CLASSPATH}" js7.agent.main.AgentMain --http-port="${JS7_AGENT_HTTP_PORT}" ${HTTPS_PORT_OPTION} --config-directory="${JS7_AGENT_CONFIG_DIR}" --data-directory="${JS7_AGENT_DATA}" --job-working-directory="${JS7_AGENT_WORK_DIR}" &
  JS7_AGENT_EXIT=$?
  
  if [ "${JS7_AGENT_EXIT}" = "0" ]
  then
    create_pid_file $!
    JS7_AGENT_PID=$!
    echo "...JS7 Agent(${JS7_AGENT_PORT}) is started with pid=${JS7_AGENT_PID}!"
    echo "...see log file ${JS7_AGENT_LOGS}/agent.log"
    echo "...watchdog for pid ${JS7_AGENT_PID} is started"
    echo "Hit ENTER to return to command prompt."
    wait "${JS7_AGENT_PID}" 2>/dev/null || JS7_AGENT_EXIT=$?
  fi
  
  echo "...JS7 Agent terminates with exit code ${JS7_AGENT_EXIT}"
  
  call_crash_pid_file_killer "${JS7_AGENT_PID}"
  
  rm "${JS7_AGENT_PID_FILE}" >/dev/null 2>/dev/null || true
  
  #abort and restart
  if [ "${JS7_AGENT_EXIT}" = "98" ]
  then
    start_agent
  fi
  #terminate and restart
  if [ "${JS7_AGENT_EXIT}" = "97" ]
  then
    start_agent
  fi 
}

call_crash_pid_file_killer()
{
  JS7_AGENT_PID=$1
  if [ "$(cat "${JS7_AGENT_DATA}/state/lock" 2>/dev/null || echo "0")" -eq "${JS7_AGENT_PID}" ] && [ -s "${JS7_AGENT_CRASH_FILE}" ]
  then
  	JS7_AGENT_SIGKILL_DELAY=$(read_sigkill_delay_file)
  	test -z "${JS7_AGENT_SIGKILL_DELAY}" && JS7_AGENT_SIGKILL_DELAY="${JS7_AGENT_SIGKILL_DELAY_DEFAULT}"
    "${JAVABIN}" -Xmx100m -classpath "${JS7_AGENT_CLASSPATH}" js7.launcher.crashpidfile.CrashPidFileKiller --data-directory="${JS7_AGENT_DATA}" --sigkill-delay="${JS7_AGENT_SIGKILL_DELAY}" || true
  fi
}

create_pid_file() 
{
  JS7_AGENT_PID=$1
  echo "${JS7_AGENT_PID}" > "${JS7_AGENT_PID_FILE}" || true
  if [ ! -f "${JS7_AGENT_PID_FILE}" ]
  then
    echo "...could not create pid file: \"${JS7_AGENT_PID_FILE}\""
    echo "...please check permissions for directory: \"${JS7_AGENT_PID_FILE_DIR}\"."
    exit 3
  else
    chmod 666 "${JS7_AGENT_PID_FILE}" 2>/dev/null || true
  fi 
}

read_sigkill_delay_file()
{
  if [ -f "${JS7_AGENT_SIGKILL_DELAY_FILE}" ]
  then
    cat "${JS7_AGENT_SIGKILL_DELAY_FILE}"
  else
    echo "${JS7_AGENT_SIGKILL_DELAY}"
  fi 
	
}

without_watchdog()
{
  test -z "${JS7_WITHOUT_WATCHDOG}" && return 1
  return "${JS7_WITHOUT_WATCHDOG}"
}

if without_watchdog
then
  start_agent
else
  start_agent > "${JS7_AGENT_LOGS}/watchdog.log" 2>&1
fi

set +e
exit ${JS7_AGENT_EXIT}