/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.model;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.javadsl.model.ContentType;
import org.apache.pekko.http.javadsl.model.HttpEntity;
import org.apache.pekko.http.javadsl.model.HttpHeader;
import org.apache.pekko.http.javadsl.model.HttpProtocol;
import org.apache.pekko.http.javadsl.model.RequestEntity;
import org.apache.pekko.http.javadsl.model.ResponseEntity;
import org.apache.pekko.http.javadsl.model.headers.HttpCredentials;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.util.ByteString;

@DoNotInherit
public interface HttpMessage {
    public boolean isRequest();

    public boolean isResponse();

    public HttpProtocol protocol();

    public Iterable<HttpHeader> getHeaders();

    public Optional<HttpHeader> getHeader(String var1);

    public <T extends HttpHeader> Optional<T> getHeader(Class<T> var1);

    public <T extends HttpHeader> Iterable<T> getHeaders(Class<T> var1);

    public <T> Optional<T> getAttribute(AttributeKey<T> var1);

    public ResponseEntity entity();

    public DiscardedEntity discardEntityBytes(Materializer var1);

    public DiscardedEntity discardEntityBytes(ClassicActorSystemProvider var1);

    public static interface MessageTransformations<Self> {
        public Self withProtocol(HttpProtocol var1);

        public Self addHeader(HttpHeader var1);

        public Self addHeaders(Iterable<HttpHeader> var1);

        public Self withHeaders(Iterable<HttpHeader> var1);

        public <T> Self addAttribute(AttributeKey<T> var1, T var2);

        public Self addCredentials(HttpCredentials var1);

        public Self removeHeader(String var1);

        public Self removeAttribute(AttributeKey<?> var1);

        public Self withEntity(String var1);

        public Self withEntity(byte[] var1);

        public Self withEntity(ByteString var1);

        public Self withEntity(ContentType.NonBinary var1, String var2);

        public Self withEntity(ContentType var1, byte[] var2);

        public Self withEntity(ContentType var1, ByteString var2);

        public Self withEntity(ContentType var1, File var2);

        public Self withEntity(ContentType var1, Path var2);

        public Self withEntity(RequestEntity var1);

        public <T> Self transformEntityDataBytes(Graph<FlowShape<ByteString, ByteString>, T> var1);

        public CompletionStage<? extends Self> toStrict(long var1, Executor var3, Materializer var4);

        public CompletionStage<? extends Self> toStrict(long var1, long var3, Executor var5, Materializer var6);

        public CompletionStage<? extends Self> toStrict(long var1, ClassicActorSystemProvider var3);

        public CompletionStage<? extends Self> toStrict(long var1, long var3, ClassicActorSystemProvider var5);
    }

    public static interface DiscardedEntity
    extends HttpEntity.DiscardedEntity {
    }
}

