/*
 * Decompiled with CFR 0.152.
 */
package com.sos.keepass;

import com.google.common.base.Splitter;
import com.sos.keepass.SOSKeePassDatabase;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import sos.util.SOSString;

public class SOSKeePassPath {
    public static final String PATH_PREFIX = "cs://";
    public static final String PROPERTY_PREFIX = "@";
    public static final String QUERY_PARAMETER_FILE = "file";
    public static final String QUERY_PARAMETER_KEY_FILE = "key_file";
    public static final String QUERY_PARAMETER_PASSWORD = "password";
    public static final String QUERY_PARAMETER_IGNORE_EXPIRED = "ignore_expired";
    public static final String QUERY_PARAMETER_ATTACHMENT = "attachment";
    public static final String QUERY_PARAMETER_CREATE_ENTRY = "create_entry";
    public static final String QUERY_PARAMETER_SET_PROPERTY = "set_property";
    public static final String QUERY_PARAMETER_STDOUT_ON_SET_BINARY_PROPERTY = "stdout_on_set_binary_property";
    public static final String QUERY_PARAMETER_MODULE = "module";
    private static final String MASK_QUERY_PARAMETERS_REGEX_SPLITTER = "'&'";
    private static final String MASK_QUERY_PARAMETERS_REGEX_KEY_VALUE_SEPARATOR = "'='";
    private static final String MASK_QUERY_PARAMETERS_REPLACEMENT_SPLITTER = "_XXX_";
    private static final String MASK_QUERY_PARAMETERS_REPLACEMENT_KEY_VALUE_SEPARATOR = "_YYY_";
    private boolean _isKdbx;
    private boolean _valid;
    private String _entry;
    private String _entryPath;
    private String _propertyName;
    private String _originalPropertyName;
    private String _query;
    private Map<String, String> _queryParameters;
    private String _error;

    public SOSKeePassPath(String uri) {
        int t;
        if (SOSString.isEmpty((String)uri)) {
            this._error = "missing uri";
            return;
        }
        int n = t = uri == null ? -1 : uri.indexOf("?");
        if (t < 0 || uri.endsWith("?")) {
            this._error = "missing query parameters";
            return;
        }
        this._query = uri.substring(t + 1, uri.length());
        Map maskedMap = Collections.emptyMap();
        try {
            maskedMap = Splitter.on((char)'&').withKeyValueSeparator("=").split((CharSequence)this.mask(this._query));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LinkedHashMap unmaskedMap = new LinkedHashMap();
        maskedMap.forEach((k, v) -> unmaskedMap.put(k, this.unmask((String)v)));
        this._queryParameters = Collections.unmodifiableMap(unmaskedMap);
        String file = this._queryParameters.get(QUERY_PARAMETER_FILE);
        if (SOSString.isEmpty((String)file)) {
            this._error = String.format("missing query parameter '%s'", QUERY_PARAMETER_FILE);
        } else {
            this.parse(SOSKeePassDatabase.isKdbx(file), uri.substring(0, t), null);
        }
    }

    private String mask(String val) {
        return val.replaceAll(MASK_QUERY_PARAMETERS_REGEX_SPLITTER, MASK_QUERY_PARAMETERS_REPLACEMENT_SPLITTER).replaceAll(MASK_QUERY_PARAMETERS_REGEX_KEY_VALUE_SEPARATOR, MASK_QUERY_PARAMETERS_REPLACEMENT_KEY_VALUE_SEPARATOR);
    }

    private String unmask(String val) {
        return val.replaceAll(MASK_QUERY_PARAMETERS_REPLACEMENT_SPLITTER, MASK_QUERY_PARAMETERS_REGEX_SPLITTER).replaceAll(MASK_QUERY_PARAMETERS_REPLACEMENT_KEY_VALUE_SEPARATOR, MASK_QUERY_PARAMETERS_REGEX_KEY_VALUE_SEPARATOR);
    }

    public SOSKeePassPath(boolean isKdbx, String path) {
        this(isKdbx, path, null);
    }

    public SOSKeePassPath(boolean isKdbx, String path, String entryPath) {
        this.parse(isKdbx, path, entryPath);
    }

    private void parse(boolean isKdbx, String path, String entryPath) {
        this._isKdbx = isKdbx;
        if (path == null || !path.startsWith(PATH_PREFIX) || !path.contains(PROPERTY_PREFIX)) {
            this._error = String.format("is empty or not starts with '%s' or not contains '%s'", PATH_PREFIX, PROPERTY_PREFIX);
            return;
        }
        String[] arr = path.substring(PATH_PREFIX.length() - 1).split(PROPERTY_PREFIX);
        switch (arr.length) {
            case 2: {
                this.setEntryPath(arr[0], entryPath, isKdbx);
                this.setPropertyName(arr[1]);
                if (this._entry == null) break;
                this._valid = true;
            }
        }
    }

    public static boolean hasKeePassVariables(String command) {
        return command != null && command.contains("${cs://");
    }

    private void setEntryPath(String path, String entryPath, boolean isKdbx) {
        if (path.equals("/")) {
            this._entry = SOSString.isEmpty((String)entryPath) ? null : entryPath;
        } else {
            String string = this._entry = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        }
        if (this._entry != null) {
            this._entryPath = isKdbx ? this._entry : "/Root" + this._entry;
        }
    }

    private void setPropertyName(String name) {
        this._originalPropertyName = name;
        this._propertyName = SOSKeePassDatabase.getPropertyName(this._originalPropertyName);
    }

    public boolean isKdbx() {
        return this._isKdbx;
    }

    public boolean isValid() {
        return this._valid;
    }

    public String getEntry() {
        return this._entry;
    }

    public String getEntryPath() {
        return this._entryPath;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public String getOriginalPropertyName() {
        return this._originalPropertyName;
    }

    public String getQuery() {
        return this._query;
    }

    public Map<String, String> getQueryParameters() {
        return this._queryParameters;
    }

    public String getError() {
        return this._error;
    }

    public boolean isIgnoreExpired() {
        return this.getBooleanValue(QUERY_PARAMETER_IGNORE_EXPIRED);
    }

    public boolean isCreateEntry() {
        return this.getBooleanValue(QUERY_PARAMETER_CREATE_ENTRY);
    }

    public boolean isAttachment() {
        return this.getBooleanValue(QUERY_PARAMETER_ATTACHMENT);
    }

    public boolean isStdoutOnSetBinaryProperty() {
        return this.getBooleanValue(QUERY_PARAMETER_STDOUT_ON_SET_BINARY_PROPERTY);
    }

    private boolean getBooleanValue(String paramName) {
        String val;
        return this._queryParameters != null && (val = this._queryParameters.get(paramName)) != null && (val.equals("1") || val.equals("true"));
    }

    public String toString() {
        if (!this._valid) {
            return "";
        }
        return this._entry + PROPERTY_PREFIX + this._propertyName;
    }
}

