/*
 * Decompiled with CFR 0.152.
 */
package com.sos.keepass.db.kdb;

import com.sos.keepass.SOSKeePassDatabase;
import com.sos.keepass.SOSKeePassPath;
import com.sos.keepass.db.ASOSKeePassHandler;
import com.sos.keepass.exceptions.SOSKeePassAttachmentException;
import com.sos.keepass.exceptions.SOSKeePassCredentialException;
import com.sos.keepass.exceptions.SOSKeePassDatabaseException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.kdb.KdbCredentials;
import org.linguafranca.pwdb.kdb.KdbDatabase;
import org.linguafranca.pwdb.kdb.KdbEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSKdbHandler
extends ASOSKeePassHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSKdbHandler.class);
    public static final String KDB_GROUP_TITLE = "Meta-Info";
    public static final String KDB_ROOT_GROUP_NAME = "Root";

    @Override
    public boolean isKdbx() {
        return false;
    }

    @Override
    public void load(String pass, Path keyFile) throws SOSKeePassDatabaseException {
        this.setCredentials(this.getCredentials(pass, keyFile));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[load]%s", SOSKeePassDatabase.getFilePath(this.getKeePassFile())));
        }
        KdbDatabase database = null;
        InputStream is = null;
        try {
            is = Files.newInputStream(this.getKeePassFile(), new OpenOption[0]);
            database = KdbDatabase.load((Credentials)this.getCredentials(), (InputStream)is);
        }
        catch (Throwable e) {
            throw new SOSKeePassDatabaseException(String.format("[%s]%s", SOSKeePassDatabase.getFilePath(this.getKeePassFile()), e.toString()), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.setDatabase((Database<?, ?, ?, ?>)database);
    }

    private Credentials getCredentials(String pass, Path keyFile) throws SOSKeePassDatabaseException {
        String method = "getCredentials";
        KdbCredentials.Password cred = null;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        if (keyFile == null) {
            if (SOSString.isEmpty((String)pass)) {
                throw new SOSKeePassCredentialException("The password for the database must not be null. Please provide a valid password.");
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]pass=?", method));
            }
            try {
                cred = new KdbCredentials.Password(pass.getBytes());
            }
            catch (Throwable e) {
                throw new SOSKeePassCredentialException(e);
            }
        }
        if (SOSString.isEmpty((String)pass)) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]keyFile=%s", method, SOSKeePassDatabase.getFilePath(keyFile)));
            }
            throw new SOSKeePassCredentialException("Composite key with key file without master password is not supported for KeePass 1.x format. Please provide a valid password.");
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]pass=?, keyFile=%s", method, SOSKeePassDatabase.getFilePath(keyFile)));
        }
        InputStream is = null;
        try {
            is = Files.newInputStream(keyFile, new OpenOption[0]);
            cred = new KdbCredentials.KeyFile(pass.getBytes(), is);
        }
        catch (Throwable e) {
            throw new SOSKeePassCredentialException(String.format("[%s]%s", SOSKeePassDatabase.getFilePath(keyFile), e.toString()), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return cred;
    }

    @Override
    public List<? extends Entry<?, ?, ?, ?>> getEntries() {
        if (this.getDatabase() == null) {
            return null;
        }
        return this.getDatabase().findEntries(new Entry.Matcher(){

            public boolean matches(Entry entry) {
                return !entry.getTitle().equals(SOSKdbHandler.KDB_GROUP_TITLE);
            }
        });
    }

    @Override
    public Entry<?, ?, ?, ?> getEntryByPath(final String path) {
        if (this.getDatabase() == null || path == null) {
            return null;
        }
        List l = this.getDatabase().findEntries(new Entry.Matcher(){

            public boolean matches(Entry entry) {
                String p = path.startsWith("/") ? path : "/" + path;
                return entry.getPath().equals("/Root" + p);
            }
        });
        return l == null || l.size() == 0 ? null : (Entry)l.get(0);
    }

    @Override
    public byte[] getBinaryProperty(Entry<?, ?, ?, ?> entry, String propertyName) throws SOSKeePassAttachmentException {
        try {
            return ((KdbEntry)entry).getBinaryData();
        }
        catch (Throwable e) {
            throw new SOSKeePassAttachmentException(e);
        }
    }

    @Override
    public Entry<?, ?, ?, ?> createEntry(String entryPath) throws SOSKeePassDatabaseException {
        throw new SOSKeePassDatabaseException(".kdx format is not yet supported");
    }

    @Override
    public void saveAs(Path file) throws SOSKeePassDatabaseException {
        throw new SOSKeePassDatabaseException(".kdx format is not yet supported");
    }

    @Override
    public Entry<?, ?, ?, ?> setBinaryProperty(SOSKeePassPath path, Entry<?, ?, ?, ?> entry, Path attachment) throws SOSKeePassDatabaseException {
        throw new SOSKeePassDatabaseException(".kdx format is not yet supported");
    }

    @Override
    public Entry<?, ?, ?, ?> setProperty(Entry<?, ?, ?, ?> entry, String name, String value) throws SOSKeePassDatabaseException {
        throw new SOSKeePassDatabaseException(".kdx format is not yet supported");
    }
}

