/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum NodeTransitionType {
    SUCCESS("SUCCESS"),
    KEEP("KEEP"),
    PROCEEDING("PROCEEDING"),
    ERROR("ERROR");

    private final String value;
    private static final Map<String, NodeTransitionType> CONSTANTS;

    private NodeTransitionType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static NodeTransitionType fromValue(String value) {
        NodeTransitionType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, NodeTransitionType>();
        for (NodeTransitionType c : NodeTransitionType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

