/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.job;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sos.classes.Latin1ToUtf8;
import com.sos.joc.model.calendar.Calendar;
import com.sos.joc.model.joe.schedule.RunTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"job", "runTime", "runTimeXml", "calendars"})
public class ModifyJob {
    @JsonProperty(value="job")
    @JsonPropertyDescription(value="absolute path based on live folder of a JobScheduler object.")
    private String job;
    @JsonProperty(value="runTime")
    private RunTime runTime;
    @JsonProperty(value="runTimeXml")
    @JsonPropertyDescription(value="A run_time xml is expected which is specified in the <xsd:complexType name='run_time'> element of  http://www.sos-berlin.com/schema/scheduler.xsd")
    private String runTimeXml;
    @JsonProperty(value="calendars")
    private List<Calendar> calendars = new ArrayList<Calendar>();

    @JsonProperty(value="job")
    public String getJob() {
        return this.job;
    }

    @JsonProperty(value="job")
    public void setJob(String job) {
        this.job = Latin1ToUtf8.convert(job);
    }

    @JsonProperty(value="runTime")
    public RunTime getRunTime() {
        return this.runTime;
    }

    @JsonProperty(value="runTime")
    public void setRunTime(RunTime runTime) {
        this.runTime = runTime;
    }

    @JsonProperty(value="runTimeXml")
    public String getRunTimeXml() {
        return this.runTimeXml;
    }

    @JsonProperty(value="runTimeXml")
    public void setRunTimeXml(String runTimeXml) {
        this.runTimeXml = runTimeXml;
    }

    @JsonProperty(value="calendars")
    public List<Calendar> getCalendars() {
        return this.calendars;
    }

    @JsonProperty(value="calendars")
    public void setCalendars(List<Calendar> calendars) {
        this.calendars = calendars;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("job", (Object)this.job).append("runTime", (Object)this.runTime).append("runTimeXml", (Object)this.runTimeXml).append("calendars", this.calendars).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.runTime).append((Object)this.job).append((Object)this.runTimeXml).append(this.calendars).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ModifyJob)) {
            return false;
        }
        ModifyJob rhs = (ModifyJob)other;
        return new EqualsBuilder().append((Object)this.runTime, (Object)rhs.runTime).append((Object)this.job, (Object)rhs.job).append((Object)this.runTimeXml, (Object)rhs.runTimeXml).append(this.calendars, rhs.calendars).isEquals();
    }
}

