/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.job;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TaskCause {
    NONE("NONE"),
    MIN_TASKS("MIN_TASKS"),
    PERIOD_ONCE("PERIOD_ONCE"),
    PERIOD_SINGLE("PERIOD_SINGLE"),
    PERIOD_REPEAT("PERIOD_REPEAT"),
    QUEUE("QUEUE"),
    QUEUE_AT("QUEUE_AT"),
    DIRECTORY("DIRECTORY"),
    DELAY_AFTER_ERROR("DELAY_AFTER_ERROR"),
    ORDER("ORDER");

    private final String value;
    private static final Map<String, TaskCause> CONSTANTS;

    private TaskCause(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TaskCause fromValue(String value) {
        TaskCause constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TaskCause>();
        for (TaskCause c : TaskCause.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

