/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.mail;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.credentialstore.exceptions.SOSCredentialStoreException;
import com.sos.commons.mail.SOSMailAttachment;
import com.sos.commons.mail.SOSMailAuthenticator;
import com.sos.commons.util.SOSString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSMail {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMail.class);
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    public static final String PROPERTY_NAME_SMTP_HOST = "mail.smtp.host";
    public static final String PROPERTY_NAME_SMTP_PORT = "mail.smtp.port";
    public static final String PROPERTY_NAME_SMTP_USER = "mail.smtp.user";
    public static final String PROPERTY_NAME_SMTP_PASSWORD = "mail.smtp.password";
    private CredentialStoreArguments credentialStoreArguments;
    protected String subject = "";
    protected String from;
    protected String fromName;
    protected String replyTo;
    protected String queueDir;
    protected String body = "";
    protected String alternativeBody;
    protected String language = "de";
    protected String dateFormat = "dd.MM.yyyy";
    protected String datetimeFormat = "dd.MM.yyyy HH:mm";
    protected HashMap<String, String> dateFormats = new HashMap();
    protected HashMap<String, String> datetimeFormats = new HashMap();
    protected String attachmentCharset = "iso-8859-1";
    protected String charset = "iso-8859-1";
    protected String alternativeCharset = "iso-8859-1";
    protected String contentType = "text/plain";
    protected String alternativeContentType = "text/html";
    protected String encoding = "7bit";
    protected String alternativeEncoding = "7bit";
    protected String attachmentEncoding = "Base64";
    protected String attachmentContentType = "application/octet-stream";
    protected LinkedList<String> toList = new LinkedList();
    protected LinkedList<String> ccList = new LinkedList();
    protected LinkedList<String> bccList = new LinkedList();
    protected TreeMap<String, SOSMailAttachment> attachmentList = new TreeMap();
    private boolean sendToOutputStream = false;
    private byte[] messageBytes;
    private MimeMessage message = null;
    private SOSMailAuthenticator authenticator = null;
    private final ArrayList<FileInputStream> fileInputStreams = new ArrayList();
    private ByteArrayOutputStream rawEmailByteStream = null;
    private String lastError = "";
    private boolean changed = false;
    private final String queuePattern = "yyyy-MM-dd.HHmmss.S";
    private String queuePraefix = "sos.";
    private String lastGeneratedFileName = "";
    private String loadedMessageId = "";
    private boolean messageReady = false;
    private boolean queueMailOnError = true;
    private int priority = -1;
    private String securityProtocol = "";
    private Session session = null;
    private Properties smtpProperties = null;

    public SOSMail(Properties smtpProperties) throws Exception {
        if (smtpProperties != null && smtpProperties.getProperty(PROPERTY_NAME_SMTP_USER) != null && smtpProperties.getProperty(PROPERTY_NAME_SMTP_USER).isEmpty()) {
            smtpProperties.remove(PROPERTY_NAME_SMTP_USER);
            if (smtpProperties.getProperty(PROPERTY_NAME_SMTP_PASSWORD) != null) {
                smtpProperties.remove(PROPERTY_NAME_SMTP_PASSWORD);
            }
        }
        this.smtpProperties = smtpProperties;
    }

    public SOSMail(String smtpHost) throws Exception {
        this.smtpProperties = new Properties();
        this.setHost(smtpHost);
        this.init();
    }

    public SOSMail(String smtpHost, String smtpUser, String smtpUserPassword) throws Exception {
        this.smtpProperties = new Properties();
        this.setHost(smtpHost);
        if (!SOSString.isEmpty((String)smtpUser)) {
            this.setUser(smtpUser);
            this.setPassword(smtpUserPassword);
        }
        this.init();
    }

    public SOSMail(String smtpHost, String smtpPort, String smtpUser, String smtpUserPassword) throws Exception {
        this.smtpProperties = new Properties();
        this.setHost(smtpHost);
        this.setPort(smtpPort);
        if (!SOSString.isEmpty((String)smtpUser)) {
            this.setUser(smtpUser);
            this.setPassword(smtpUserPassword);
        }
        this.init();
    }

    private void initPriority() throws MessagingException {
        switch (this.priority) {
            case 1: {
                this.setPriorityHighest();
                break;
            }
            case 2: {
                this.setPriorityHigh();
                break;
            }
            case 4: {
                this.setPriorityLow();
                break;
            }
            case 5: {
                this.setPriorityLowest();
                break;
            }
        }
    }

    public void init() throws Exception {
        this.dateFormats.put("de", "dd.MM.yyyy");
        this.dateFormats.put("en", "MM/dd/yyyy");
        this.datetimeFormats.put("de", "dd.MM.yyyy HH:mm");
        this.datetimeFormats.put("en", "MM/dd/yyyy HH:mm");
        this.initLanguage();
        this.initMessage();
        this.clearRecipients();
        this.clearAttachments();
    }

    private void initMessage() throws Exception {
        this.createMessage(this.createSession());
        this.initPriority();
    }

    private Session createSession() throws Exception {
        Properties props = null;
        props = this.smtpProperties == null ? System.getProperties() : this.smtpProperties;
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.class", "com.sun.mail.SMTPTransport");
        if (!SOSString.isEmpty((String)this.getUser())) {
            props.put("mail.smtp.auth", "true");
        } else {
            props.put("mail.smtp.auth", "false");
        }
        if ("ssl".equalsIgnoreCase(this.securityProtocol)) {
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.transport.protocol", "smtps");
        } else if ("starttls".equalsIgnoreCase(this.securityProtocol)) {
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.transport.protocol", "smtps");
        }
        this.authenticator = new SOSMailAuthenticator(this.getUser(), this.getPassword());
        this.session = Session.getInstance((Properties)props, (Authenticator)this.authenticator);
        return this.session;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) throws Exception {
        this.securityProtocol = securityProtocol;
        this.initMessage();
    }

    private void createMessage(Session session) throws Exception {
        this.message = new MimeMessage(session);
    }

    private void initLanguage() throws Exception {
        if (this.dateFormats.containsKey(this.getLanguage()) && this.datetimeFormats.containsKey(this.getLanguage())) {
            this.setDateFormat(this.dateFormats.get(this.getLanguage()).toString());
            this.setDatetimeFormat(this.datetimeFormats.get(this.getLanguage()).toString());
        } else {
            this.setDateFormat(this.dateFormats.get("de").toString());
            this.setDatetimeFormat(this.datetimeFormats.get("de").toString());
        }
    }

    public void addRecipient(String recipient) throws Exception {
        String token = "";
        this.warn("addRecipient", recipient);
        if (recipient == null) {
            throw new Exception("recipient has no value.");
        }
        recipient = recipient.replace(',', ';');
        StringTokenizer t = new StringTokenizer(recipient, ";");
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            if (!this.toList.contains(token)) {
                this.toList.add(token);
            }
            LOGGER.debug("TO=" + token);
        }
        this.changed = true;
    }

    public void addCC(String recipient) throws Exception {
        String token = "";
        this.warn("addCC", recipient);
        if (recipient == null) {
            throw new Exception("CC recipient has no value.");
        }
        recipient = recipient.replace(',', ';');
        StringTokenizer t = new StringTokenizer(recipient, ";");
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            if (!this.toList.contains(token) && !this.ccList.contains(token)) {
                this.ccList.add(token);
                LOGGER.debug("CC=" + token);
                continue;
            }
            LOGGER.debug("CC=" + token + " ignored");
        }
        this.changed = true;
    }

    public void addBCC(String recipient) throws Exception {
        String token = "";
        this.warn("addBCC", recipient);
        if (recipient == null) {
            throw new Exception("BCC recipient has no value.");
        }
        recipient = recipient.replace(',', ';');
        StringTokenizer t = new StringTokenizer(recipient, ";");
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            if (!(this.ccList.contains(token) || this.toList.contains(token) || this.bccList.contains(token))) {
                this.bccList.add(token);
                LOGGER.debug("BCC=" + token);
                continue;
            }
            LOGGER.debug("BCC=" + token + " ignored");
        }
        this.changed = true;
    }

    private void closeAttachments() throws Exception {
        Exception exception = null;
        for (int i = 0; i < this.fileInputStreams.size(); ++i) {
            try {
                this.fileInputStreams.get(i).close();
                continue;
            }
            catch (Exception x) {
                if (exception != null) continue;
                exception = x;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void addAttachment(SOSMailAttachment att) throws Exception {
        this.warn("addAttachment", att.getFile().getAbsolutePath());
        this.attachmentList.put(att.getFile().getAbsolutePath(), att);
        this.changed = true;
    }

    public void addAttachment(String filename) throws Exception {
        this.warn("addAttachment", filename);
        File f = new File(filename);
        SOSMailAttachment att = new SOSMailAttachment(this, f);
        att.setCharset(this.getAttachmentCharset());
        att.setEncoding(this.getAttachmentEncoding());
        att.setContentType(this.getAttachmentContentType());
        this.attachmentList.put(filename, att);
        this.changed = true;
    }

    public void addAttachment(String filename, String params) throws Exception {
        String name = "";
        String value = "";
        String token = "";
        int counter = 0;
        this.warn("addAttachment", filename + "(" + params + ")");
        StringTokenizer t = new StringTokenizer(params, ",");
        File f = new File(filename);
        SOSMailAttachment att = new SOSMailAttachment(this, f);
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            StringTokenizer vv = new StringTokenizer(token, "=");
            if (vv.countTokens() == 1) {
                name = "content-type";
                value = vv.nextToken();
                ++counter;
            } else {
                name = vv.nextToken().trim();
                try {
                    value = vv.nextToken().trim();
                }
                catch (NoSuchElementException e) {
                    value = "";
                }
            }
            if ("content-type".equalsIgnoreCase(name)) {
                att.setContentType(value);
            } else if ("charset".equalsIgnoreCase(name)) {
                att.setCharset(value);
            } else if ("encoding".equalsIgnoreCase(name)) {
                att.setEncoding(value);
            } else {
                throw new Exception("USING of .addAttachment is wrong. ==> " + params + ", rigth using is: [content-type-value],[content-type=<value>],[charset=<value>],[encoding=<value>]");
            }
            if (counter <= 1) continue;
            throw new Exception("USING of .addAttachment is wrong. ==> " + params + ", rigth using is: [content-type-value],[content-type=<value>],[charset=<value>],[encoding=<value>]");
        }
        this.attachmentList.put(filename, att);
        this.changed = true;
    }

    private void checkFileCanRead(File file) throws IOException {
        try {
            FileReader fileReader = new FileReader(file.getAbsolutePath());
            fileReader.read();
            fileReader.close();
        }
        catch (IOException e) {
            throw new IOException("Error attachment check file:" + e.getMessage());
        }
    }

    private void addFile(SOSMailAttachment att) throws Exception {
        Object m;
        this.checkFileCanRead(att.getFile());
        MimeBodyPart attachment = new MimeBodyPart();
        FileDataSource data_source = new FileDataSource(att.getFile(), att.getContentType());
        DataHandler data_handler = new DataHandler((DataSource)data_source);
        attachment.setDataHandler(data_handler);
        attachment.setFileName(att.getFile().getName());
        if (att.getContentType().startsWith("text/")) {
            int c;
            Object s = "";
            FileReader fr = new FileReader(att.getFile());
            while ((c = fr.read()) != -1) {
                s = (String)s + (char)c;
            }
            attachment.setText((String)s, att.getCharset());
            fr.close();
        }
        if (!((m = this.message.getContent()) instanceof MimeMultipart)) {
            throw new RuntimeException(this.getClass().getName() + "mime_message.getContent() is not MimeMultiPart");
        }
        ((MimeMultipart)m).addBodyPart((BodyPart)attachment);
        attachment.setHeader("Content-Transfer-Encoding", att.getEncoding());
    }

    public void loadFile(File messageFile) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(messageFile);
            this.message = new MimeMessage(this.createSession(), (InputStream)fis);
            this.loadedMessageId = this.message.getMessageID();
            this.rawEmailByteStream = new ByteArrayOutputStream();
            this.message.writeTo((OutputStream)this.rawEmailByteStream);
            this.messageBytes = this.rawEmailByteStream.toByteArray();
            this.messageReady = true;
        }
    }

    public void unloadMessage() {
        this.messageReady = false;
        this.loadedMessageId = "";
        this.message = null;
    }

    public boolean send(boolean send) throws Exception {
        if (send) {
            return this.send();
        }
        return this.prepareJavaMail();
    }

    public boolean send() throws Exception {
        return this.sendJavaMail();
    }

    private boolean sendJavaMail() throws Exception {
        this.useCredentialStoreArguments();
        String host = this.getHost();
        if (SOSString.isEmpty((String)host)) {
            throw new Exception("host is empty");
        }
        String port = this.getPort();
        try {
            String bcc;
            this.prepareJavaMail();
            String portMsg = port == null ? "<java default port>" : port;
            StringBuilder msg = new StringBuilder("sending email: host:port=").append(host).append(":").append(portMsg);
            msg.append(" to=").append(this.getRecipientsAsString());
            String cc = this.getCCsAsString();
            if (!"".equals(cc)) {
                msg.append(" CC=").append(cc);
            }
            if (!"".equals(bcc = this.getBCCsAsString())) {
                msg.append(" BCC=").append(bcc);
            }
            LOGGER.info(msg.toString());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Subject=" + this.subject);
                LOGGER.debug(this.dumpHeaders());
                LOGGER.debug(this.dumpMessageAsString(false));
            }
            if (!this.sendToOutputStream) {
                Transport transport = "ssl".equalsIgnoreCase(this.securityProtocol) || "starttls".equalsIgnoreCase(this.securityProtocol) ? this.session.getTransport("smtps") : this.session.getTransport("smtp");
                this.message.setSentDate(new Date());
                if (this.smtpProperties == null) {
                    if (port != null) {
                        System.setProperty(PROPERTY_NAME_SMTP_PORT, port);
                    }
                    System.setProperty(PROPERTY_NAME_SMTP_HOST, host);
                } else {
                    if (port != null) {
                        this.smtpProperties.setProperty(PROPERTY_NAME_SMTP_PORT, port);
                    }
                    this.smtpProperties.setProperty(PROPERTY_NAME_SMTP_HOST, host);
                }
                if (SOSString.isEmpty((String)this.getUser())) {
                    transport.connect();
                } else {
                    transport.connect(host, this.getUser(), this.getPassword());
                }
                transport.sendMessage((Message)this.message, this.message.getAllRecipients());
                transport.close();
                this.rawEmailByteStream = new ByteArrayOutputStream();
                this.message.writeTo((OutputStream)this.rawEmailByteStream);
                this.messageBytes = this.rawEmailByteStream.toByteArray();
                this.changed = true;
            }
            return true;
        }
        catch (AuthenticationFailedException ee) {
            this.lastError = String.format("%s while connecting to %s:%s %s /******** --> %s", ((Object)((Object)ee)).getClass().getSimpleName(), host, port, this.getUser(), ee.toString());
            if (this.queueMailOnError) {
                try {
                    this.dumpMessageToFile(true);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
                return false;
            }
            throw ee;
        }
        catch (MessagingException e) {
            if (this.queueMailOnError) {
                if (!SOSString.isEmpty((String)this.queueDir) && e.getMessage().startsWith("Could not connect to SMTP host") || e.getMessage().startsWith("Unknown SMTP host") || e.getMessage().startsWith("Read timed out") || e.getMessage().startsWith("Exception reading response")) {
                    this.lastError = String.format("%s ==> %s:%s %s /********", e.getMessage(), host, port, this.getUser());
                    try {
                        this.dumpMessageToFile(true);
                    }
                    catch (Exception ee) {
                        LOGGER.warn(e.getMessage());
                    }
                    return false;
                }
                throw new Exception(String.format("%s occurred on send: %s", ((Object)((Object)e)).getClass().getSimpleName(), e.toString()), e);
            }
            throw e;
        }
        catch (SocketTimeoutException e) {
            if (this.queueMailOnError) {
                if (!SOSString.isEmpty((String)this.queueDir)) {
                    this.lastError = String.format("%s ==> %s:%s %s /********", e.getMessage(), host, port, this.getUser());
                    try {
                        this.dumpMessageToFile(true);
                    }
                    catch (Exception ee) {
                        LOGGER.warn(e.getMessage());
                    }
                    return false;
                }
                throw new Exception(String.format("%s occurred on send: %s", e.getClass().getSimpleName(), e.toString()), e);
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void useCredentialStoreArguments() throws SOSCredentialStoreException {
        if (this.credentialStoreArguments != null && this.credentialStoreArguments.getFile().getValue() != null) {
            CredentialStoreArguments.CredentialStoreResolver r = this.credentialStoreArguments.newResolver();
            this.addMailProperty(PROPERTY_NAME_SMTP_HOST, r.resolve(this.getHost()));
            String user = r.resolve(this.getUser());
            if (SOSString.isEmpty((String)user)) {
                if (this.smtpProperties != null) {
                    if (this.smtpProperties.getProperty(PROPERTY_NAME_SMTP_USER) != null) {
                        this.smtpProperties.remove(PROPERTY_NAME_SMTP_USER);
                    }
                    if (this.smtpProperties.getProperty(PROPERTY_NAME_SMTP_PASSWORD) != null) {
                        this.smtpProperties.remove(PROPERTY_NAME_SMTP_PASSWORD);
                    }
                }
            } else {
                this.addMailProperty(PROPERTY_NAME_SMTP_USER, user);
                this.addMailProperty(PROPERTY_NAME_SMTP_PASSWORD, r.resolve(this.getPassword()));
            }
        }
    }

    private boolean haveAlternative() {
        return !SOSString.isEmpty((String)this.alternativeBody) && this.attachmentList.isEmpty();
    }

    protected boolean prepareJavaMail() throws Exception {
        try {
            ListIterator e;
            int i;
            InternetAddress[] toAddrs;
            if (this.messageReady) {
                this.message.saveChanges();
                return true;
            }
            if (!this.changed) {
                return true;
            }
            this.changed = false;
            this.body = "text/html".equals(this.getContentType()) ? this.body.replaceAll("\\\\n", "<br>") : this.body.replaceAll("\\\\n", "\n");
            String t = "";
            if (this.toList.isEmpty()) {
                throw new Exception("no recipient specified.");
            }
            if (SOSString.isEmpty((String)this.from)) {
                throw new Exception("from is empty.");
            }
            if (!SOSString.isEmpty((String)this.fromName)) {
                this.message.setFrom((Address)new InternetAddress(this.from, this.fromName));
            } else {
                this.message.setFrom((Address)new InternetAddress(this.from));
            }
            this.message.setSentDate(new Date());
            if (!SOSString.isEmpty((String)this.replyTo)) {
                InternetAddress[] fromAddrs = new InternetAddress[]{new InternetAddress(this.replyTo)};
                this.message.setReplyTo((Address[])fromAddrs);
            }
            if (!this.toList.isEmpty()) {
                toAddrs = new InternetAddress[this.toList.size()];
                i = 0;
                e = this.toList.listIterator();
                while (e.hasNext()) {
                    t = (String)e.next();
                    toAddrs[i++] = new InternetAddress(t);
                }
                this.message.setRecipients(MimeMessage.RecipientType.TO, (Address[])toAddrs);
            }
            toAddrs = new InternetAddress[this.ccList.size()];
            i = 0;
            e = this.ccList.listIterator();
            while (e.hasNext()) {
                t = (String)e.next();
                toAddrs[i++] = new InternetAddress(t);
            }
            this.message.setRecipients(MimeMessage.RecipientType.CC, (Address[])toAddrs);
            toAddrs = new InternetAddress[this.bccList.size()];
            i = 0;
            e = this.bccList.listIterator();
            while (e.hasNext()) {
                t = (String)e.next();
                toAddrs[i++] = new InternetAddress(t);
            }
            this.message.setRecipients(MimeMessage.RecipientType.BCC, (Address[])toAddrs);
            if (this.subject != null) {
                this.message.setSubject(this.subject);
            }
            if (!this.attachmentList.isEmpty() || !SOSString.isEmpty((String)this.alternativeBody)) {
                MimeBodyPart bodypart = null;
                MimeBodyPart alternativeBodypart = null;
                MimeMultipart multipart = null;
                multipart = this.haveAlternative() ? new MimeMultipart("alternative") : new MimeMultipart();
                bodypart = new MimeBodyPart();
                if (this.contentType.startsWith("text/")) {
                    bodypart.setContent((Object)this.body, this.contentType + ";charset= " + this.charset);
                } else {
                    bodypart.setContent((Object)this.body, this.contentType);
                }
                multipart.addBodyPart((BodyPart)bodypart);
                if (this.haveAlternative()) {
                    alternativeBodypart = new MimeBodyPart();
                    if (this.contentType.startsWith("text/")) {
                        alternativeBodypart.setContent((Object)this.alternativeBody, this.alternativeContentType + ";charset= " + this.alternativeCharset);
                    } else {
                        alternativeBodypart.setContent((Object)this.alternativeBody, this.alternativeContentType);
                    }
                    multipart.addBodyPart((BodyPart)alternativeBodypart);
                }
                this.message.setContent((Multipart)multipart);
                bodypart.setHeader("Content-Transfer-Encoding", this.encoding);
                if (alternativeBodypart != null) {
                    alternativeBodypart.setHeader("Content-Transfer-Encoding", this.alternativeEncoding);
                }
                for (SOSMailAttachment attachment : this.attachmentList.values()) {
                    String content_type = attachment.getContentType();
                    if (content_type == null) {
                        throw new Exception("content_type ist null");
                    }
                    LOGGER.debug("Attachment=" + attachment.getFile());
                    this.addFile(attachment);
                }
            } else {
                this.message.setHeader("Content-Transfer-Encoding", this.encoding);
                if (this.contentType.startsWith("text/")) {
                    this.message.setContent((Object)this.body, this.contentType + "; charset=" + this.charset);
                } else {
                    this.message.setContent((Object)this.body, this.contentType);
                }
            }
            this.message.saveChanges();
            this.closeAttachments();
            return true;
        }
        catch (Exception e) {
            throw new Exception("error occurred on send: " + e.getMessage(), e);
        }
    }

    public String dumpHeaders() throws IOException, MessagingException {
        StringBuilder sb = new StringBuilder();
        Enumeration e = this.message.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            sb.append("\n");
            sb.append(header.getName());
            sb.append(": ");
            sb.append(header.getValue());
        }
        return sb.toString();
    }

    private ByteArrayOutputStream messageRemoveAttachments() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MimeMessage mm = new MimeMessage(this.message);
        Object mmpo = mm.getContent();
        if (mmpo instanceof MimeMultipart) {
            MimeMultipart mmp = (MimeMultipart)mmpo;
            if (mm.isMimeType("multipart/*")) {
                mmp = (MimeMultipart)mm.getContent();
                for (int i = 1; i < mmp.getCount(); ++i) {
                    mmp.removeBodyPart(i);
                    --i;
                }
            }
            mm.setContent((Multipart)mmp);
            mm.saveChanges();
        }
        mm.writeTo((OutputStream)baos);
        return baos;
    }

    public String dumpMessageAsString() throws Exception {
        return this.dumpMessageAsString(false);
    }

    private void dumpMessageToFile(boolean withAttachment) throws Exception {
        Date d = new Date();
        StringBuffer bb = new StringBuffer();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd.HHmmss.S");
        FieldPosition fp = new FieldPosition(0);
        StringBuffer b = s.format(d, bb, fp);
        this.lastGeneratedFileName = this.queueDir + "/" + this.queuePraefix + b + ".email~";
        File f = new File(this.lastGeneratedFileName);
        while (f.exists()) {
            b = s.format(d, bb, fp);
            this.lastGeneratedFileName = this.queueDir + "/" + this.queuePraefix + b + ".email~";
            f = new File(this.lastGeneratedFileName);
        }
        this.dumpMessageToFile(f, withAttachment);
    }

    public void dumpMessageToFile(String filename, boolean withAttachment) throws Exception {
        this.dumpMessageToFile(new File(filename), withAttachment);
    }

    public void dumpMessageToFile(File file, boolean withAttachment) throws Exception {
        try {
            this.prepareJavaMail();
            File myFile = new File(file.getAbsolutePath() + "~");
            FileOutputStream out = new FileOutputStream(myFile, true);
            out.write(this.dumpMessage(withAttachment));
            out.close();
            String newFilename = myFile.getAbsolutePath().substring(0, myFile.getAbsolutePath().length() - 1);
            File f = new File(newFilename);
            f.delete();
            myFile.renameTo(f);
        }
        catch (Exception e) {
            throw new Exception("error occurred on dump: " + e.toString());
        }
    }

    public String dumpMessageAsString(boolean withAttachment) throws Exception {
        ByteArrayOutputStream baos = null;
        this.prepareJavaMail();
        if (!withAttachment) {
            baos = this.messageRemoveAttachments();
        }
        this.rawEmailByteStream = new ByteArrayOutputStream();
        this.message.writeTo((OutputStream)this.rawEmailByteStream);
        byte[] bytes = withAttachment || baos == null ? this.rawEmailByteStream.toByteArray() : baos.toByteArray();
        return new String(bytes);
    }

    public byte[] dumpMessage() throws Exception {
        return this.dumpMessage(true);
    }

    public byte[] dumpMessage(boolean withAttachment) throws Exception {
        ByteArrayOutputStream baos = null;
        this.prepareJavaMail();
        if (!withAttachment) {
            baos = this.messageRemoveAttachments();
        }
        this.rawEmailByteStream = new ByteArrayOutputStream();
        this.message.writeTo((OutputStream)this.rawEmailByteStream);
        byte[] bytes = withAttachment || baos == null ? this.rawEmailByteStream.toByteArray() : baos.toByteArray();
        return bytes;
    }

    public LinkedList<String> getRecipients() {
        return this.toList;
    }

    public String getRecipientsAsString() throws MessagingException {
        Object s;
        block3: {
            block2: {
                s = " ";
                if (!this.messageReady) break block2;
                Address[] addresses = this.message.getRecipients(MimeMessage.RecipientType.TO);
                if (addresses == null) break block3;
                for (Address aktAddress : addresses) {
                    s = (String)s + aktAddress.toString() + ",";
                }
                break block3;
            }
            ListIterator i = this.toList.listIterator();
            while (i.hasNext()) {
                s = (String)s + (String)i.next() + ",";
            }
        }
        return ((String)s).substring(0, ((String)s).length() - 1).trim();
    }

    public LinkedList<String> getCCs() {
        return this.ccList;
    }

    public String getCCsAsString() throws MessagingException {
        Object s;
        block3: {
            block2: {
                s = " ";
                if (!this.messageReady) break block2;
                Address[] addresses = this.message.getRecipients(MimeMessage.RecipientType.CC);
                if (addresses == null) break block3;
                for (Address aktAddress : addresses) {
                    s = (String)s + aktAddress.toString() + ",";
                }
                break block3;
            }
            ListIterator i = this.ccList.listIterator();
            while (i.hasNext()) {
                s = (String)s + (String)i.next() + ",";
            }
        }
        return ((String)s).substring(0, ((String)s).length() - 1).trim();
    }

    public LinkedList<String> getBCCs() {
        return this.bccList;
    }

    public String getBCCsAsString() throws MessagingException {
        Object s;
        block3: {
            block2: {
                s = " ";
                if (!this.messageReady) break block2;
                Address[] addresses = this.message.getRecipients(MimeMessage.RecipientType.BCC);
                if (addresses == null) break block3;
                for (Address aktAddress : addresses) {
                    s = (String)s + aktAddress.toString() + ",";
                }
                break block3;
            }
            ListIterator i = this.bccList.listIterator();
            while (i.hasNext()) {
                s = (String)s + (String)i.next() + ",";
            }
        }
        return ((String)s).substring(0, ((String)s).length() - 1).trim();
    }

    public void clearRecipients() {
        LOGGER.debug("clearRecipients");
        if (this.toList != null) {
            this.toList.clear();
        }
        if (this.ccList != null) {
            this.ccList.clear();
        }
        if (this.bccList != null) {
            this.bccList.clear();
        }
        this.changed = true;
    }

    public void clearAttachments() {
        this.attachmentList.clear();
        this.changed = true;
    }

    public String getQuotedName(String name) {
        if (name.indexOf(60) > -1 && name.indexOf(62) > -1) {
            return name;
        }
        return "<" + name + ">";
    }

    public void setTimeout(int timeout) throws Exception {
        this.addMailProperty("mail.smtp.timeout", timeout);
        this.initMessage();
    }

    public Integer getTimeout() {
        if (this.getMailPropertyValue("mail.smtp.timeout") == null) {
            return 30000;
        }
        return Integer.parseInt(this.getMailPropertyValue("mail.smtp.timeout"));
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String lang) throws Exception {
        this.language = lang;
        this.initLanguage();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public void setDatetimeFormat(String datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.warn("encoding", encoding);
        this.changed = true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        this.warn("charset", charset);
        this.changed = true;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.warn("contentType", contentType);
        this.changed = true;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setAttachmentContentType(String attachmentContentType) {
        this.attachmentContentType = attachmentContentType;
        this.warn("attachmentContentType", attachmentContentType);
        this.changed = true;
    }

    public String getAttachmentContentType() {
        return this.attachmentContentType;
    }

    public String getHost() {
        return this.getMailPropertyValue(PROPERTY_NAME_SMTP_HOST);
    }

    public String getPort() {
        return this.getMailPropertyValue(PROPERTY_NAME_SMTP_PORT);
    }

    private String getUser() {
        return this.getMailPropertyValue(PROPERTY_NAME_SMTP_USER);
    }

    private String getPassword() {
        return this.getMailPropertyValue(PROPERTY_NAME_SMTP_PASSWORD);
    }

    private String getMailPropertyValue(String key) {
        Properties p = this.smtpProperties == null ? System.getProperties() : this.smtpProperties;
        if (p.get(key) == null) {
            return null;
        }
        return p.get(key).toString();
    }

    public void setQueueDir(String queueDir) {
        this.queueDir = queueDir;
    }

    public String getQueueDir() {
        return this.queueDir;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.warn("subject", subject);
        this.changed = true;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setFrom(String from) {
        this.from = from;
        this.warn("from", from);
        this.changed = true;
    }

    public String getFrom() {
        return this.from;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
        this.warn("fromName", fromName);
        this.changed = true;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        this.warn("replyTo", replyTo);
        this.changed = true;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setBody(String body) {
        this.body = body;
        this.warn("body", body);
        this.changed = true;
    }

    public String getBody() {
        return this.body;
    }

    public byte[] getMessageBytes() {
        return this.messageBytes;
    }

    public void setSendToOutputStream(boolean sendToOutputStream) {
        this.sendToOutputStream = sendToOutputStream;
    }

    public void setattachmentEncoding(String attachmentEncoding) {
        this.attachmentEncoding = attachmentEncoding;
        this.warn("attachmentEncoding", attachmentEncoding);
        this.changed = true;
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public String getLastError() {
        return this.lastError;
    }

    public String getAttachmentEncoding() {
        return this.attachmentEncoding;
    }

    public String getAttachmentCharset() {
        return this.attachmentCharset;
    }

    public void setAttachmentCharset(String attachmentCharset) {
        this.attachmentCharset = attachmentCharset;
        this.warn("attachmentCharset", attachmentCharset);
        this.changed = true;
    }

    public void setAttachmentEncoding(String attachmentEncoding) {
        this.attachmentEncoding = attachmentEncoding;
        this.warn("attachmentEncoding", attachmentEncoding);
        this.changed = true;
    }

    public void setHost(String host) throws Exception {
        this.addMailProperty(PROPERTY_NAME_SMTP_HOST, host);
        this.initMessage();
    }

    public void setPassword(String password) throws Exception {
        this.addMailProperty(PROPERTY_NAME_SMTP_PASSWORD, password);
        this.initMessage();
    }

    public void setUser(String user) throws Exception {
        this.addMailProperty(PROPERTY_NAME_SMTP_USER, user);
        this.initMessage();
    }

    public void setPort(String port) throws Exception {
        this.addMailProperty(PROPERTY_NAME_SMTP_PORT, port);
        this.initMessage();
    }

    public void setPriorityHighest() throws MessagingException {
        this.message.setHeader("Priority", "urgent");
        this.message.setHeader("X-Priority", "1 (Highest)");
        this.message.setHeader("X-MSMail-Priority", "Highest");
        this.changed = true;
    }

    public void setPriorityHigh() throws MessagingException {
        this.message.setHeader("Priority", "urgent");
        this.message.setHeader("X-Priority", "2 (High)");
        this.message.setHeader("X-MSMail-Priority", "Highest");
        this.changed = true;
    }

    public void setPriorityNormal() throws MessagingException {
        this.message.setHeader("Priority", "normal");
        this.message.setHeader("X-Priority", "3 (Normal)");
        this.message.setHeader("X-MSMail-Priority", "Normal");
        this.changed = true;
    }

    public void setPriorityLow() throws MessagingException {
        this.message.setHeader("Priority", "non-urgent");
        this.message.setHeader("X-Priority", "4 (Low)");
        this.message.setHeader("X-MSMail-Priority", "Low");
        this.changed = true;
    }

    public void setPriorityLowest() throws MessagingException {
        this.message.setHeader("Priority", "non-urgent");
        this.message.setHeader("X-Priority", "5 (Lowest)");
        this.message.setHeader("X-MSMail-Priority", "Low");
        this.changed = true;
    }

    public void setAlternativeBody(String alternativeBody) {
        this.alternativeBody = alternativeBody;
    }

    public void setAlternativeCharset(String alternativeCharset) {
        this.alternativeCharset = alternativeCharset;
    }

    public void setAlternativeContentType(String alternativeContentType) {
        this.alternativeContentType = alternativeContentType;
    }

    public String getQueuePraefix() {
        return this.queuePraefix;
    }

    public String getLastGeneratedFileName() {
        return this.lastGeneratedFileName;
    }

    public void setQueuePraefix(String queuePraefix) {
        this.queuePraefix = queuePraefix;
    }

    public String getLoadedMessageId() {
        return this.loadedMessageId;
    }

    private void warn(String n, String v) {
        if (this.messageReady) {
            try {
                LOGGER.warn("...setting of " + n + "=" + v + " will not be used. Loaded Message will be sent unchanged.");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addMailProperty(String key, Object value) {
        if (value != null && key != null) {
            if (this.smtpProperties == null) {
                System.getProperties().put(key, value);
            } else {
                this.smtpProperties.put(key, value);
            }
        }
    }

    public void setQueueMailOnError(boolean val) {
        this.queueMailOnError = val;
    }

    public void setCredentialStoreArguments(CredentialStoreArguments val) {
        this.credentialStoreArguments = val;
    }

    public CredentialStoreArguments getCredentialStoreArguments() {
        return this.credentialStoreArguments;
    }

    public static void main(String[] args) throws Exception {
        SOSMail sosMail = new SOSMail("smtp.sos");
        sosMail.setPriorityLowest();
        sosMail.setQueueDir("c:/");
        sosMail.setFrom("xyz@sos-berlin.com");
        sosMail.setEncoding("8bit");
        sosMail.setattachmentEncoding("Base64");
        sosMail.setSubject("Betreff");
        sosMail.setReplyTo("xyz@sos-berlin.com");
        String s = "Hello\\nWorld";
        sosMail.setBody(s);
        sosMail.addRecipient("xyz@sos-berlin.com");
        sosMail.setPriorityLowest();
        if (!sosMail.send()) {
            LOGGER.warn(sosMail.getLastError());
        }
        sosMail.clearRecipients();
    }

    class FileDataSource
    extends MydataSource {
        final File file;

        public FileDataSource(File dataSourceFile, String dataSourceContentType) {
            super(dataSourceFile, dataSourceContentType);
            this.file = dataSourceFile;
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream f = new FileInputStream(this.file);
            SOSMail.this.fileInputStreams.add(f);
            return f;
        }
    }

    abstract class MydataSource
    implements DataSource {
        final String name;
        final String contentType;

        public MydataSource(File dataSourceFile, String dataSourceContentType) {
            this.name = dataSourceFile.getName();
            this.contentType = dataSourceContentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() {
            throw new RuntimeException(this.getClass().getName() + " has no OutputStream");
        }
    }
}

