/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange.history;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionJadeOperation;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.JSHelper.interfaces.IJobSchedulerEventHandler;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jade.db.DBItemYadeFiles;
import com.sos.jade.db.DBItemYadeProtocols;
import com.sos.jade.db.DBItemYadeTransfers;
import com.sos.jade.db.YadeDBLayer;
import com.sos.vfs.common.SOSFileList;
import com.sos.vfs.common.SOSFileListEntry;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YadeDBOperationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(YadeDBOperationHelper.class);
    private String currentNodeName;
    private String currentJobChain;
    private String currentJob;
    private String currentOrderId;
    private String currentJobschedulerId;
    private DBItemYadeProtocols sourceProtocolDBItem;
    private DBItemYadeProtocols targetProtocolDBItem;
    private DBItemYadeProtocols jumpProtocolDBItem;
    private DBItemYadeTransfers transferDBItem;
    private SOSBaseOptions options;
    private Long parentTransferId = null;
    private Long taskId = null;
    private Boolean hasErrors = null;
    private IJobSchedulerEventHandler eventHandler = null;

    public YadeDBOperationHelper(SOSBaseOptions opt, IJobSchedulerEventHandler eventHandler) {
        this.options = opt;
        this.eventHandler = eventHandler;
        this.addAdditionalJobInfosFromOptions();
    }

    private URL getURL(SOSProviderOptions options) {
        URL url = options.url.getUrl();
        if (url == null) {
            try {
                url = new URL(options.host.getValue());
            }
            catch (Throwable e) {
                LOGGER.error(e.toString(), e);
            }
        }
        return url;
    }

    public Long storeYadeTransferInformationToDB(SOSFileList fileList, SOSHibernateSession dbSession, Long parentTransferId) throws Exception {
        this.parentTransferId = parentTransferId;
        Long transferId = null;
        YadeDBLayer dbLayer = null;
        if (dbSession != null) {
            dbLayer = new YadeDBLayer(dbSession);
            SOSProviderOptions sourceOptions = this.options.getSource();
            SOSProviderOptions targetOptions = this.options.getTarget();
            if (this.sourceProtocolDBItem == null && this.options.sourceDir.isDirty()) {
                URL url;
                SOSOptionTransferType.TransferTypes transferType = sourceOptions.protocol.getEnum();
                this.sourceProtocolDBItem = new DBItemYadeProtocols();
                this.sourceProtocolDBItem.setHostname(sourceOptions.host.getValue());
                this.sourceProtocolDBItem.setPort(Integer.valueOf(sourceOptions.port.value()));
                this.sourceProtocolDBItem.setProtocol(Integer.valueOf(transferType.numeric()));
                if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.local)) {
                    this.sourceProtocolDBItem.setPort(Integer.valueOf(0));
                } else if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.webdav)) {
                    url = this.getURL(sourceOptions);
                    if (url != null && url.getProtocol().toLowerCase().equals(SOSOptionTransferType.TransferTypes.webdavs.name()) || url.getProtocol().toLowerCase().equals(SOSOptionTransferType.TransferTypes.https.name())) {
                        this.sourceProtocolDBItem.setProtocol(Integer.valueOf(SOSOptionTransferType.TransferTypes.webdavs.numeric()));
                    }
                } else if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.http) && (url = this.getURL(sourceOptions)) != null && url.getProtocol().toLowerCase().equals(SOSOptionTransferType.TransferTypes.https.name())) {
                    this.sourceProtocolDBItem.setProtocol(Integer.valueOf(SOSOptionTransferType.TransferTypes.https.numeric()));
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("[source][transferType %s=%s]sourceProtocol=%s", transferType.name(), transferType.numeric(), this.sourceProtocolDBItem.getProtocol()));
                }
                if (sourceOptions.user.isDirty() && sourceOptions.user.getValue() != null && sourceOptions.user.isNotEmpty()) {
                    this.sourceProtocolDBItem.setAccount(sourceOptions.user.getValue());
                } else {
                    this.sourceProtocolDBItem.setAccount(".");
                }
                DBItemYadeProtocols sourceProtocolFromDb = null;
                sourceProtocolFromDb = dbLayer.getProtocolFromDb(this.sourceProtocolDBItem.getHostname(), this.sourceProtocolDBItem.getPort(), this.sourceProtocolDBItem.getProtocol(), this.sourceProtocolDBItem.getAccount());
                if (sourceProtocolFromDb != null) {
                    this.sourceProtocolDBItem = sourceProtocolFromDb;
                } else {
                    dbSession.save((Object)this.sourceProtocolDBItem);
                }
                if (this.targetProtocolDBItem == null && this.options.targetDir.isDirty()) {
                    URL url2;
                    transferType = targetOptions.protocol.getEnum();
                    this.targetProtocolDBItem = new DBItemYadeProtocols();
                    this.targetProtocolDBItem.setHostname(targetOptions.host.getValue());
                    this.targetProtocolDBItem.setPort(Integer.valueOf(targetOptions.port.value()));
                    this.targetProtocolDBItem.setProtocol(Integer.valueOf(transferType.numeric()));
                    if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.local)) {
                        this.targetProtocolDBItem.setPort(Integer.valueOf(0));
                    } else if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.webdav)) {
                        url2 = this.getURL(targetOptions);
                        if (url2 != null && url2.getProtocol().toLowerCase().equals(SOSOptionTransferType.TransferTypes.webdavs.name()) || url2.getProtocol().toLowerCase().equals(SOSOptionTransferType.TransferTypes.https.name())) {
                            this.targetProtocolDBItem.setProtocol(Integer.valueOf(SOSOptionTransferType.TransferTypes.webdavs.numeric()));
                        }
                    } else if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.http) && (url2 = this.getURL(targetOptions)) != null && url2.getProtocol().toLowerCase().equals(SOSOptionTransferType.TransferTypes.https.name())) {
                        this.targetProtocolDBItem.setProtocol(Integer.valueOf(SOSOptionTransferType.TransferTypes.https.numeric()));
                    }
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(String.format("[target][transferType %s=%s]targetProtocol=%s", transferType.name(), transferType.numeric(), this.targetProtocolDBItem.getProtocol()));
                    }
                    if (targetOptions.user.isDirty() && targetOptions.user.getValue() != null && targetOptions.user.isNotEmpty()) {
                        this.targetProtocolDBItem.setAccount(targetOptions.user.getValue());
                    } else {
                        this.targetProtocolDBItem.setAccount(".");
                    }
                    DBItemYadeProtocols targetProtocolFromDb = null;
                    targetProtocolFromDb = dbLayer.getProtocolFromDb(this.targetProtocolDBItem.getHostname(), this.targetProtocolDBItem.getPort(), this.targetProtocolDBItem.getProtocol(), this.targetProtocolDBItem.getAccount());
                    if (targetProtocolFromDb != null) {
                        this.targetProtocolDBItem = targetProtocolFromDb;
                    } else {
                        dbSession.save((Object)this.targetProtocolDBItem);
                    }
                }
                if (this.jumpProtocolDBItem == null && this.options.jumpHost.isDirty()) {
                    transferType = SOSOptionTransferType.TransferTypes.valueOf((String)this.options.jumpProtocol.getValue().toLowerCase());
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(String.format("[jump]%s=%s", transferType.name(), transferType.numeric()));
                    }
                    this.jumpProtocolDBItem = new DBItemYadeProtocols();
                    this.jumpProtocolDBItem.setHostname(this.options.jumpHost.getValue());
                    this.jumpProtocolDBItem.setPort(Integer.valueOf(this.options.jumpPort.value()));
                    this.jumpProtocolDBItem.setProtocol(Integer.valueOf(transferType.numeric()));
                    if (this.options.jumpUser.isDirty() && this.options.jumpUser.getValue() != null && this.options.jumpUser.isNotEmpty()) {
                        this.jumpProtocolDBItem.setAccount(this.options.jumpUser.getValue());
                    } else {
                        this.jumpProtocolDBItem.setAccount(".");
                    }
                    DBItemYadeProtocols jumpProtocolFromDb = null;
                    jumpProtocolFromDb = dbLayer.getProtocolFromDb(this.jumpProtocolDBItem.getHostname(), this.jumpProtocolDBItem.getPort(), this.jumpProtocolDBItem.getProtocol(), this.jumpProtocolDBItem.getAccount());
                    if (jumpProtocolFromDb != null) {
                        this.jumpProtocolDBItem = jumpProtocolFromDb;
                    } else {
                        dbSession.save((Object)this.jumpProtocolDBItem);
                    }
                }
                DBItemYadeTransfers transferFromDb = null;
                if (this.transferDBItem != null && this.transferDBItem.getId() != null) {
                    transferFromDb = dbLayer.getTransferFromDb(this.transferDBItem.getId());
                }
                if (transferFromDb != null) {
                    transferId = transferFromDb.getId();
                    transferFromDb.setEnd(this.getUTCDateFromInstant(Instant.now()));
                    if (this.hasErrors == null) {
                        transferFromDb.setState(Integer.valueOf(2));
                        transferFromDb.setErrorCode(null);
                        transferFromDb.setErrorMessage(null);
                    } else if (!this.hasErrors.booleanValue()) {
                        transferFromDb.setState(Integer.valueOf(1));
                        transferFromDb.setErrorCode(null);
                        transferFromDb.setErrorMessage(null);
                    } else {
                        transferFromDb.setState(Integer.valueOf(3));
                        transferFromDb.setErrorCode(null);
                        transferFromDb.setErrorMessage(JobSchedulerException.LastErrorMessage);
                    }
                    if (fileList != null) {
                        transferFromDb.setNumOfFiles(Long.valueOf(fileList.count()));
                    } else {
                        transferFromDb.setNumOfFiles(Long.valueOf(0L));
                    }
                    transferFromDb.setTaskId(this.taskId);
                    if (parentTransferId != null) {
                        transferFromDb.setParentTransferId(parentTransferId);
                    }
                    transferFromDb.setModified(this.getUTCDateFromInstant(Instant.now()));
                    dbSession.update((Object)transferFromDb);
                    this.transferDBItem = transferFromDb;
                } else {
                    DBItemYadeTransfers newTransfer = new DBItemYadeTransfers();
                    if (this.sourceProtocolDBItem != null) {
                        newTransfer.setSourceProtocolId(this.sourceProtocolDBItem.getId());
                    }
                    if (this.targetProtocolDBItem != null) {
                        newTransfer.setTargetProtocolId(this.targetProtocolDBItem.getId());
                    }
                    if (this.jumpProtocolDBItem != null) {
                        newTransfer.setJumpProtocolId(this.jumpProtocolDBItem.getId());
                    }
                    newTransfer.setMandator(this.options.mandator.getValue());
                    newTransfer.setOperation(this.getOperation(this.options.operation));
                    newTransfer.setStart(this.getUTCDateFromInstant(Instant.now()));
                    newTransfer.setEnd(null);
                    newTransfer.setState(Integer.valueOf(2));
                    newTransfer.setErrorCode(null);
                    newTransfer.setErrorMessage(null);
                    newTransfer.setJobschedulerId(this.currentJobschedulerId);
                    newTransfer.setJob(this.currentJob);
                    newTransfer.setJobChain(this.currentJobChain);
                    newTransfer.setJobChainNode(this.currentNodeName);
                    newTransfer.setOrderId(this.currentOrderId);
                    newTransfer.setTaskId(this.taskId);
                    if (fileList != null) {
                        newTransfer.setNumOfFiles(Long.valueOf(fileList.count()));
                    } else {
                        newTransfer.setNumOfFiles(Long.valueOf(0L));
                    }
                    if (this.options.profile != null) {
                        newTransfer.setProfileName(this.options.profile.getValue());
                    }
                    if (parentTransferId != null) {
                        newTransfer.setParentTransferId(parentTransferId);
                    }
                    newTransfer.setModified(this.getUTCDateFromInstant(Instant.now()));
                    dbSession.save((Object)newTransfer);
                    transferId = newTransfer.getId();
                    this.transferDBItem = newTransfer;
                }
            }
        }
        return transferId;
    }

    public void storeInitialFilesInformationToDB(Long transferId, SOSHibernateSession dbSession, SOSFileList files) throws Exception {
        Long fileSizeSum = 0L;
        if (dbSession != null && files != null && files.getList() != null && !files.getList().isEmpty()) {
            for (SOSFileListEntry fileEntry : files.getList()) {
                YadeDBLayer dbLayer = new YadeDBLayer(dbSession);
                DBItemYadeFiles fileFromDb = null;
                fileFromDb = dbLayer.getTransferFileFromDbByConstraint(transferId, fileEntry.getSourceFilename());
                if (fileFromDb != null) {
                    fileFromDb.setTargetPath(fileEntry.getTargetFileNameAndPath());
                    fileFromDb.setSize(fileEntry.getFileSize());
                    fileSizeSum = fileSizeSum + fileEntry.getFileSize();
                    fileFromDb.setState(fileEntry.getStatus());
                    String lastErrorMessage = fileEntry.getLastErrorMessage();
                    if (lastErrorMessage != null && !lastErrorMessage.isEmpty()) {
                        fileFromDb.setErrorCode("ERRORCODE");
                        fileFromDb.setErrorMessage(lastErrorMessage);
                    } else {
                        fileFromDb.setErrorCode(null);
                        fileFromDb.setErrorMessage(null);
                    }
                    fileFromDb.setIntegrityHash(fileEntry.getMd5());
                    fileFromDb.setModificationDate(this.getUTCDateFromTimeStamp(fileEntry.getSourceFileModificationDateTime()));
                    fileFromDb.setModified(this.getUTCDateFromInstant(Instant.now()));
                    dbSession.update((Object)fileFromDb);
                    continue;
                }
                DBItemYadeFiles file = new DBItemYadeFiles();
                file.setTransferId(transferId);
                file.setSourcePath(fileEntry.getSourceFilename());
                file.setTargetPath(fileEntry.getTargetFileNameAndPath());
                file.setSize(fileEntry.getFileSize());
                fileSizeSum = fileSizeSum + fileEntry.getFileSize();
                file.setState(fileEntry.getStatus());
                String lastErrorMessage = fileEntry.getLastErrorMessage();
                if (lastErrorMessage != null && !lastErrorMessage.isEmpty()) {
                    file.setErrorCode("ERRORCODE");
                    file.setErrorMessage(lastErrorMessage);
                } else {
                    file.setErrorCode(null);
                    file.setErrorMessage(null);
                }
                file.setIntegrityHash(fileEntry.getMd5());
                file.setModificationDate(this.getUTCDateFromTimeStamp(fileEntry.getSourceFileModificationDateTime()));
                file.setModified(this.getUTCDateFromInstant(Instant.now()));
                dbSession.save((Object)file);
            }
        }
        if (files != null) {
            files.setSumFileSizes(fileSizeSum.longValue());
        }
    }

    public void updateFileInformationToDB(SOSHibernateSession dbSession, SOSFileListEntry fileEntry) throws Exception {
        this.updateFileInformationToDB(dbSession, fileEntry, false, null);
    }

    public void updateFileInformationToDB(SOSHibernateSession dbSession, SOSFileListEntry fileEntry, boolean finalUpdate, String targetPath) throws Exception {
        if (this.transferDBItem == null) {
            return;
        }
        YadeDBLayer dbLayer = null;
        if (dbSession != null) {
            dbLayer = new YadeDBLayer(dbSession);
            if (fileEntry != null) {
                DBItemYadeFiles fileFromDb = null;
                fileFromDb = dbLayer.getTransferFileFromDbByConstraint(this.transferDBItem.getId(), fileEntry.getSourceFilename());
                if (fileFromDb != null) {
                    if (finalUpdate && (fileEntry.getStatus() == 0 || fileEntry.getStatus() == 7)) {
                        fileFromDb.setState(Integer.valueOf(8));
                    } else if (finalUpdate) {
                        fileFromDb.setState(Integer.valueOf(fileEntry.getStatus() + 1));
                    }
                    if (finalUpdate && fileFromDb.getState() != 7 && fileFromDb.getState() != 8 && fileFromDb.getState() != 14) {
                        if (targetPath != null) {
                            fileFromDb.setTargetPath(targetPath + fileEntry.getTargetFileName());
                        } else {
                            fileFromDb.setTargetPath(fileEntry.getTargetFileNameAndPath());
                        }
                    } else {
                        fileFromDb.setTargetPath(null);
                    }
                    String lastErrorMessage = fileEntry.getLastErrorMessage();
                    if (lastErrorMessage != null && !lastErrorMessage.isEmpty()) {
                        fileFromDb.setErrorCode("ERRORCODE");
                        fileFromDb.setErrorMessage(lastErrorMessage);
                    } else {
                        fileFromDb.setErrorCode(null);
                        fileFromDb.setErrorMessage(null);
                    }
                    fileFromDb.setIntegrityHash(fileEntry.getMd5());
                    fileFromDb.setModificationDate(this.getUTCDateFromTimeStamp(fileEntry.getSourceFileModificationDateTime()));
                    fileFromDb.setModified(this.getUTCDateFromInstant(Instant.now()));
                    dbSession.update((Object)fileFromDb);
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("fileId", fileFromDb.getId().toString());
                    this.eventHandler.sendEvent("YADEFileStateChanged", values);
                    if (finalUpdate && this.parentTransferId != null) {
                        DBItemYadeFiles intervenedFileFromDb = null;
                        intervenedFileFromDb = dbLayer.getTransferFileFromDbByConstraint(this.parentTransferId, fileEntry.getSourceFilename());
                        if (intervenedFileFromDb != null) {
                            intervenedFileFromDb.setInterventionTransferId(this.transferDBItem.getId());
                            dbSession.update((Object)intervenedFileFromDb);
                            values = new HashMap();
                            values.put("transferId", this.parentTransferId.toString());
                            values.put("fileId", intervenedFileFromDb.getId().toString());
                            this.eventHandler.sendEvent("YADEFileStateChanged", values);
                        } else {
                            LOGGER.debug(String.format("File entry with transfer id=%1$d and path=%2$s not updated with intervention id=%3$d due to item not found in DB!", this.parentTransferId, fileEntry.getSourceFilename(), this.transferDBItem.getId()));
                        }
                    }
                } else {
                    DBItemYadeFiles file = new DBItemYadeFiles();
                    file.setTransferId(this.transferDBItem.getId());
                    file.setSourcePath(fileEntry.getSourceFilename());
                    if (finalUpdate && (fileEntry.getStatus() == 0 || fileEntry.getStatus() == 7)) {
                        file.setState(Integer.valueOf(8));
                    } else if (finalUpdate) {
                        file.setState(Integer.valueOf(fileEntry.getStatus() + 1));
                    }
                    if (finalUpdate && file.getState() != 7 && file.getState() != 8 && file.getState() != 14) {
                        file.setTargetPath(fileEntry.getTargetFileNameAndPath());
                    } else {
                        file.setTargetPath(null);
                    }
                    file.setSize(fileEntry.getFileSize());
                    file.setModificationDate(this.getUTCDateFromTimeStamp(fileEntry.getSourceFileModificationDateTime()));
                    String lastErrorMessage = fileEntry.getLastErrorMessage();
                    if (lastErrorMessage != null && !lastErrorMessage.isEmpty()) {
                        file.setErrorCode("ERRORCODE");
                        file.setErrorMessage(lastErrorMessage);
                    } else {
                        file.setErrorCode(null);
                        file.setErrorMessage(null);
                    }
                    file.setIntegrityHash(fileEntry.getMd5());
                    file.setModificationDate(this.getUTCDateFromTimeStamp(fileEntry.getSourceFileModificationDateTime()));
                    file.setModified(this.getUTCDateFromInstant(Instant.now()));
                    dbSession.save((Object)file);
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("fileId", file.getId().toString());
                    this.eventHandler.sendEvent("YADEFileStateChanged", values);
                }
            }
        }
    }

    public Long storeInitialTransferInformations(SOSFileList fileList, SOSHibernateSession dbSession) throws Exception {
        return this.storeInitialTransferInformations(fileList, dbSession, null);
    }

    public Long storeInitialTransferInformations(SOSFileList fileList, SOSHibernateSession dbSession, Long parentTransferId) throws Exception {
        this.parentTransferId = parentTransferId;
        Long transferId = null;
        if (dbSession != null) {
            transferId = this.storeYadeTransferInformationToDB(fileList, dbSession, parentTransferId);
        }
        return transferId;
    }

    public void addAdditionalJobInfosFromOptions() {
        if (this.options.getJobSchedulerId() != null) {
            this.currentJobschedulerId = this.options.getJobSchedulerId();
        }
        if (this.options.getJobChain() != null) {
            this.currentJobChain = this.options.getJobChain();
        }
        if (this.options.getJob() != null) {
            this.currentJob = this.options.getJob();
        }
        if (this.options.getJobChainNodeName() != null) {
            this.currentNodeName = this.options.getJobChainNodeName();
        }
        if (this.options.getOrderId() != null) {
            this.currentOrderId = this.options.getOrderId();
        }
        if (this.options.getParentTransferId() != null) {
            this.parentTransferId = this.options.getParentTransferId();
        }
        if (this.options.getTaskId() != null) {
            String taskIdFromOptions = this.options.getTaskId();
            this.taskId = Long.parseLong(taskIdFromOptions);
        }
    }

    public void updateFailedTransfer(SOSHibernateSession dbSession, String errorMessage) throws Exception {
        if (this.transferDBItem != null) {
            this.transferDBItem.setState(Integer.valueOf(3));
            this.transferDBItem.setErrorMessage(errorMessage);
            this.transferDBItem.setEnd(this.getUTCDateFromInstant(Instant.now()));
            this.transferDBItem.setModified(this.getUTCDateFromInstant(Instant.now()));
            if (dbSession != null) {
                dbSession.update((Object)this.transferDBItem);
            }
            this.eventHandler.sendEvent("YADETransferUpdated", null);
        }
    }

    public void updateSuccessfulTransfer(SOSHibernateSession dbSession) throws Exception {
        if (this.transferDBItem != null) {
            this.transferDBItem.setState(Integer.valueOf(1));
            this.transferDBItem.setEnd(this.getUTCDateFromInstant(Instant.now()));
            this.transferDBItem.setModified(this.getUTCDateFromInstant(Instant.now()));
            if (dbSession != null) {
                dbSession.update((Object)this.transferDBItem);
            }
            this.eventHandler.sendEvent("YADETransferUpdated", null);
        }
    }

    public void updateTransfersNumOfFiles(SOSHibernateSession dbSession, Long numOfFiles) throws Exception {
        if (this.transferDBItem != null) {
            this.transferDBItem.setNumOfFiles(numOfFiles);
            this.transferDBItem.setModified(this.getUTCDateFromInstant(Instant.now()));
            if (dbSession != null) {
                dbSession.update((Object)this.transferDBItem);
            }
            this.eventHandler.sendEvent("YADETransferUpdated", null);
        }
    }

    public DBItemYadeTransfers getTransfer(Long id, SOSHibernateSession dbSession) {
        DBItemYadeTransfers transfer;
        block5: {
            YadeDBLayer dbLayer = null;
            transfer = null;
            if (dbSession != null) {
                dbLayer = new YadeDBLayer(dbSession);
                try {
                    transfer = dbLayer.getTransferFromDb(id);
                }
                catch (SOSHibernateException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    if (dbSession == null) break block5;
                    try {
                        dbSession.rollback();
                    }
                    catch (SOSHibernateException sOSHibernateException) {
                        // empty catch block
                    }
                }
            }
        }
        return transfer;
    }

    private Integer getOperation(SOSOptionJadeOperation jadeOperation) {
        switch (jadeOperation.value()) {
            case copy: {
                return 1;
            }
            case move: {
                return 2;
            }
            case getlist: {
                return 3;
            }
            case rename: {
                return 4;
            }
            case copytointernet: 
            case sendusingdmz: {
                return 5;
            }
            case copyfrominternet: 
            case receiveusingdmz: {
                return 6;
            }
        }
        return 0;
    }

    private Boolean getHasErrorsFromFileState(Integer fileEntryState) {
        switch (fileEntryState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                return false;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: {
                return true;
            }
        }
        return null;
    }

    public DBItemYadeTransfers getTransferDBItem() {
        return this.transferDBItem;
    }

    public void setTransferDBItem(DBItemYadeTransfers transferDBItem) {
        this.transferDBItem = transferDBItem;
    }

    public void setParentTransferId(Long parentTransferId) {
        this.parentTransferId = parentTransferId;
    }

    private Date getUTCDateFromInstant(Instant inDate) {
        return this.getUTCDateFromTimeStamp(inDate.toEpochMilli());
    }

    private Date getUTCDateFromTimeStamp(long timestamp) {
        if (timestamp < 0L) {
            return null;
        }
        return new Date(timestamp - (long)TimeZone.getDefault().getOffset(timestamp));
    }
}

