/*
 * Decompiled with CFR 0.152.
 */
package sos.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.connection.SOSMSSQLConnection;
import sos.connection.SOSSybaseConnection;
import sos.settings.SOSSettings;
import sos.util.SOSClassUtil;
import sos.util.SOSString;

public class SOSConnectionSettings
extends SOSSettings {
    protected String application = "";
    protected static final String APPLICATION = "APPLICATION";
    protected static final String SECTION = "SECTION";
    protected static final String NAME = "NAME";
    protected static final String VALUE = "VALUE";
    protected static final String TITLE = "TITLE";
    protected static final String LONG_VALUE = "LONG_VALUE";
    protected String entryCounterApplication = "counter";
    protected String entryCounterSection = "counter";
    protected String entryOrder = "NAME";
    protected String entrySettingTitle = "TITLE";
    protected String entrySchemaSection = "**schema**";
    protected String defaultDocumentFileName = "settings_file.dat";
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSConnectionSettings.class);
    private SOSConnection sosConnection;

    public SOSConnectionSettings(SOSConnection sosConnection, String source) throws Exception {
        super(source);
        if (sosConnection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + " invalid sosConnection !!.");
        }
        this.sosConnection = sosConnection;
    }

    public SOSConnectionSettings(SOSConnection sosConnection, String source, String application) throws Exception {
        super(source);
        if (sosConnection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": invalid sosConnection !!.");
        }
        if (SOSString.isEmpty((String)application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": invalid application name !!.");
        }
        this.sosConnection = sosConnection;
        this.application = application;
    }

    public SOSConnectionSettings(SOSConnection sosConnection, String source, String application, String section) throws Exception {
        super(source, section);
        if (sosConnection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": invalid sosConnection name.");
        }
        if (SOSString.isEmpty((String)application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": invalid application name.");
        }
        this.sosConnection = sosConnection;
        this.application = application;
    }

    @Override
    public Properties getSection(String application, String section) throws Exception {
        Properties entries = new Properties();
        StringBuilder query = null;
        if (SOSString.isEmpty((String)application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
        }
        if (SOSString.isEmpty((String)section)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": section has no value!");
        }
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        query = new StringBuilder();
        if (this.ignoreCase) {
            query.append("SELECT \"").append(NAME).append("\",\"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND \"").append(SECTION).append("\" <> \"").append(NAME).append("\"");
        } else {
            query.append("SELECT \"").append(NAME).append("\",\"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(SECTION).append("\" <> \"").append(NAME).append("\"");
        }
        LOGGER.debug(".. query: " + query.toString());
        try {
            entries = this.sosConnection.getArrayAsProperties(query.toString());
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.toString());
        }
        return entries;
    }

    @Override
    public Properties getSection(String section) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (SOSString.isEmpty((String)section)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": section has no value!");
        }
        if (this.application == null || this.application.isEmpty()) {
            throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
        }
        return this.getSection(this.application, section);
    }

    @Override
    public Properties getSection() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (SOSString.isEmpty((String)this.application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
        }
        if (SOSString.isEmpty((String)this.section)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": section has no value!");
        }
        return this.getSection(this.application, this.section);
    }

    public List<String> getSections(String application) throws Exception {
        ArrayList<String> sections = new ArrayList();
        StringBuilder query = null;
        if (SOSString.isEmpty((String)application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
        }
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        query = new StringBuilder();
        if (this.ignoreCase) {
            query.append("SELECT \"").append(SECTION).append("\" FROM ").append(this.source).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND \"").append(SECTION).append("\" <> \"").append(APPLICATION).append("\"");
        } else {
            query.append("SELECT \"").append(SECTION).append("\" FROM ").append(this.source).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" <> \"").append(APPLICATION).append("\"");
        }
        LOGGER.debug(".. query: " + query.toString());
        try {
            sections = this.sosConnection.getArrayValue(query.toString());
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
        return sections;
    }

    @Override
    public List<String> getSections() throws Exception {
        if (SOSString.isEmpty((String)this.application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
        }
        return this.getSections(this.application);
    }

    @Override
    public String getSectionEntry(String entry) throws Exception {
        return this.getSectionEntry(this.application, this.section, entry);
    }

    public String getSectionEntry(String application, String section, String entry) throws Exception {
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            String query = this.getSectionEntryStatement(application, section, entry, VALUE);
            LOGGER.debug(".. query: " + query);
            return this.sosConnection.getSingleValue(query);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
    }

    public byte[] getSectionEntryDocument(String entry) throws Exception {
        return this.getSectionEntryDocument(this.application, this.section, entry);
    }

    public byte[] getSectionEntryDocument(String application, String section, String entry) throws Exception {
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            String query = this.getSectionEntryStatement(application, section, entry, LONG_VALUE);
            LOGGER.debug(".. query: " + query);
            return this.sosConnection.getBlob(query);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
    }

    public long getSectionEntryDocumentAsFile(String entry, String fileName) throws Exception {
        return this.getSectionEntryDocumentAsFile(this.application, this.section, entry, fileName);
    }

    public long getSectionEntryDocumentAsFile(String application, String section, String entry, String fileName) throws Exception {
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            String query = this.getSectionEntryStatement(application, section, entry, LONG_VALUE);
            LOGGER.debug(".. query: " + query);
            return this.sosConnection.getBlob(query, fileName);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
    }

    private String getSectionEntryStatement(String application, String section, String entry, String field) throws Exception {
        StringBuilder query = null;
        try {
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("SELECT \"").append(field).append("\" FROM ").append(this.source).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
            } else {
                query.append("SELECT \"").append(field).append("\" FROM ").append(this.source).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
            }
            return query.toString();
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
    }

    public boolean initSequence(String application, String section, String entry, String createdBy) throws Exception {
        boolean created = false;
        String counter = null;
        StringBuilder query = null;
        String initValue = "1";
        int inserted = 0;
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            try {
                query = new StringBuilder();
                if (this.ignoreCase) {
                    query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
                } else {
                    query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
                }
                LOGGER.debug("query: " + query.toString());
                counter = this.sosConnection.getSingleValue(query.toString());
                LOGGER.debug(".. current counter value: " + counter);
            }
            catch (Exception e) {
                created = false;
                throw e;
            }
            if (counter != null && !"".equalsIgnoreCase(counter)) {
                return true;
            }
            try {
                query = new StringBuilder();
                query.append("INSERT INTO ").append(this.source).append("(\"").append(APPLICATION).append("\",\"").append(SECTION).append("\",\"").append(NAME).append("\",\"").append(VALUE).append("\",\"").append("CREATED_BY").append("\",\"").append("MODIFIED_BY").append("\",\"CREATED\",\"MODIFIED\") VALUES('").append(application).append("','").append(section).append("','").append(entry).append("','").append(initValue).append("','").append(createdBy).append("','").append(createdBy).append("',%now,%now").append(")");
                LOGGER.debug(".. query: " + query.toString());
                inserted = this.sosConnection.executeUpdate(query.toString());
                if (inserted > 0) {
                    created = true;
                }
            }
            catch (Exception e) {
                created = false;
            }
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
        return created;
    }

    public int getLockedSequence(String application, String section, String entry) throws Exception {
        StringBuilder query = null;
        String updlockFrom = "";
        String updlockWhere = "";
        int sequence = -1;
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            updlockFrom = this.sosConnection instanceof SOSMSSQLConnection || this.sosConnection instanceof SOSSybaseConnection ? "%updlock" : "";
            updlockWhere = "".equals(updlockFrom) ? "%updlock" : "";
            boolean autoCommit = this.sosConnection.getAutoCommit();
            this.sosConnection.setAutoCommit(false);
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" ").append(updlockFrom).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("' ").append(updlockWhere);
            } else {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" ").append(updlockFrom).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("' ").append(updlockWhere);
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": get result query: " + query.toString());
            sequence = Integer.valueOf(this.sosConnection.getSingleValue(query.toString())) + 1;
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
            } else {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": query: " + query.toString());
            this.sosConnection.execute(query.toString());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": successfully executed: " + query.toString());
            this.sosConnection.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            LOGGER.debug(SOSClassUtil.getMethodName() + ": an error occurred : " + e.toString());
            throw e;
        }
        return sequence;
    }

    public String getLockedSequenceAsString(String application, String section, String entry) throws Exception {
        StringBuilder query = null;
        String updlockFrom = "";
        String updlockWhere = "";
        String sequence = "";
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            updlockFrom = this.sosConnection instanceof SOSMSSQLConnection || this.sosConnection instanceof SOSSybaseConnection ? "%updlock" : "";
            updlockWhere = "".equals(updlockFrom) ? "%updlock" : "";
            boolean autoCommit = this.sosConnection.getAutoCommit();
            this.sosConnection.setAutoCommit(false);
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" ").append(updlockFrom).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("' ").append(updlockWhere);
            } else {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" ").append(updlockFrom).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("' ").append(updlockWhere);
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": get result query: " + query.toString());
            sequence = String.valueOf(Integer.parseInt(this.sosConnection.getSingleValue(query.toString())) + 1);
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
            } else {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": query: " + query.toString());
            this.sosConnection.execute(query.toString());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": successfully executed: " + query.toString());
            this.sosConnection.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            LOGGER.debug(SOSClassUtil.getMethodName() + ": an error occurred : " + e.toString());
            throw e;
        }
        return sequence;
    }

    public int getSequence(String application, String section, String entry) throws Exception {
        StringBuilder query = null;
        int sequence = -1;
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
            } else {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": query: " + query.toString());
            this.sosConnection.execute(query.toString());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": successfully executed: " + query.toString());
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
            } else {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": get result query: " + query.toString());
            sequence = Integer.valueOf(this.sosConnection.getSingleValue(query.toString()));
        }
        catch (Exception e) {
            LOGGER.debug(SOSClassUtil.getMethodName() + ": an error occurred : " + e.toString());
            throw e;
        }
        return sequence;
    }

    public String getSequenceAsString(String application, String section, String entry) throws Exception {
        StringBuilder query = null;
        String sequence = "";
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
            } else {
                query.append("UPDATE ").append(this.source).append(" SET \"").append(VALUE).append("\"=%cast(%cast(\"").append(VALUE).append("\" integer)+1 varchar) WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": query: " + query.toString());
            this.sosConnection.execute(query.toString());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": successfully executed: " + query.toString());
            query = new StringBuilder();
            if (this.ignoreCase) {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE %lcase(\"").append(APPLICATION).append("\") = '").append(application.toLowerCase()).append("' AND %lcase(\"").append(SECTION).append("\") = '").append(section.toLowerCase()).append("' AND %lcase(\"").append(NAME).append("\") = '").append(entry.toLowerCase()).append("'");
            } else {
                query.append("SELECT \"").append(VALUE).append("\" FROM ").append(this.source).append(" WHERE \"").append(APPLICATION).append("\" = '").append(application).append("' AND \"").append(SECTION).append("\" = '").append(section).append("' AND \"").append(NAME).append("\" = '").append(entry).append("'");
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": get result query: " + query.toString());
            sequence = this.sosConnection.getSingleValue(query.toString());
        }
        catch (Exception e) {
            LOGGER.debug(SOSClassUtil.getMethodName() + ": an error occurred : " + e.toString());
            throw e;
        }
        return sequence;
    }

    @Override
    public void setKeysToLowerCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        this.sosConnection.setKeysToLowerCase();
        LOGGER.debug(".. now keys set to lower case.");
    }

    @Override
    public void setKeysToUpperCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        this.sosConnection.setKeysToUpperCase();
        LOGGER.debug(".. now keys set to upper case.");
    }

    @Override
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEntryCounterApplication() {
        return this.entryCounterApplication;
    }

    public void setEntryCounterApplication(String entryCounterApplication) {
        this.entryCounterApplication = entryCounterApplication;
    }

    public String getEntryCounterSection() {
        return this.entryCounterSection;
    }

    public void setEntryCounterSection(String entryCounterSection) {
        this.entryCounterSection = entryCounterSection;
    }

    public String getEntryOrder() {
        return this.entryOrder;
    }

    public void setEntryOrder(String entryOrder) {
        this.entryOrder = entryOrder;
    }

    public String getEntrySchemaSection() {
        return this.entrySchemaSection;
    }

    public void setEntrySchemaSection(String entrySchemaSection) {
        this.entrySchemaSection = entrySchemaSection;
    }

    public String getEntrySettingTitle() {
        return this.entrySettingTitle;
    }

    public void setEntrySettingTitle(String entrySettingTitle) {
        this.entrySettingTitle = entrySettingTitle;
    }

    public String getDefaultDocumentFileName() {
        return this.defaultDocumentFileName;
    }

    public void setDefaultDocumentFileName(String fileName) {
        this.defaultDocumentFileName = fileName;
    }
}

