/*
 * Decompiled with CFR 0.152.
 */
package sos.settings;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.settings.SOSSettings;
import sos.util.SOSClassUtil;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public class SOSXMLSettings
extends SOSSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSXMLSettings.class);
    protected String application = "";
    private Map<String, Map<String, Properties>> applications = new LinkedHashMap<String, Map<String, Properties>>();
    protected boolean lowerCase = true;

    public SOSXMLSettings(String source) throws Exception {
        super(source);
        this.load();
    }

    public SOSXMLSettings(String source, String application) throws Exception {
        super(source);
        this.application = application;
        this.load();
    }

    public SOSXMLSettings(String source, String application, String section) throws Exception {
        super(source, section);
        this.application = application;
        this.load();
    }

    private void load() throws Exception {
        LinkedHashMap<String, Properties> sections = null;
        Properties entries = null;
        String xpathQueryAttributes = "attribute::name != '' and not (attribute::disabled = 'yes')";
        try {
            SOSXMLXPath xpath = null;
            NodeList nodeListApplications = null;
            this.applications = new LinkedHashMap<String, Map<String, Properties>>();
            xpath = new SOSXMLXPath(this.source);
            nodeListApplications = xpath.selectNodeList("/settings/application[" + xpathQueryAttributes + "]");
            for (int i = 0; i < nodeListApplications.getLength(); ++i) {
                Node nodeApplication = nodeListApplications.item(i);
                Element elementApplication = (Element)nodeApplication;
                String applicationName = elementApplication.getAttribute("name");
                sections = new LinkedHashMap<String, Properties>();
                NodeList nodeListSections = xpath.selectNodeList(nodeApplication, "./sections/section[" + xpathQueryAttributes + "]");
                for (int j = 0; j < nodeListSections.getLength(); ++j) {
                    Node nodeSection = nodeListSections.item(j);
                    Element elementSection = (Element)nodeSection;
                    String sectionName = elementSection.getAttribute("name");
                    entries = new Properties();
                    NodeList nodeListEntries = xpath.selectNodeList(nodeSection, "./entries/entry[" + xpathQueryAttributes + "]");
                    for (int e = 0; e < nodeListEntries.getLength(); ++e) {
                        Node nodeEntry = nodeListEntries.item(e);
                        Element elementEntry = (Element)nodeEntry;
                        String entryName = elementEntry.getAttribute("name");
                        String value = xpath.selectSingleNodeValue((Node)elementEntry, "./value");
                        entries.put(entryName, value == null ? "" : value.trim());
                    }
                    sections.put(sectionName, entries);
                }
                this.applications.put(applicationName, sections);
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": xml [" + this.source + "] successfully loaded.");
        }
        catch (NoClassDefFoundError e) {
            throw new Exception("Class not found  : " + e.getMessage());
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
    }

    @Override
    public Properties getSection(String application, String section) throws Exception {
        Map<String, Properties> sections;
        Properties entries = new Properties();
        if (SOSString.isEmpty((String)application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
        }
        if (SOSString.isEmpty((String)section)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": section has no value!");
        }
        LOGGER.debug("calling " + SOSClassUtil.getMethodName() + " : application = " + application + " section = " + section);
        if (this.applications != null && this.applications.containsKey(application) && (sections = this.applications.get(application)).containsKey(section)) {
            entries = sections.get(section);
        }
        return entries;
    }

    @Override
    public Properties getSection(String section) throws Exception {
        return this.getSection(this.application, section);
    }

    @Override
    public Properties getSection() throws Exception {
        return this.getSection(this.application, this.section);
    }

    public List<String> getSections(String application) throws Exception {
        ArrayList<String> sections = new ArrayList<String>();
        if (SOSString.isEmpty((String)application)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
        }
        LOGGER.debug("calling " + SOSClassUtil.getMethodName() + " : application = " + application);
        if (this.applications != null && this.applications.containsKey(application)) {
            Map<String, Properties> appSections = this.applications.get(application);
            for (Map.Entry<String, Properties> entry : appSections.entrySet()) {
                sections.add(entry.getKey());
            }
        }
        return sections;
    }

    @Override
    public List<String> getSections() throws Exception {
        return this.getSections(this.application);
    }

    @Override
    public String getSectionEntry(String entry) throws Exception {
        return this.getSectionEntry(this.application, this.section, entry);
    }

    public String getSectionEntry(String section, String entry) throws Exception {
        return this.getSectionEntry(this.application, section, entry);
    }

    public String getSectionEntry(String application, String section, String entry) throws Exception {
        String entryValue = "";
        try {
            Properties entries;
            Map<String, Properties> sections;
            if (SOSString.isEmpty((String)application)) {
                throw new Exception(SOSClassUtil.getMethodName() + ": application has no value!");
            }
            if (SOSString.isEmpty((String)section)) {
                throw new Exception(SOSClassUtil.getMethodName() + ": section has no value!");
            }
            if (SOSString.isEmpty((String)entry)) {
                throw new Exception(SOSClassUtil.getMethodName() + ": entry has no value!");
            }
            LOGGER.debug("calling " + SOSClassUtil.getMethodName() + " : application = " + application + " section = " + section + " entry = " + entry);
            if (this.applications != null && this.applications.containsKey(application) && (sections = this.applications.get(application)).containsKey(section) && (entries = sections.get(section)).containsKey(entry)) {
                entryValue = entries.getProperty(entry);
            }
            return entryValue;
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
    }

    @Override
    public void setKeysToLowerCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        LOGGER.debug(".. now keys set to lower case.");
        this.lowerCase = true;
    }

    @Override
    public void setKeysToUpperCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        LOGGER.debug(".. now keys set to upper case.");
        this.lowerCase = false;
    }

    protected String normalizeKey(String key) throws Exception {
        try {
            if (SOSString.isEmpty((String)key)) {
                throw new Exception(SOSClassUtil.getMethodName() + ": invalid key.");
            }
            if (this.getIgnoreCase()) {
                return key;
            }
            if (this.lowerCase) {
                return key.toLowerCase();
            }
            return key.toUpperCase();
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    @Override
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }
}

