/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.encryption.executable;

import com.sos.commons.encryption.EncryptionUtils;
import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.sign.keys.key.KeyUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Decrypt {
    private static final String HELP = "--help";
    private static final String HELP_SHORT = "-h";
    private static final String KEY = "--key";
    private static final String KEY_PWD = "--key-password";
    private static final String ENCRYPTED_KEY = "--encrypted-key";
    private static final String IV = "--iv";
    private static final String IN = "--in";
    private static final String IN_FILE = "--infile";
    private static final String OUT_FILE = "--outfile";
    private static String keyPath;
    private static String iv;
    private static String encryptedKey;
    private static String encryptedValue;
    private static String encryptedInput;
    private static String encryptedFile;
    private static String outFile;
    private static String keyPwd;

    public static String decrypt(PrivateKey privKey, String iv, String encryptedKey, String encryptedValue) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecretKeySpec key = new SecretKeySpec(EncryptionUtils.decryptSymmetricKey((byte[])encryptedKey.getBytes(), (PrivateKey)privKey), "AES");
        byte[] decodedIV = Base64.getDecoder().decode(iv);
        String decryptedValue = com.sos.commons.encryption.decrypt.Decrypt.decrypt((String)"AES/CBC/PKCS5Padding", (String)encryptedValue, (SecretKey)key, (IvParameterSpec)new IvParameterSpec(decodedIV));
        return decryptedValue;
    }

    public static void decryptFile(PrivateKey privKey, String iv, Path inFile, Path outFile) throws InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, BadPaddingException, IllegalBlockSizeException, IOException {
        SecretKeySpec key = new SecretKeySpec(EncryptionUtils.decryptSymmetricKey((byte[])encryptedKey.getBytes(), (PrivateKey)privKey), "AES");
        byte[] decodedIV = Base64.getDecoder().decode(iv);
        com.sos.commons.encryption.decrypt.Decrypt.decryptFile((String)"AES/CBC/PKCS5Padding", (SecretKey)key, (IvParameterSpec)new IvParameterSpec(decodedIV), (Path)inFile, (Path)outFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        PrivateKey privKey = null;
        String fileContent = null;
        try {
            if (args == null || args.length == 0 || args.length == 1 && (args[0].equalsIgnoreCase(HELP) || args[0].equalsIgnoreCase(HELP_SHORT))) {
                Decrypt.printUsage();
            } else {
                for (int i = 0; i < args.length; ++i) {
                    String[] split = args[i].split("=", 2);
                    if (args[i].startsWith("--key=")) {
                        keyPath = split[1];
                        fileContent = new String(Files.readAllBytes(Paths.get(keyPath, new String[0])), StandardCharsets.UTF_8);
                        continue;
                    }
                    if (args[i].startsWith("--key-password=")) {
                        keyPwd = split[1];
                        continue;
                    }
                    if (args[i].startsWith("--iv=")) {
                        iv = split[1];
                        continue;
                    }
                    if (args[i].startsWith("--encrypted-key=")) {
                        encryptedKey = split[1];
                        continue;
                    }
                    if (args[i].startsWith("--in=")) {
                        encryptedInput = split[1];
                        if (!encryptedInput.startsWith("enc:")) continue;
                        encryptedInput = encryptedInput.substring("enc:".length());
                        continue;
                    }
                    if (args[i].startsWith("--infile=")) {
                        encryptedFile = split[1];
                        continue;
                    }
                    if (!args[i].startsWith("--outfile=")) continue;
                    outFile = split[1];
                }
                if (fileContent != null) {
                    if (fileContent.contains("ENCRYPTED")) {
                        if (keyPwd == null) throw new SOSMissingDataException("The parameter --key-password is required for a password encrypted private key.");
                        privKey = KeyUtil.getPrivateEncryptedKey(fileContent, keyPwd);
                    } else {
                        privKey = KeyUtil.getPrivateKeyFromString(fileContent);
                    }
                }
                String decryptedValue = null;
                if (encryptedInput != null && encryptedInput.contains(" ")) {
                    if (outFile != null) {
                        splittedValues = encryptedInput.split(" ");
                        encryptedKey = splittedValues[0];
                        iv = splittedValues[1];
                        if (encryptedFile == null) {
                            encryptedFile = splittedValues[2];
                        }
                    } else {
                        splittedValues = encryptedInput.split(" ");
                        encryptedKey = splittedValues[0];
                        iv = splittedValues[1];
                        encryptedValue = splittedValues[2];
                    }
                }
                if (keyPath == null || encryptedKey == null || iv == null || encryptedValue == null && encryptedFile == null) {
                    if (keyPath == null) {
                        if (encryptedKey == null && iv == null) {
                            if (encryptedValue != null || encryptedFile != null) throw new SOSMissingDataException("The parameters --key, --encrypted-key and --iv are not set, but are required!");
                            throw new SOSMissingDataException("The parameters --key, --encrypted-key and --iv and at least one of the parameters --in or --infile are not set, but are required!");
                        }
                        if (iv == null && encryptedKey != null) {
                            if (encryptedValue != null || encryptedFile != null) throw new SOSMissingDataException("The parameters --key and --iv are not set, but are required!");
                            throw new SOSMissingDataException("The parameters --key and --iv and at least one of the parameters --in or --infile are not set, but are required!");
                        }
                        if (iv != null && encryptedKey == null) {
                            if (encryptedValue != null || encryptedFile != null) throw new SOSMissingDataException("The parameters --key and --encrypted-key are not set, but are required!");
                            throw new SOSMissingDataException("The parameters --key and --encrypted-key and at least one of the parameters --in or --infile are not set, but are required!");
                        }
                        if (encryptedValue != null || encryptedFile != null) throw new SOSMissingDataException("The parameter --key is not set, but is required!");
                        throw new SOSMissingDataException("The parameter --key and at least one of the parameters --in or --infile are not set, but are required!");
                    }
                    if (encryptedKey == null && iv == null) {
                        if (encryptedValue != null || encryptedFile != null) throw new SOSMissingDataException("The parameters --encrypted-key and --iv are not set, but are required!");
                        throw new SOSMissingDataException("The parameters --encrypted-key and --iv and at least one of the parameters --in or --infile are not set, but are required!");
                    }
                    if (iv == null && encryptedKey != null) {
                        if (encryptedValue != null || encryptedFile != null) throw new SOSMissingDataException("The parameters --iv is not set, but is required!");
                        throw new SOSMissingDataException("The parameters --iv and at least one of the parameters --in or --infile are not set, but are required!");
                    }
                    if (iv != null && encryptedKey == null) {
                        if (encryptedValue != null || encryptedFile != null) throw new SOSMissingDataException("The parameters --encrypted-key is not set, but is required!");
                        throw new SOSMissingDataException("The parameters --encrypted-key and at least one of the parameters --in or --infile are not set, but are required!");
                    }
                }
                if (keyPath != null && iv != null && encryptedKey != null && (encryptedValue != null || encryptedFile != null)) {
                    if (encryptedValue != null) {
                        decryptedValue = Decrypt.decrypt(privKey, iv, encryptedKey, encryptedValue);
                    } else if (encryptedFile != null) {
                        if (outFile == null) {
                            throw new SOSMissingDataException("The parameter --outfile is not set, but is required!");
                        }
                        Decrypt.decryptFile(privKey, iv, Paths.get(encryptedFile, new String[0]), Paths.get(outFile, new String[0]));
                    }
                }
                if (decryptedValue != null) {
                    System.out.println(decryptedValue);
                }
            }
            System.exit(0);
            return;
        }
        catch (SOSMissingDataException e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    public static void printUsage() {
        System.out.println();
        System.out.println("Usage: decrypt [Options] [Switches]");
        System.out.println();
        System.out.println("  Options:");
        System.out.printf("  %-29s | %s%n", "--key=<path>", "path to private key file for decryption.");
        System.out.printf("  %-29s | %s%n", "--key-password=<password>", "passphrase for the private key.");
        System.out.printf("  %-29s | %s%n", "--iv=<initialization-vector>", "base64 encoded initialization vector (returned by encryption).");
        System.out.printf("  %-29s | %s%n", "--encrypted-key=<key>", "base64 encoded encrypted symmetric key (returned by encryption).");
        System.out.printf("  %-29s | %s%n", "--in=<encryption-result>", "result of previous encryption or encrypted secret.");
        System.out.printf("  %-29s | %s%n", "--infile=<path-to-file>", "path to encrypted input file.");
        System.out.printf("  %-29s | %s%n", "--outfile=<path-to-file>", "path to decrypted output file.");
        System.out.println();
        System.out.println("  Switches:");
        System.out.printf("  %-29s | %s%n", "--help | -h", "displays usage. This switch is exclusive without any [Options].");
        System.out.println();
    }
}

