/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.sign.keys.key;

import com.sos.commons.sign.keys.certificate.CertificateUtils;
import com.sos.commons.sign.keys.keyStore.KeyStoreUtil;
import com.sos.commons.sign.keys.keyStore.KeystoreType;
import com.sos.exception.SOSKeyException;
import com.sos.joc.model.sign.JocKeyAlgorithm;
import com.sos.joc.model.sign.JocKeyPair;
import com.sos.joc.model.sign.JocKeyType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyUtil.class);

    public static JocKeyPair createKeyPair(String userId, String passphrase, Long secondsToExpire) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException, PGPException {
        return KeyUtil.createKeyPair(userId, passphrase, secondsToExpire, 4096);
    }

    public static JocKeyPair createKeyPair(String userId, String passphrase, Long secondsToExpire, Integer algorythmBitLength) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException, PGPException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        if (algorythmBitLength == null) {
            kpg.initialize(4096);
        } else {
            kpg.initialize(algorythmBitLength);
        }
        KeyPair kp = kpg.generateKeyPair();
        ByteArrayOutputStream privateOutput = new ByteArrayOutputStream();
        ByteArrayOutputStream publicOutput = new ByteArrayOutputStream();
        PGPSecretKey privateKey = null;
        privateKey = passphrase != null ? KeyUtil.exportSecretKey(kp, userId, passphrase.toCharArray(), secondsToExpire) : KeyUtil.exportSecretKey(kp, userId, "".toCharArray(), secondsToExpire);
        KeyUtil.createStreamsWithKeyData(privateOutput, publicOutput, privateKey, true);
        JocKeyPair keyPair = new JocKeyPair();
        keyPair.setPrivateKey(privateOutput.toString());
        keyPair.setPublicKey(publicOutput.toString());
        keyPair.setValidUntil(KeyUtil.getValidUntil(privateKey));
        keyPair.setKeyID(KeyUtil.getKeyIDAsHexString(privateKey).toUpperCase());
        return keyPair;
    }

    public static JocKeyPair createRSAJocKeyPair(String account, String dn) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(4096);
        KeyPair kp = kpg.generateKeyPair();
        JocKeyPair keyPair = new JocKeyPair();
        byte[] encodedPrivate = kp.getPrivate().getEncoded();
        String encodedPrivateToString = DatatypeConverter.printBase64Binary((byte[])encodedPrivate);
        byte[] encodedPublic = kp.getPublic().getEncoded();
        String encodedPublicToString = DatatypeConverter.printBase64Binary((byte[])encodedPublic);
        keyPair.setPrivateKey(KeyUtil.formatPrivateRSAKey(encodedPrivateToString));
        keyPair.setPublicKey(KeyUtil.formatPublicRSAKey(encodedPublicToString));
        keyPair.setKeyID(KeyUtil.getRSAKeyIDAsHexString(kp.getPublic()).toUpperCase());
        keyPair.setKeyAlgorithm(JocKeyAlgorithm.RSA.name());
        keyPair.setKeyType(JocKeyType.PRIVATE.name());
        try {
            keyPair.setCertificate(CertificateUtils.asPEMString(KeyUtil.generateCertificateFromKeyPair(kp, account, "SHA256WithRSA", dn)));
        }
        catch (IOException | CertificateEncodingException e) {
            LOGGER.warn("certificate could not be extracted from key pair. cause:", (Throwable)e);
        }
        return keyPair;
    }

    public static JocKeyPair createECDSAJOCKeyPair(String account) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return KeyUtil.createECDSAJOCKeyPair("prime256v1", account, null);
    }

    public static JocKeyPair createECDSAJOCKeyPair(String account, String dn) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return KeyUtil.createECDSAJOCKeyPair("prime256v1", account, dn);
    }

    public static JocKeyPair createECDSAJOCKeyPair(String curveName, String account, String dn) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPair kp = KeyUtil.createECDSAKeyPair(curveName);
        JocKeyPair keyPair = new JocKeyPair();
        byte[] encodedPrivate = kp.getPrivate().getEncoded();
        String encodedPrivateToString = DatatypeConverter.printBase64Binary((byte[])encodedPrivate);
        byte[] encodedPublic = kp.getPublic().getEncoded();
        String encodedPublicToString = DatatypeConverter.printBase64Binary((byte[])encodedPublic);
        keyPair.setPrivateKey(KeyUtil.formatPrivateECDSAKey(encodedPrivateToString));
        keyPair.setPublicKey(KeyUtil.formatPublicECDSAKey(encodedPublicToString));
        keyPair.setKeyAlgorithm(JocKeyAlgorithm.ECDSA.name());
        keyPair.setKeyType(JocKeyType.PRIVATE.name());
        try {
            keyPair.setCertificate(CertificateUtils.asPEMString(KeyUtil.generateCertificateFromKeyPair(kp, account, "SHA512WithECDSA", dn)));
        }
        catch (IOException | CertificateEncodingException e) {
            LOGGER.warn("certificate could not be extracted from key pair. cause:", (Throwable)e);
        }
        return keyPair;
    }

    public static JocKeyPair createECDSAJOCKeyPair(KeyPair kp) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        JocKeyPair keyPair = new JocKeyPair();
        byte[] encodedPrivate = kp.getPrivate().getEncoded();
        String encodedPrivateToString = DatatypeConverter.printBase64Binary((byte[])encodedPrivate);
        byte[] encodedPublic = kp.getPublic().getEncoded();
        String encodedPublicToString = DatatypeConverter.printBase64Binary((byte[])encodedPublic);
        keyPair.setPrivateKey(KeyUtil.formatPrivateECDSAKey(encodedPrivateToString));
        keyPair.setPublicKey(KeyUtil.formatPublicECDSAKey(encodedPublicToString));
        return keyPair;
    }

    public static KeyPair createRSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyUtil.createRSAKeyPair(4096);
    }

    public static KeyPair createRSAKeyPair(int bitLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(bitLength);
        return kpg.generateKeyPair();
    }

    public static KeyPair createECDSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return KeyUtil.createECDSAKeyPair("prime256v1");
    }

    public static KeyPair createECDSAKeyPair(String curveName) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("ECDSA", bcProvider.getName());
        kpg.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static JocKeyPair createJOCKeyPair(KeyPair keyPair) throws NoSuchAlgorithmException, NoSuchProviderException {
        JocKeyPair jocKeyPair = new JocKeyPair();
        byte[] encodedPrivate = keyPair.getPrivate().getEncoded();
        String encodedPrivateToString = DatatypeConverter.printBase64Binary((byte[])encodedPrivate);
        byte[] encodedPublic = keyPair.getPublic().getEncoded();
        String encodedPublicToString = DatatypeConverter.printBase64Binary((byte[])encodedPublic);
        jocKeyPair.setPrivateKey(KeyUtil.formatPrivateKey(encodedPrivateToString));
        jocKeyPair.setPublicKey(KeyUtil.formatPublicKey(encodedPublicToString));
        jocKeyPair.setKeyID(KeyUtil.getRSAKeyIDAsHexString(keyPair.getPublic()).toUpperCase());
        return jocKeyPair;
    }

    public static String extractPublicKey(String privateKey) throws IOException, PGPException {
        InputStream privateKeyStream = IOUtils.toInputStream((String)privateKey, (Charset)StandardCharsets.UTF_8);
        return KeyUtil.extractPublicKey(privateKeyStream);
    }

    public static String extractPublicKey(Path privateKey) throws IOException, PGPException {
        InputStream privateKeyPath = Files.newInputStream(privateKey, new OpenOption[0]);
        return KeyUtil.extractPublicKey(privateKeyPath);
    }

    public static String extractPublicKey(InputStream privateKey) throws IOException, PGPException {
        ByteArrayOutputStream publicOutput = null;
        publicOutput = new ByteArrayOutputStream();
        PGPPublicKey pgpPublicKey = KeyUtil.extractPGPPublicKey(privateKey);
        if (pgpPublicKey != null) {
            ArmoredOutputStream publicOutputArmored = new ArmoredOutputStream((OutputStream)publicOutput);
            pgpPublicKey.encode((OutputStream)publicOutputArmored);
            publicOutputArmored.close();
            return ((Object)publicOutput).toString();
        }
        return null;
    }

    public static PGPPublicKey extractPGPPublicKey(InputStream privateKey) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSec = null;
        PGPPublicKey pgpPublicKey = null;
        pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)privateKey), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator keyRingIter = pgpSec.getKeyRings();
        block0: while (keyRingIter.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIter.next();
            Iterator keyIter = keyRing.getSecretKeys();
            while (keyIter.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)keyIter.next();
                if (!key.isSigningKey()) continue;
                pgpPublicKey = key.getPublicKey();
                continue block0;
            }
        }
        return pgpPublicKey;
    }

    private static void createStreamsWithKeyData(OutputStream privateOut, OutputStream publicOut, PGPSecretKey privateKey, boolean armored) throws IOException {
        if (armored) {
            privateOut = new ArmoredOutputStream(privateOut);
            publicOut = new ArmoredOutputStream(publicOut);
        }
        privateKey.encode(privateOut);
        privateOut.close();
        PGPPublicKey key = privateKey.getPublicKey();
        key.encode(publicOut);
        publicOut.close();
    }

    private static PGPSecretKey exportSecretKey(KeyPair pair, String identity, char[] passPhrase, Long secondsToExpire) throws PGPException {
        PGPDigestCalculator sha1Calc = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        JcaPGPKeyPair keyPair = new JcaPGPKeyPair(1, pair, new Date());
        PGPSignatureSubpacketVector subpacketVector = null;
        if (secondsToExpire != null) {
            PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
            subpacketGenerator.setKeyExpirationTime(false, secondsToExpire.longValue());
            subpacketVector = subpacketGenerator.generate();
        }
        PGPSecretKey privateKey = new PGPSecretKey(1, (PGPKeyPair)keyPair, identity, sha1Calc, subpacketVector, null, (PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(keyPair.getPublicKey().getAlgorithm(), 2), new JcePBESecretKeyEncryptorBuilder(3, sha1Calc).setProvider("BC").build(passPhrase));
        return privateKey;
    }

    public static String getKeyIDAsHexString(PGPSecretKey privateKey) {
        return Long.toHexString(privateKey.getKeyID());
    }

    public static String getKeyIDAsHexString(PGPPublicKey publicKey) {
        return Long.toHexString(publicKey.getKeyID());
    }

    public static String getRSAKeyIDAsHexString(PublicKey key) {
        return KeyUtil.toHex(KeyUtil.createRSAKeyID(key));
    }

    public static String getECDSAKeyIDAsHexString(PublicKey key) {
        return KeyUtil.toHex(KeyUtil.createRSAKeyID(key));
    }

    public static Date getValidUntil(PGPSecretKey privateKey) {
        return KeyUtil.getValidUntil(privateKey.getPublicKey());
    }

    public static Date getValidUntil(PGPPublicKey publicKey) {
        Iterator iter = publicKey.getSignaturesOfType(1);
        Long keyExpirationTime = null;
        while (iter.hasNext()) {
            keyExpirationTime = ((PGPSignature)iter.next()).getHashedSubPackets().getKeyExpirationTime();
        }
        Date creationDate = publicKey.getCreationTime();
        Long validSeconds = publicKey.getValidSeconds();
        Date validUntil = null;
        if (validSeconds != null && validSeconds != 0L) {
            validUntil = new Date(creationDate.getTime() + validSeconds * 1000L);
        } else if (keyExpirationTime != null && keyExpirationTime != 0L) {
            validUntil = Date.from(Instant.ofEpochSecond(keyExpirationTime));
        }
        return validUntil;
    }

    public static boolean isECDSAKeyPairValid(JocKeyPair keyPair) {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        try {
            KeyFactory kf = KeyFactory.getInstance("EC");
            String privKey = keyPair.getPrivateKey();
            if (privKey != null) {
                byte[] privKeyBA = org.bouncycastle.util.encoders.Base64.decode((String)KeyUtil.stripFormatFromPrivateKey(privKey));
                PrivateKey ecPrivate = kf.generatePrivate(new PKCS8EncodedKeySpec(privKeyBA));
                return ecPrivate != null;
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return false;
        }
        return false;
    }

    public static boolean isKeyPairValid(JocKeyPair keyPair) {
        if (keyPair.getPrivateKey() != null) {
            if ("PGP".equals(keyPair.getKeyAlgorithm())) {
                try {
                    PGPPrivateKey priv = KeyUtil.getPrivatePGPKey(keyPair.getPrivateKey());
                    return priv != null;
                }
                catch (IOException | IllegalArgumentException | PGPException e) {
                    return false;
                }
            }
            if ("RSA".equals(keyPair.getKeyAlgorithm())) {
                try {
                    PrivateKey pk = KeyUtil.getPrivateKeyFromString(keyPair.getPrivateKey());
                    return pk != null;
                }
                catch (ClassCastException e) {
                    try {
                        KeyPair kp = KeyUtil.getKeyPairFromRSAPrivatKeyString(keyPair.getPrivateKey());
                        return kp != null && kp.getPrivate() != null;
                    }
                    catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e1) {
                        return false;
                    }
                }
                catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                    return false;
                }
            }
            if ("ECDSA".equals(keyPair.getKeyAlgorithm())) {
                try {
                    KeyPair kp = KeyUtil.getKeyPairFromECDSAPrivatKeyString(keyPair.getPrivateKey());
                    return kp != null && kp.getPrivate() != null;
                }
                catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                    return false;
                }
            }
        } else if (keyPair.getPublicKey() != null) {
            if ("PGP".equals(keyPair.getKeyAlgorithm())) {
                try {
                    PGPPublicKey publicKey = KeyUtil.getPGPPublicKeyFromString(keyPair.getPublicKey());
                    return publicKey != null;
                }
                catch (IOException | PGPException e) {
                    return false;
                }
            }
            if ("RSA".equals(keyPair.getKeyAlgorithm())) {
                try {
                    PublicKey pub = KeyUtil.getRSAPublicKeyFromString(keyPair.getPublicKey());
                    return pub != null;
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    return false;
                }
            }
            if ("ECDSA".equals(keyPair.getKeyAlgorithm())) {
                try {
                    PublicKey pub = KeyUtil.getECDSAPublicKeyFromString(keyPair.getPublicKey());
                    return pub != null;
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    return false;
                }
            }
        } else if (keyPair.getCertificate() != null) {
            try {
                X509Certificate cert = KeyUtil.getX509Certificate(keyPair.getCertificate());
                return cert != null;
            }
            catch (UnsupportedEncodingException | CertificateException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isECDSARootKeyPairValid(JocKeyPair keyPair) {
        boolean privateKeyValid = false;
        boolean certificateVaild = false;
        try {
            KeyPair kp = KeyUtil.getKeyPairFromECDSAPrivatKeyString(keyPair.getPrivateKey());
            privateKeyValid = kp != null && kp.getPrivate() != null;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            privateKeyValid = false;
        }
        try {
            X509Certificate cert = KeyUtil.getX509Certificate(keyPair.getCertificate());
            certificateVaild = cert != null;
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            certificateVaild = false;
        }
        return privateKeyValid && certificateVaild;
    }

    public static boolean isCertificateValid(String certificate) {
        if (certificate != null) {
            try {
                X509Certificate cert = KeyUtil.getX509Certificate(certificate);
                return cert != null;
            }
            catch (UnsupportedEncodingException | CertificateException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isKeyValid(String key, String keyAlgorithm) {
        if (key != null) {
            if ("PGP".equals(keyAlgorithm)) {
                if (key.startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----")) {
                    try {
                        String publicFromPrivateKey = KeyUtil.extractPublicKey(key);
                        return publicFromPrivateKey != null;
                    }
                    catch (IOException | PGPException publicFromPrivateException) {
                        try {
                            return KeyUtil.getPGPPublicKeyFromInputStream(IOUtils.toInputStream((String)key, (Charset)StandardCharsets.UTF_8)) != null;
                        }
                        catch (IOException | PGPException publicPGPfromPublicException) {
                            return false;
                        }
                    }
                }
                if (key.startsWith("-----BEGIN PGP PUBLIC KEY BLOCK-----")) {
                    try {
                        PGPPublicKey pgpPubKey = KeyUtil.getPGPPublicKeyFromString(key);
                        return pgpPubKey != null;
                    }
                    catch (IOException | PGPException e) {
                        return false;
                    }
                }
            } else if ("RSA".equals(keyAlgorithm)) {
                if (key.startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
                    try {
                        KeyPair kp = KeyUtil.getKeyPairFromRSAPrivatKeyString(key);
                        return kp != null;
                    }
                    catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                        return false;
                    }
                }
                if (key.startsWith("-----BEGIN PRIVATE KEY-----")) {
                    try {
                        KeyPair kp = KeyUtil.getKeyPairFromPrivatKeyString(key);
                        return kp != null;
                    }
                    catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                        return false;
                    }
                }
                if (key.startsWith("-----BEGIN RSA PUBLIC KEY-----") || key.startsWith("-----BEGIN PUBLIC KEY-----")) {
                    SubjectPublicKeyInfo spki = KeyUtil.getSubjectPublicKeyInfo(key);
                    return spki != null;
                }
            } else if ("ECDSA".equals(keyAlgorithm)) {
                // empty if block
            }
        }
        return false;
    }

    public static boolean isKeyNotNull(PGPPublicKey key) {
        return key != null;
    }

    public static PGPPublicKey getPGPPublicKeyFromString(String publicKey) throws IOException, PGPException {
        InputStream publicKeyDecoderStream = PGPUtil.getDecoderStream((InputStream)IOUtils.toInputStream((String)publicKey, (Charset)StandardCharsets.UTF_8));
        JcaPGPPublicKeyRingCollection pgpPubKeyRing = new JcaPGPPublicKeyRingCollection(publicKeyDecoderStream);
        Iterator publicKeyRingIterator = pgpPubKeyRing.getKeyRings();
        PGPPublicKey pgpPublicKey = null;
        while (pgpPublicKey == null && publicKeyRingIterator.hasNext()) {
            PGPPublicKeyRing pgpPublicKeyRing = (PGPPublicKeyRing)publicKeyRingIterator.next();
            Iterator pgpPublicKeyIterator = pgpPublicKeyRing.getPublicKeys();
            while (pgpPublicKey == null && pgpPublicKeyIterator.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)pgpPublicKeyIterator.next();
                if (!key.isEncryptionKey()) continue;
                pgpPublicKey = key;
            }
        }
        return pgpPublicKey;
    }

    public static PGPPublicKey getPGPPublicKeyFromInputStream(InputStream publicKey) throws IOException, PGPException {
        InputStream publicKeyDecoderStream = PGPUtil.getDecoderStream((InputStream)publicKey);
        JcaPGPPublicKeyRingCollection pgpPubKeyRing = new JcaPGPPublicKeyRingCollection(publicKeyDecoderStream);
        Iterator publicKeyRingIterator = pgpPubKeyRing.getKeyRings();
        PGPPublicKey pgpPublicKey = null;
        while (pgpPublicKey == null && publicKeyRingIterator.hasNext()) {
            PGPPublicKeyRing pgpPublicKeyRing = (PGPPublicKeyRing)publicKeyRingIterator.next();
            Iterator pgpPublicKeyIterator = pgpPublicKeyRing.getPublicKeys();
            while (pgpPublicKey == null && pgpPublicKeyIterator.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)pgpPublicKeyIterator.next();
                if (!key.isEncryptionKey()) continue;
                pgpPublicKey = key;
            }
        }
        return pgpPublicKey;
    }

    public static PrivateKey getPemPrivateKeyFromRSAString(String privateKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
        PEMKeyPair pemKeyPair = (PEMKeyPair)pemParser.readObject();
        byte[] privateEncoded = pemKeyPair.getPrivateKeyInfo().getEncoded();
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
        pemParser.close();
        return privKey;
    }

    public static KeyPair getKeyPairFromRSAPrivatKeyString(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrivateKey privKey = KeyUtil.getPrivateRSAKeyFromString(privateKey);
        RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privKey;
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey publicKey = kf.generatePublic(rsaPublicKeySpec);
        return new KeyPair(publicKey, privKey);
    }

    public static KeyPair getKeyPairFromECDSAPrivatKeyString(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrivateKey privKey = KeyUtil.getPrivateECDSAKeyFromString(privateKey);
        ECPrivateKey ecdsaPrivateKey = (ECPrivateKey)privKey;
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecdsaPrivateKey.getParams().getGenerator(), ecdsaPrivateKey.getParams());
        KeyFactory kf = KeyFactory.getInstance("EC");
        PublicKey publicKey = kf.generatePublic(ecPublicKeySpec);
        return new KeyPair(publicKey, privKey);
    }

    public static KeyPair getKeyPairFromPrivatKeyString(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        PrivateKey privKey;
        try {
            privKey = KeyUtil.getPrivateKeyFromString(privateKey);
        }
        catch (Exception e1) {
            privKey = KeyUtil.getPemPrivateKeyFromRSAString(privateKey);
        }
        try {
            RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)privKey;
            RSAPublicKeySpec rsaPubKeySpec = new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent());
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey publicKey = kf.generatePublic(rsaPubKeySpec);
            return new KeyPair(publicKey, privKey);
        }
        catch (ClassCastException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            ECPrivateKey ecdsaPrivateKey = (ECPrivateKey)privKey;
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecdsaPrivateKey.getParams().getGenerator(), ecdsaPrivateKey.getParams());
            KeyFactory kf = KeyFactory.getInstance("EC");
            PublicKey publicKey = kf.generatePublic(ecPublicKeySpec);
            return new KeyPair(publicKey, privKey);
        }
    }

    public static boolean pubKeyFromPairAndCertMatch(PublicKey fromPair, PublicKey fromCert) {
        return fromPair.equals(fromCert);
    }

    public static boolean pubKeyMatchesPrivKey(PrivateKey privKey, PublicKey pubKey) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)pubKey;
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privKey;
        return rsaPublicKey.getModulus().equals(rsaPrivateKey.getModulus()) && BigInteger.valueOf(2L).modPow(rsaPublicKey.getPublicExponent().multiply(rsaPrivateKey.getPrivateExponent()).subtract(BigInteger.ONE), rsaPublicKey.getModulus()).equals(BigInteger.ONE);
    }

    public static boolean pubKeyFromCertMatchPrivKey(PrivateKey privKey, Certificate certificate) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)certificate.getPublicKey();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privKey;
        return rsaPublicKey.getModulus().equals(rsaPrivateKey.getModulus()) && BigInteger.valueOf(2L).modPow(rsaPublicKey.getPublicExponent().multiply(rsaPrivateKey.getPrivateExponent()).subtract(BigInteger.ONE), rsaPublicKey.getModulus()).equals(BigInteger.ONE);
    }

    public static boolean pubKeyFromPairAndCertMatch(PublicKey pubKey, X509Certificate cert) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)pubKey;
        BigInteger modFromKey = rsaPublicKey.getModulus();
        BigInteger exponentFromKey = rsaPublicKey.getPublicExponent();
        RSAPublicKey rsaPublicKeyFromCert = (RSAPublicKey)cert.getPublicKey();
        BigInteger modFromCertKey = rsaPublicKeyFromCert.getModulus();
        BigInteger exponentFromCertKey = rsaPublicKeyFromCert.getPublicExponent();
        return modFromKey.equals(modFromCertKey) && exponentFromKey.equals(exponentFromCertKey);
    }

    public static boolean pubKeyFromPairAndCertMatch(PublicKey pubKey, Certificate cert) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)pubKey;
        BigInteger modFromKey = rsaPublicKey.getModulus();
        BigInteger exponentFromKey = rsaPublicKey.getPublicExponent();
        RSAPublicKey rsaPublicKeyFromCert = (RSAPublicKey)cert.getPublicKey();
        BigInteger modFromCertKey = rsaPublicKeyFromCert.getModulus();
        BigInteger exponentFromCertKey = rsaPublicKeyFromCert.getPublicExponent();
        return modFromKey.equals(modFromCertKey) && exponentFromKey.equals(exponentFromCertKey);
    }

    public static boolean compareRSAKeyAndCertificate(String privateKey, String certificate) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException {
        PemReader certReader = new PemReader((Reader)new StringReader(certificate));
        PemObject certAsPemObject = certReader.readPemObject();
        certReader.close();
        if (!certAsPemObject.getType().equalsIgnoreCase("CERTIFICATE")) {
            throw new IllegalArgumentException("Certificate file does not contain a certificate but a " + certAsPemObject.getType());
        }
        byte[] x509Data = certAsPemObject.getContent();
        CertificateFactory fact = CertificateFactory.getInstance("X509");
        Certificate cert = fact.generateCertificate(new ByteArrayInputStream(x509Data));
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate file does not contain an X509 certificate");
        }
        PublicKey publicKey = cert.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("Certificate file does not contain an RSA public key but a " + publicKey.getClass().getName());
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        byte[] certModulusData = rsaPublicKey.getModulus().toByteArray();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] certID = sha256.digest(certModulusData);
        String certIDinHex = new String(DatatypeConverter.printHexBinary((byte[])certID));
        PemReader privKeyReader = new PemReader((Reader)new StringReader(privateKey));
        PemObject privKeyAsPemObject = privKeyReader.readPemObject();
        privKeyReader.close();
        if (!privKeyAsPemObject.getType().equalsIgnoreCase("RSA PRIVATE KEY")) {
            throw new IllegalArgumentException("Key file does not contain a private key but a " + privKeyAsPemObject.getType());
        }
        PrivateKey privKey = KeyUtil.getPemPrivateKeyFromRSAString(privateKey);
        if (!(privKey instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException("Key file does not contain an RSA private key");
        }
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privKey;
        byte[] keyModulusData = rsaPrivateKey.getModulus().toByteArray();
        byte[] keyID = sha256.digest(keyModulusData);
        String keyIDinHex = new String(DatatypeConverter.printHexBinary((byte[])keyID));
        return certIDinHex.equals(keyIDinHex);
    }

    public static PEMKeyPair getPemKeyPairFromRSAPrivatKeyString(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
        PEMKeyPair keyPair = (PEMKeyPair)pemParser.readObject();
        pemParser.close();
        return keyPair;
    }

    public static AsymmetricKeyParameter loadPublicKey(InputStream is) {
        SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)KeyUtil.readPemObject(is);
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)spki);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create public key object based on input data", ex);
        }
    }

    public static SubjectPublicKeyInfo getSubjectPublicKeyInfo(String publicKey) {
        SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)KeyUtil.readPemObject(publicKey);
        return spki;
    }

    public static AsymmetricKeyParameter loadPublicKey(String publicKey) {
        SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)KeyUtil.readPemObject(publicKey);
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)spki);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create public key object based on input data", ex);
        }
    }

    public static AsymmetricKeyParameter loadPublicKeyFromCertificate(String certificate) {
        X509CertificateHolder x509CertHolder = (X509CertificateHolder)KeyUtil.readPemObject(certificate);
        SubjectPublicKeyInfo spki = x509CertHolder.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)spki);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create public key object based on input data", ex);
        }
    }

    public static SubjectPublicKeyInfo getSubjectPublicKeyInfoFromCertificate(String certificate) {
        X509CertificateHolder x509CertHolder = (X509CertificateHolder)KeyUtil.readPemObject(certificate);
        SubjectPublicKeyInfo spki = x509CertHolder.getSubjectPublicKeyInfo();
        return spki;
    }

    public static String getPublicKeyAsString(SubjectPublicKeyInfo spki) throws IOException {
        ASN1Primitive asn1Primitve = spki.parsePublicKey();
        String publicKey = org.bouncycastle.util.encoders.Base64.toBase64String((byte[])asn1Primitve.getEncoded());
        return KeyUtil.formatPublicKey(publicKey);
    }

    public static AsymmetricKeyParameter loadPrivateKey(InputStream is) {
        PEMKeyPair keyPair = (PEMKeyPair)KeyUtil.readPemObject(is);
        PrivateKeyInfo pki = keyPair.getPrivateKeyInfo();
        try {
            return PrivateKeyFactory.createKey((PrivateKeyInfo)pki);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create private key object based on input data", ex);
        }
    }

    public static AsymmetricKeyParameter loadPrivateKey(String privateKey) {
        PEMKeyPair keyPair = (PEMKeyPair)KeyUtil.readPemObject(privateKey);
        PrivateKeyInfo pki = keyPair.getPrivateKeyInfo();
        try {
            return PrivateKeyFactory.createKey((PrivateKeyInfo)pki);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create private key object based on input data", ex);
        }
    }

    private static Object readPemObject(InputStream is) {
        PEMParser pemParser = null;
        try {
            Validate.notNull((Object)is, (String)"Input data stream cannot be null", (Object[])new Object[0]);
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            pemParser = new PEMParser((Reader)isr);
            Object obj = pemParser.readObject();
            if (obj == null) {
                throw new Exception("No PEM object found");
            }
            Object object = obj;
            return object;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Cannot read PEM object from input data", ex);
        }
        finally {
            try {
                pemParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Object readPemObject(String value) {
        PEMParser pemParser = null;
        try {
            Validate.notNull((Object)value, (String)"Input data stream cannot be null", (Object[])new Object[0]);
            pemParser = new PEMParser((Reader)new StringReader(value));
            Object obj = pemParser.readObject();
            if (obj == null) {
                throw new Exception("No PEM object found");
            }
            Object object = obj;
            return object;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Cannot read PEM object from input data", ex);
        }
        finally {
            try {
                pemParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static PrivateKey getPrivateKeyFromString(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        Object pemObject = KeyUtil.readPemObject(privateKey);
        PrivateKeyInfo privateKeyInfo = null;
        privateKeyInfo = pemObject instanceof PEMKeyPair ? ((PEMKeyPair)pemObject).getPrivateKeyInfo() : (PrivateKeyInfo)pemObject;
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            KeyFactory kf = KeyFactory.getInstance("EC");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
        }
    }

    public static PGPPrivateKey getPrivatePGPKey(String privateKey) throws IOException, PGPException {
        InputStream privateKeyStream = IOUtils.toInputStream((String)privateKey, (Charset)StandardCharsets.UTF_8);
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPSecretKey secretKey = KeyUtil.readSecretKey(privateKeyStream);
        return secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build("".toCharArray()));
    }

    public static PrivateKey getPrivateEncryptedRSAKeyFromString(String privateKey, String keyPasswd) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrivateKey privKey = null;
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
        Object readObject = pemParser.readObject();
        PEMEncryptedKeyPair pemEncryptedKeyPair = (PEMEncryptedKeyPair)readObject;
        BcPEMDecryptorProvider keyDecryptorProvider = new BcPEMDecryptorProvider(keyPasswd.toCharArray());
        PEMKeyPair pemKeyPair = pemEncryptedKeyPair.decryptKeyPair((PEMDecryptorProvider)keyDecryptorProvider);
        byte[] privateEncoded = pemKeyPair.getPrivateKeyInfo().getEncoded();
        privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
        return privKey;
    }

    public static PrivateKey getPrivateEncryptedKey(String privateKey, String keyPasswd) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, PKCSException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrivateKey privKey = null;
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
        Object readObject = pemParser.readObject();
        if (readObject instanceof PKCS8EncryptedPrivateKeyInfo) {
            try {
                PKCS8EncryptedPrivateKeyInfo keyInfo = (PKCS8EncryptedPrivateKeyInfo)readObject;
                JcePKCSPBEInputDecryptorProviderBuilder provider = new JcePKCSPBEInputDecryptorProviderBuilder();
                InputDecryptorProvider prov = provider.build(keyPasswd.toCharArray());
                byte[] privateEncoded = keyInfo.decryptPrivateKeyInfo(prov).getEncoded();
                privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
            }
            catch (Exception e) {
                try {
                    JceOpenSSLPKCS8DecryptorProviderBuilder jce = new JceOpenSSLPKCS8DecryptorProviderBuilder();
                    PKCS8EncryptedPrivateKeyInfo encryptedKeyInfo = (PKCS8EncryptedPrivateKeyInfo)readObject;
                    jce.setProvider("BC");
                    InputDecryptorProvider decProv = jce.build(keyPasswd.toCharArray());
                    PrivateKeyInfo keyInfo = encryptedKeyInfo.decryptPrivateKeyInfo(decProv);
                    privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(keyInfo.getEncoded()));
                }
                catch (Exception e1) {
                    PKCS8EncryptedPrivateKeyInfo keyInfo = (PKCS8EncryptedPrivateKeyInfo)readObject;
                    JcePKCSPBEInputDecryptorProviderBuilder provider = new JcePKCSPBEInputDecryptorProviderBuilder();
                    InputDecryptorProvider prov = provider.build(keyPasswd.toCharArray());
                    byte[] privateEncoded = keyInfo.decryptPrivateKeyInfo(prov).getEncoded();
                    kf = KeyFactory.getInstance("ECDSA");
                    privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
                }
            }
            return privKey;
        }
        PEMEncryptedKeyPair pemEncryptedKeyPair = (PEMEncryptedKeyPair)readObject;
        BcPEMDecryptorProvider keyDecryptorProvider = new BcPEMDecryptorProvider(keyPasswd.toCharArray());
        PEMKeyPair pemKeyPair = pemEncryptedKeyPair.decryptKeyPair((PEMDecryptorProvider)keyDecryptorProvider);
        byte[] privateEncoded = pemKeyPair.getPrivateKeyInfo().getEncoded();
        try {
            privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
        }
        catch (Exception e) {
            kf = KeyFactory.getInstance("ECDSA");
            privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
        }
        return privKey;
    }

    public static PrivateKey getPrivateRSAKeyFromString(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrivateKey privKey = null;
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PEMParser pemParser = null;
        try {
            PKCS8EncodedKeySpec pkcs8key = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(KeyUtil.stripFormatFromPrivateRSAKey(privateKey)));
            privKey = kf.generatePrivate(pkcs8key);
        }
        catch (Exception e) {
            pemParser = new PEMParser((Reader)new StringReader(privateKey));
            Object readObject = pemParser.readObject();
            if (readObject instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)readObject;
                byte[] privateEncoded = pemKeyPair.getPrivateKeyInfo().getEncoded();
                privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
            } else {
                PrivateKeyInfo privKeyInfo = (PrivateKeyInfo)readObject;
                byte[] privateEncoded = privKeyInfo.getEncoded();
                privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
            }
            pemParser.close();
        }
        return privKey;
    }

    public static PrivateKey getPrivateECDSAKeyFromString(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyFactory kf = KeyFactory.getInstance("EC");
        PrivateKey privKey = null;
        try {
            PKCS8EncodedKeySpec pkcs8key = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(KeyUtil.stripFormatFromPrivateECDSAKey(privateKey)));
            privKey = kf.generatePrivate(pkcs8key);
        }
        catch (Exception e) {
            PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
            Object readObject = pemParser.readObject();
            if (readObject instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)readObject;
                byte[] privateEncoded = pemKeyPair.getPrivateKeyInfo().getEncoded();
                privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
            } else {
                PrivateKeyInfo privKeyInfo = (PrivateKeyInfo)readObject;
                byte[] privateEncoded = privKeyInfo.getEncoded();
                privKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateEncoded));
            }
            pemParser.close();
        }
        return privKey;
    }

    public static PublicKey getRSAPublicKeyFromString(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decoded = null;
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        decoded = publicKey.startsWith("-----BEGIN RSA PUBLIC KEY-----") ? org.bouncycastle.util.encoders.Base64.decode((String)KeyUtil.stripFormatFromPublicRSAKey(publicKey)) : (publicKey.startsWith("-----BEGIN PUBLIC KEY-----") ? org.bouncycastle.util.encoders.Base64.decode((String)KeyUtil.stripFormatFromPublicKey(publicKey)) : org.bouncycastle.util.encoders.Base64.decode((String)publicKey));
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(decoded);
        return kf.generatePublic(pubKeySpec);
    }

    public static PublicKey getECDSAPublicKeyFromString(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decoded = null;
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        KeyFactory kf = KeyFactory.getInstance("ECDSA");
        decoded = publicKey.startsWith("-----BEGIN EC PUBLIC KEY-----") || publicKey.startsWith("-----BEGIN ECDSA PUBLIC KEY-----") ? org.bouncycastle.util.encoders.Base64.decode((String)KeyUtil.stripFormatFromPublicECDSAKey(publicKey)) : org.bouncycastle.util.encoders.Base64.decode((String)publicKey);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(decoded);
        return kf.generatePublic(pubKeySpec);
    }

    public static byte[] decodePublicKeyString(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decoded = null;
        decoded = publicKey.startsWith("-----BEGIN RSA PUBLIC KEY-----") ? org.bouncycastle.util.encoders.Base64.decode((String)KeyUtil.stripFormatFromPublicRSAKey(publicKey)) : (publicKey.startsWith("-----BEGIN EC PUBLIC KEY-----") ? org.bouncycastle.util.encoders.Base64.decode((String)KeyUtil.stripFormatFromPublicECDSAKey(publicKey)) : (publicKey.startsWith("-----BEGIN PUBLIC KEY-----") ? org.bouncycastle.util.encoders.Base64.decode((String)KeyUtil.stripFormatFromPublicKey(publicKey)) : org.bouncycastle.util.encoders.Base64.decode((String)publicKey)));
        return decoded;
    }

    public static PublicKey getPublicKeyFromString(byte[] decoded) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(decoded);
        return kf.generatePublic(pubKeySpec);
    }

    public static PublicKey getECPublicKeyFromString(byte[] decoded) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance("EC");
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(decoded);
        return kf.generatePublic(pubKeySpec);
    }

    public static PublicKey extractPublicKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PublicKey convertToRSAPublicKey(byte[] pubKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ASN1Sequence primitive = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])pubKey);
        Enumeration e = primitive.getObjects();
        BigInteger modulus = ((ASN1Integer)e.nextElement()).getValue();
        BigInteger publicExponent = ((ASN1Integer)e.nextElement()).getValue();
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey pk = kf.generatePublic(spec);
        return pk;
    }

    public static X509Certificate getX509Certificate(String certificate) throws CertificateException, UnsupportedEncodingException {
        InputStream certificateStream = IOUtils.toInputStream((String)certificate, (Charset)StandardCharsets.UTF_8);
        return KeyUtil.getX509Certificate(certificateStream);
    }

    public static X509Certificate getX509Certificate(Path certificate) throws IOException, CertificateException {
        InputStream certificatePathStream = Files.newInputStream(certificate, new OpenOption[0]);
        return KeyUtil.getX509Certificate(certificatePathStream);
    }

    public static X509Certificate getX509Certificate(InputStream certificate) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(certificate);
    }

    public static Certificate getCertificate(String certificate) throws CertificateException {
        InputStream certificateStream = IOUtils.toInputStream((String)certificate, (Charset)StandardCharsets.UTF_8);
        return KeyUtil.getCertificate(certificateStream);
    }

    public static Certificate getCertificate(Path certificate) throws IOException, CertificateException {
        InputStream certificatePathStream = Files.newInputStream(certificate, new OpenOption[0]);
        return KeyUtil.getX509Certificate(certificatePathStream);
    }

    public static Certificate getCertificate(InputStream certificate) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(certificate);
    }

    public static X509Certificate generateCertificateFromKeyPair(KeyPair keyPair, String account, String signatureAlgorithm, String dn) {
        return KeyUtil.generateCertificateFromKeyPair(keyPair, account, signatureAlgorithm, dn, null, null);
    }

    public static X509Certificate generateCertificateFromKeyPair(KeyPair keyPair, String account, String signatureAlgorithm, String dn, Date startDate, Date expiryDate) {
        try {
            BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
            if (startDate == null) {
                startDate = Date.from(Instant.now());
            }
            if (expiryDate == null) {
                expiryDate = Date.from(Instant.now().plusSeconds(31536000L));
            }
            X500Name issuer = new X500Name("O=JOC,OU=Self Signed");
            X500Name subject = null;
            subject = dn != null && !dn.isEmpty() ? new X500Name(dn) : new X500Name("CN=" + account + ",O=SOS self signed,OU=JOC");
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serialNumber, startDate, expiryDate, subject, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
            JcaContentSignerBuilder builder = new JcaContentSignerBuilder(signatureAlgorithm);
            ContentSigner signer = builder.build(keyPair.getPrivate());
            byte[] certBytes = certBuilder.build(signer).getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    private static byte[] integerToOctetByteArray(BigInteger i, int octets) {
        if (i.bitLength() > octets * 8) {
            throw new IllegalArgumentException("i does not fit in " + octets + " octets");
        }
        byte[] is = i.toByteArray();
        if (is.length == octets) {
            return is;
        }
        byte[] ius = new byte[octets];
        if (is.length == octets + 1) {
            System.arraycopy(is, 1, ius, 0, octets);
        } else {
            System.arraycopy(is, 0, ius, octets - is.length, is.length);
        }
        return ius;
    }

    private static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("%02X", data[i]));
        }
        return sb.toString();
    }

    private static byte[] createRSAKeyID(PublicKey key) {
        MessageDigest sha1;
        BigInteger modulus = ((RSAPublicKey)key).getModulus();
        if (modulus.bitLength() % 8 != 0) {
            throw new IllegalArgumentException("This method currently only works with RSA key sizes that are a multiple of 8 in bits");
        }
        byte[] modulusData = KeyUtil.integerToOctetByteArray(modulus, modulus.bitLength() / 8);
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 message digest should be available in any Java SE runtime", e);
        }
        return sha1.digest(modulusData);
    }

    public static String formatPrivateKey(byte[] key) {
        String base64Key = DatatypeConverter.printBase64Binary((byte[])key);
        return String.join((CharSequence)"\n", "-----BEGIN PRIVATE KEY-----", KeyUtil.insertLineFeedsInEncodedString(base64Key), "-----END PRIVATE KEY-----");
    }

    public static String formatPrivateKey(String key) {
        return String.join((CharSequence)"\n", "-----BEGIN PRIVATE KEY-----", KeyUtil.insertLineFeedsInEncodedString(key), "-----END PRIVATE KEY-----");
    }

    public static String formatPrivateRSAKey(byte[] key) {
        String base64Key = DatatypeConverter.printBase64Binary((byte[])key);
        return String.join((CharSequence)"\n", "-----BEGIN RSA PRIVATE KEY-----", KeyUtil.insertLineFeedsInEncodedString(base64Key), "-----END RSA PRIVATE KEY-----");
    }

    public static String formatPrivateRSAKey(String key) {
        return String.join((CharSequence)"\n", "-----BEGIN RSA PRIVATE KEY-----", KeyUtil.insertLineFeedsInEncodedString(key), "-----END RSA PRIVATE KEY-----");
    }

    public static String formatPrivateECDSAKey(byte[] key) {
        String base64Key = DatatypeConverter.printBase64Binary((byte[])key);
        return String.join((CharSequence)"\n", "-----BEGIN EC PRIVATE KEY-----", KeyUtil.insertLineFeedsInEncodedString(base64Key), "-----END EC PRIVATE KEY-----");
    }

    public static String formatPrivateECDSAKey(String key) {
        return String.join((CharSequence)"\n", "-----BEGIN EC PRIVATE KEY-----", KeyUtil.insertLineFeedsInEncodedString(key), "-----END EC PRIVATE KEY-----");
    }

    public static String formatPublicRSAKey(byte[] key) {
        String base64Key = DatatypeConverter.printBase64Binary((byte[])key);
        return String.join((CharSequence)"\n", "-----BEGIN RSA PUBLIC KEY-----", KeyUtil.insertLineFeedsInEncodedString(base64Key), "-----END RSA PUBLIC KEY-----");
    }

    public static String formatPublicRSAKey(String key) {
        return String.join((CharSequence)"\n", "-----BEGIN RSA PUBLIC KEY-----", KeyUtil.insertLineFeedsInEncodedString(key), "-----END RSA PUBLIC KEY-----");
    }

    public static String formatPublicECDSAKey(byte[] key) {
        String base64Key = DatatypeConverter.printBase64Binary((byte[])key);
        return String.join((CharSequence)"\n", "-----BEGIN EC PUBLIC KEY-----", KeyUtil.insertLineFeedsInEncodedString(base64Key), "-----END EC PUBLIC KEY-----");
    }

    public static String formatPublicECDSAKey(String key) {
        return String.join((CharSequence)"\n", "-----BEGIN EC PUBLIC KEY-----", KeyUtil.insertLineFeedsInEncodedString(key), "-----END EC PUBLIC KEY-----");
    }

    public static String formatPublicKey(byte[] key) {
        String base64Key = DatatypeConverter.printBase64Binary((byte[])key);
        return String.join((CharSequence)"\n", "-----BEGIN PUBLIC KEY-----", KeyUtil.insertLineFeedsInEncodedString(base64Key), "-----END PUBLIC KEY-----");
    }

    public static String formatPublicKey(String key) {
        return String.join((CharSequence)"\n", "-----BEGIN PUBLIC KEY-----", KeyUtil.insertLineFeedsInEncodedString(key), "-----END PUBLIC KEY-----");
    }

    public static String stripFormatFromPrivateECDSAKey(String key) {
        return key.replace("-----BEGIN EC PRIVATE KEY-----", "").replace("-----END EC PRIVATE KEY-----", "").replaceAll("\n", "");
    }

    public static String stripFormatFromPrivateRSAKey(String key) {
        return key.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replaceAll("\n", "");
    }

    public static String stripFormatFromPrivateKey(String key) {
        return key.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\n", "");
    }

    public static String stripFormatFromPublicRSAKey(String key) {
        return key.replace("-----BEGIN RSA PUBLIC KEY-----", "").replace("-----END RSA PUBLIC KEY-----", "").replaceAll("\n", "");
    }

    public static String stripFormatFromPublicECDSAKey(String key) {
        return key.replace("-----BEGIN EC PUBLIC KEY-----", "").replace("-----END EC PUBLIC KEY-----", "").replaceAll("\n", "");
    }

    public static String stripFormatFromPublicKey(String key) {
        return key.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\n", "");
    }

    public static String formatEncodedDataString(String data, String header, String footer) {
        return String.join((CharSequence)"\n", header, KeyUtil.insertLineFeedsInEncodedString(data), footer);
    }

    public static String insertLineFeedsInEncodedString(String key) {
        return key.replaceAll("(.{64})", "$1\n").trim();
    }

    public static PGPSecretKey readSecretKey(InputStream input) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator keyRingIter = pgpSec.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIter.next();
            Iterator keyIter = keyRing.getSecretKeys();
            while (keyIter.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)keyIter.next();
                if (!key.isSigningKey()) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }

    public static PrivateKey getPrivateKey(String privateKeyPath) throws SOSKeyException {
        if (privateKeyPath == null) {
            throw new SOSKeyException("the provided path to the private key file is null!");
        }
        return KeyUtil.getPrivateKey(Paths.get(privateKeyPath, new String[0]), null);
    }

    public static PrivateKey getPrivateKey(String privateKeyPath, String privateKeySecret) throws SOSKeyException {
        if (privateKeyPath == null) {
            throw new SOSKeyException("the provided path to the private key file is null!");
        }
        return KeyUtil.getPrivateKey(Paths.get(privateKeyPath, new String[0]), privateKeySecret);
    }

    public static PrivateKey getPrivateKey(Path privateKeyPath) throws SOSKeyException {
        if (privateKeyPath == null) {
            throw new SOSKeyException("the provided path to the private key file is null!");
        }
        return KeyUtil.getPrivateKey(privateKeyPath, null);
    }

    public static PrivateKey getPrivateKey(Path privateKeyPath, String privateKeySecret) throws SOSKeyException {
        if (privateKeyPath == null) {
            throw new SOSKeyException("the provided path to the private key file is null!");
        }
        PrivateKey privKey = null;
        try {
            if (privateKeyPath != null) {
                KeyUtil.isInputPrivateKey(Files.readString(privateKeyPath));
                privKey = privateKeySecret != null && !privateKeySecret.isEmpty() ? KeyUtil.getPrivateEncryptedKey(Files.readString(privateKeyPath), privateKeySecret) : KeyUtil.getPrivateKeyFromString(Files.readString(privateKeyPath));
            }
        }
        catch (Throwable e) {
            throw new SOSKeyException(e.toString(), e);
        }
        return privKey;
    }

    public static PrivateKey getPrivateKey(String keystorePath, String keystoreType, String keystorePwd, String keystoreKeyPwd, String keystoreAlias) throws SOSKeyException {
        PrivateKey privKey = null;
        try {
            if (keystorePath != null) {
                String alias;
                Enumeration<String> aliases;
                KeystoreType type = null;
                type = keystoreType == null ? KeystoreType.PKCS12 : KeystoreType.valueOf(keystoreType);
                KeyStore keystore = KeyStoreUtil.readKeyStore(keystorePath, type, keystorePwd);
                if (keystoreAlias == null && (aliases = keystore.aliases()).hasMoreElements() && keystore.isKeyEntry(alias = aliases.nextElement())) {
                    keystoreAlias = alias;
                    LOGGER.debug(String.format("no key alias configured, use first found alias <%1$s> to retrieve key.", keystoreAlias));
                }
                privKey = keystoreKeyPwd != null ? (PrivateKey)keystore.getKey(keystoreAlias, keystoreKeyPwd.toCharArray()) : (PrivateKey)keystore.getKey(keystoreAlias, "".toCharArray());
            }
        }
        catch (Throwable e) {
            throw new SOSKeyException(e.toString(), e);
        }
        return privKey;
    }

    public static void isInputCertOrPublicKey(String cert) throws SOSKeyException {
        Pattern pattern = Pattern.compile("-----BEGIN (CERTIFICATE|.*PUBLIC KEY)-----(.*)-----END \\1-----", 32);
        Matcher matcher = pattern.matcher(cert);
        if (matcher.find()) {
            if (matcher.find()) {
                throw new SOSKeyException("Certificate or key bundles are not allowed, only a single certificate or public key is required.");
            }
        } else {
            throw new SOSKeyException("The value is neither a X509 certificate nor a public key.");
        }
    }

    public static void isInputPrivateKey(String key) throws SOSKeyException {
        Pattern pattern = Pattern.compile("-----BEGIN (.*PRIVATE KEY)-----(.*)-----END \\1-----", 32);
        Matcher matcher = pattern.matcher(key);
        if (matcher.find()) {
            if (matcher.find()) {
                throw new SOSKeyException("Key bundles are not allowed, only a single private key are required.");
            }
        } else {
            throw new SOSKeyException("The value is not a private key.");
        }
    }
}

