/*
 * Decompiled with CFR 0.152.
 */
package sos.net.mail.options;

import com.sos.JSHelper.Annotations.JSOptionClass;
import com.sos.JSHelper.Exceptions.JSExceptionMandatoryOptionMissing;
import com.sos.JSHelper.Listener.JSListener;
import com.sos.JSHelper.interfaces.ISOSSmtpMailOptions;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.mail.options.SOSSmtpMailOptionsSuperClass;

@JSOptionClass(name="SOSSmtpMailOptions", description="Launch and observe any given job or job chain")
public class SOSSmtpMailOptions
extends SOSSmtpMailOptionsSuperClass
implements ISOSSmtpMailOptions {
    private static final long serialVersionUID = 6441074884525254517L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSmtpMailOptions.class);
    @JSOptionClass(description="", name="SOSSmtpMailOptions")
    private SOSSmtpMailOptions objMailOnError = null;
    @JSOptionClass(description="", name="SOSSmtpMailOptions")
    private SOSSmtpMailOptions objMailOnSuccess = null;
    @JSOptionClass(description="", name="SOSSmtpMailOptions")
    private SOSSmtpMailOptions objMailOnEmptyFiles = null;
    private String strAlternativePrefix = "";

    public SOSSmtpMailOptions() {
    }

    public SOSSmtpMailOptions(JSListener pobjListener) {
        this();
        this.registerMessageListener(pobjListener);
    }

    public SOSSmtpMailOptions getOptions(enuMailClasses penuMailClass) {
        SOSSmtpMailOptions objO = this.objMailOnError;
        switch (penuMailClass) {
            case MailOnError: {
                break;
            }
            case MailOnEmptyFiles: {
                objO = this.objMailOnEmptyFiles;
                break;
            }
            case MailOnSuccess: {
                objO = this.objMailOnSuccess;
                break;
            }
            default: {
                objO = this;
            }
        }
        return objO;
    }

    public SOSSmtpMailOptions(HashMap<String, String> settings) throws Exception {
        super(settings);
        this.initChildOptions();
        this.setPrefixedValues(settings);
    }

    private void initChildOptions() {
        if (this.objMailOnError == null) {
            this.objMailOnError = new SOSSmtpMailOptions();
            this.objMailOnSuccess = new SOSSmtpMailOptions();
            this.objMailOnEmptyFiles = new SOSSmtpMailOptions();
        }
    }

    public void setPrefixedValues(HashMap<String, String> settings) throws Exception {
        this.objMailOnError.setAllOptions(settings, "MailOnError_");
        this.objMailOnSuccess.setAllOptions(settings, "MailOnSuccess_");
        this.objMailOnEmptyFiles.setAllOptions(settings, "MailOnEmptyFiles_");
    }

    public SOSSmtpMailOptions(HashMap<String, String> JSSettings, String pstrPrefix) throws Exception {
        this.strAlternativePrefix = pstrPrefix;
        this.setAllOptions(JSSettings, this.strAlternativePrefix);
        LOGGER.trace(this.dirtyString());
    }

    @Override
    public void checkMandatory() {
        try {
            super.checkMandatory();
        }
        catch (Exception e) {
            throw new JSExceptionMandatoryOptionMissing(e.toString());
        }
    }

    public static enum enuMailClasses {
        MailDefault,
        MailOnError,
        MailOnSuccess,
        MailOnEmptyFiles;

    }
}

