/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checklicense.classes;

import com.sos.jitl.jobs.checklicense.CheckLicenseJobArguments;
import com.sos.jitl.jobs.checklicense.classes.CheckLicenseWebserviceExecuter;
import com.sos.joc.model.joc.Js7LicenseInfo;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.util.Date;
import java.util.Map;

public class CheckLicense {
    private OrderProcessStepLogger logger;
    private CheckLicenseJobArguments args;
    private int exit;
    private String body;
    private String subject;
    private Map<String, DetailValue> jobResources;

    public CheckLicense(OrderProcessStep<CheckLicenseJobArguments> step) {
        this.args = (CheckLicenseJobArguments)step.getDeclaredArguments();
        this.jobResources = step.getJobResourcesArgumentsAsNameDetailValueMap();
        this.logger = step.getLogger();
    }

    private void log(String s) {
        this.logger.info((Object)s);
        this.body = this.body + s + "\r\n";
    }

    public void execute() throws Exception {
        ApiExecutor apiExecutor = new ApiExecutor(this.logger);
        apiExecutor.setJobResources(this.jobResources);
        String accessToken = null;
        this.exit = 0;
        this.body = "";
        this.subject = "";
        try {
            ApiResponse apiResponse = apiExecutor.login();
            accessToken = apiResponse.getAccessToken();
            CheckLicenseWebserviceExecuter checkLicenceWebserviceExecuter = new CheckLicenseWebserviceExecuter(this.logger, apiExecutor);
            Js7LicenseInfo js7LicenseInfo = checkLicenceWebserviceExecuter.getLicence(accessToken);
            this.log(".. Check License for validity period of " + this.args.getValidityDays().shortValue() + " days");
            this.log(".. Licence tpye: " + js7LicenseInfo.getType());
            if (js7LicenseInfo.getValid() != null && js7LicenseInfo.getValid().booleanValue()) {
                this.subject = "JS7 JobScheduler License Check: " + js7LicenseInfo.getType();
                this.log(".. License valid: " + js7LicenseInfo.getValid());
                if (js7LicenseInfo.getValidFrom() != null && js7LicenseInfo.getValidUntil() != null) {
                    Date now = new Date();
                    this.log(".. License valid from: " + js7LicenseInfo.getValidFrom());
                    this.log(".. License valid to: " + js7LicenseInfo.getValidUntil());
                    if (js7LicenseInfo.getValidUntil().before(now)) {
                        this.log("License Check failed: license expired on " + js7LicenseInfo.getValidUntil());
                        this.subject = "JS7 JobScheduler Notification: license expired";
                        this.exit = 2;
                    }
                    long timeUntilExpiration = (js7LicenseInfo.getValidUntil().getTime() - now.getTime()) / 86400000L;
                    long daysMs = this.args.getValidityDays().intValue();
                    this.logger.debug((Object)("now: " + now.getTime()));
                    this.logger.debug((Object)("daysMs: " + daysMs));
                    this.logger.debug((Object)("timeUntilExpiration: " + timeUntilExpiration));
                    if (timeUntilExpiration < daysMs) {
                        this.log("License Check warning: license will expire on " + js7LicenseInfo.getValidUntil());
                        this.subject = "JS7 JobScheduler Notification: license expiration warning";
                        this.exit = 3;
                    }
                }
            } else {
                this.log(".. License valid not applicable");
                this.log("License Check failed: license check not applicable for open source license");
                this.subject = "JS7 JobScheduler License Check failed";
                this.exit = 2;
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            this.exit = 4;
            throw e;
        }
        finally {
            if (accessToken != null) {
                apiExecutor.logout(accessToken);
            }
            apiExecutor.close();
        }
    }

    public int getExit() {
        return this.exit;
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }
}

