/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.common;

import com.sos.commons.hibernate.SOSHibernateSQLExecutor;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPath;
import com.sos.js7.job.OrderProcessStepLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.time.Instant;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;

public class Export2CSV {
    public static void export(ResultSet resultSet, Path outputFile, OrderProcessStepLogger logger) throws Exception {
        Export2CSV.export(resultSet, outputFile, null, logger);
    }

    public static void export(ResultSet resultSet, Path outputFile, CSVFormat.Builder builder, OrderProcessStepLogger logger) throws Exception {
        if (resultSet == null) {
            throw new Exception("missing ResultSet");
        }
        if (outputFile == null) {
            throw new Exception("missing outputFile");
        }
        if (builder == null) {
            builder = Export2CSV.defaultBuilder();
        }
        File file = SOSPath.toFile((Path)outputFile);
        OutputStreamWriter writer = null;
        CSVPrinter printer = null;
        boolean removeOutputFile = false;
        try {
            Instant start = Instant.now();
            int headerRows = 0;
            int dataRows = 0;
            writer = new FileWriter(file);
            printer = new CSVPrinter((Appendable)writer, builder.build());
            printer.printHeaders(resultSet);
            ++headerRows;
            int columnCount = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                int count;
                for (int i = 1; i <= columnCount; ++i) {
                    printer.print((Object)SOSHibernateSQLExecutor.sqlValueToString((Object)resultSet.getObject(i)));
                }
                printer.println();
                if (logger == null || (count = ++dataRows + headerRows) % 1000 != 0) continue;
                logger.info("[export]%s entries processed ...", new Object[]{count});
            }
            if (logger != null) {
                logger.info("[export][%s]total rows written=%s (header=%s, data=%s), duration=%s", new Object[]{file, headerRows + dataRows, headerRows, dataRows, SOSDate.getDuration((Instant)start, (Instant)Instant.now())});
            }
        }
        catch (Throwable e) {
            removeOutputFile = true;
            String f = file.toString();
            try {
                f = file.getCanonicalPath();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new Exception(String.format("[%s]%s", f, e.toString()), e);
        }
        finally {
            if (printer != null) {
                try {
                    printer.flush();
                }
                catch (Exception start) {}
                try {
                    printer.close();
                }
                catch (Exception start) {}
            }
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (Exception start) {}
                try {
                    writer.close();
                }
                catch (Exception start) {}
            }
            if (removeOutputFile) {
                try {
                    if (file.exists()) {
                        file.deleteOnExit();
                    }
                }
                catch (Exception start) {}
            }
        }
    }

    public static CSVFormat.Builder defaultBuilder() {
        CSVFormat.Builder builder = CSVFormat.DEFAULT.builder();
        builder.setDelimiter(",");
        builder.setQuoteMode(QuoteMode.ALL);
        builder.setQuote("\"".charAt(0));
        builder.setEscape('\\');
        builder.setRecordSeparator("\r\n");
        builder.setIgnoreEmptyLines(false);
        builder.setNullString("");
        builder.setCommentMarker('#');
        return builder;
    }
}

