/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.common;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sos.commons.hibernate.SOSHibernateSQLExecutor;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPath;
import com.sos.js7.job.OrderProcessStepLogger;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.time.Instant;

public class Export2JSON {
    public static void export(ResultSet resultSet, Path outputFile, OrderProcessStepLogger logger) throws Exception {
        if (resultSet == null) {
            throw new Exception("missing ResultSet");
        }
        if (outputFile == null) {
            throw new Exception("missing outputFile");
        }
        boolean removeOutputFile = false;
        ByteArrayOutputStream baos = null;
        JsonGenerator gen = null;
        try {
            Instant start = Instant.now();
            int dataRows = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            String[] columnLabels = SOSHibernateSQLExecutor.getColumnLabels((ResultSet)resultSet);
            baos = new ByteArrayOutputStream();
            gen = new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8);
            gen.useDefaultPrettyPrinter();
            gen.writeStartArray();
            while (resultSet.next()) {
                int count;
                gen.writeStartObject();
                for (int i = 1; i <= columnCount; ++i) {
                    Object o = resultSet.getObject(i);
                    String label = columnLabels[i - 1];
                    if (o == null) {
                        gen.writeStringField(label, null);
                        continue;
                    }
                    if (o instanceof Number) {
                        if (o instanceof BigDecimal) {
                            gen.writeNumberField(label, (BigDecimal)o);
                            continue;
                        }
                        if (o instanceof BigInteger) {
                            gen.writeNumberField(label, (BigInteger)o);
                            continue;
                        }
                        if (o instanceof Integer) {
                            gen.writeNumberField(label, ((Integer)o).intValue());
                            continue;
                        }
                        if (o instanceof Long) {
                            gen.writeNumberField(label, ((Long)o).longValue());
                            continue;
                        }
                        if (o instanceof Float) {
                            gen.writeNumberField(label, ((Float)o).floatValue());
                            continue;
                        }
                        if (o instanceof Short) {
                            gen.writeNumberField(label, ((Short)o).shortValue());
                            continue;
                        }
                        gen.writeStringField(label, o.toString());
                        continue;
                    }
                    if (o instanceof Boolean) {
                        gen.writeBooleanField(label, ((Boolean)o).booleanValue());
                        continue;
                    }
                    gen.writeStringField(label, SOSHibernateSQLExecutor.sqlValueToString((Object)o));
                }
                gen.writeEndObject();
                if (logger == null || (count = ++dataRows) % 1000 != 0) continue;
                logger.info("[export]%s entries processed ...", new Object[]{count});
            }
            gen.writeEndArray();
            gen.close();
            gen = null;
            if (logger != null) {
                logger.info("[export][%s]total data rows written=%s, duration=%s", new Object[]{outputFile, dataRows, SOSDate.getDuration((Instant)start, (Instant)Instant.now())});
            }
            try (FileOutputStream os = new FileOutputStream(outputFile.toFile());){
                baos.writeTo(os);
            }
        }
        catch (Throwable e) {
            removeOutputFile = true;
            String f = outputFile.toString();
            try {
                f = outputFile.toAbsolutePath().toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new Exception(String.format("[%s]%s", f, e.toString()), e);
        }
        finally {
            if (gen != null) {
                try {
                    gen.close();
                }
                catch (Throwable start) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Throwable start) {}
            }
            if (removeOutputFile) {
                try {
                    SOSPath.deleteIfExists((Path)outputFile);
                }
                catch (Exception start) {}
            }
        }
    }
}

