/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.encrypt;

import com.sos.commons.encryption.executable.Encrypt;
import com.sos.commons.exception.SOSException;
import com.sos.commons.sign.keys.key.KeyUtil;
import com.sos.jitl.jobs.encrypt.EncryptJobArguments;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class EncryptExecuter {
    private OrderProcessStepLogger logger;
    private EncryptJobArguments args;
    OrderProcessStep<EncryptJobArguments> step;

    public EncryptExecuter(OrderProcessStep<EncryptJobArguments> step) {
        this.args = (EncryptJobArguments)step.getDeclaredArguments();
        this.logger = step.getLogger();
        this.step = step;
    }

    public String execute() throws CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, SOSException {
        X509Certificate cert = null;
        PublicKey pubKey = null;
        String encryptedValue = "";
        String enciphermentCertificate = this.args.getEnciphermentCertificate();
        if (enciphermentCertificate.contains("CERTIFICATE")) {
            cert = KeyUtil.getX509Certificate((String)enciphermentCertificate);
        } else {
            try {
                pubKey = KeyUtil.getRSAPublicKeyFromString((String)enciphermentCertificate);
            }
            catch (Exception e) {
                try {
                    pubKey = KeyUtil.getECDSAPublicKeyFromString((String)enciphermentCertificate);
                }
                catch (Exception e1) {
                    try {
                        pubKey = KeyUtil.convertToRSAPublicKey((byte[])KeyUtil.stripFormatFromPublicKey((String)enciphermentCertificate).getBytes());
                    }
                    catch (Exception e2) {
                        pubKey = KeyUtil.getECPublicKeyFromString((byte[])KeyUtil.stripFormatFromPublicKey((String)enciphermentCertificate).getBytes());
                    }
                }
            }
        }
        if (this.args.getInFile() != null && !this.args.getInFile().isEmpty() && this.args.getOutFile() != null && !this.args.getOutFile().isEmpty()) {
            encryptedValue = cert != null ? Encrypt.encryptFile((X509Certificate)cert, (Path)Paths.get(this.args.getInFile(), new String[0]), (Path)Paths.get(this.args.getOutFile(), new String[0])) : Encrypt.encryptFile((PublicKey)pubKey, (Path)Paths.get(this.args.getInFile(), new String[0]), (Path)Paths.get(this.args.getOutFile(), new String[0]));
        } else {
            String input = this.args.getIn();
            if (input != null) {
                encryptedValue = cert != null ? Encrypt.encrypt((X509Certificate)cert, (String)input) : Encrypt.encrypt((PublicKey)pubKey, (String)input);
            }
        }
        return encryptedValue;
    }
}

