/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.examples;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.vfs.ssh.SSHProvider;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import com.sos.jitl.jobs.ssh.SSHJobArguments;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import java.util.List;

public class SSHJob
extends Job<SSHJobArguments> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processOrder(OrderProcessStep<SSHJobArguments> step) throws Exception {
        SSHProviderArguments providerArgs = (SSHProviderArguments)step.getIncludedArguments(SSHProviderArguments.class);
        SSHProvider provider = new SSHProvider(providerArgs, (CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class));
        step.addCancelableResource(provider);
        try {
            step.getLogger().info("[connect]%s:%s ...", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue()});
            provider.connect();
            step.getLogger().info("[connected][%s:%s]%s", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue(), provider.getServerInfo().toString()});
            if (!((SSHJobArguments)step.getDeclaredArguments()).getCommand().isEmpty()) {
                this.executeCommand(provider, step);
            }
            Integer testExitCode = 0;
            if (((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue() != null) {
                step.getLogger().info((Object)("[getExitCodesToIgnore.size=]" + ((List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()).size()));
                for (Object o : (List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()) {
                    step.getLogger().info((Object)("[getExitCodesToIgnore]" + o.getClass() + "=" + o));
                }
                step.getLogger().info((Object)("[getExitCodesToIgnore.contains(" + testExitCode + ")]" + ((List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()).contains(testExitCode)));
            }
            if (provider == null) return;
        }
        catch (Throwable e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (provider == null) throw throwable;
                provider.disconnect();
                step.getLogger().info("[disconnected]%s:%s", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue()});
                throw throwable;
            }
        }
        provider.disconnect();
        step.getLogger().info("[disconnected]%s:%s", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue()});
        return;
    }

    private void executeCommand(SSHProvider provider, OrderProcessStep<SSHJobArguments> step) {
        step.getLogger().info("[execute command]%s", new Object[]{((SSHJobArguments)step.getDeclaredArguments()).getCommand().getDisplayValue()});
        SOSCommandResult r = provider.executeCommand((String)((SSHJobArguments)step.getDeclaredArguments()).getCommand().getValue());
        step.getLogger().info("[exitCode]%s", new Object[]{r.getExitCode()});
        if (!SOSString.isEmpty((String)r.getStdOut())) {
            step.getLogger().info("[stdOut]%s", new Object[]{r.getStdOut()});
        }
        if (!SOSString.isEmpty((String)r.getStdErr())) {
            step.getLogger().info("[stdErr]%s", new Object[]{r.getStdErr()});
        }
        if (r.getException() != null) {
            step.getLogger().info("[exception]%s", new Object[]{r.getException()});
        }
    }
}

