/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.mail;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.mail.SOSMailReceiver;
import com.sos.commons.util.common.ASOSArguments;
import com.sos.commons.util.common.SOSArgumentHelper;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import java.util.Collections;
import java.util.List;

public class MailInboxArguments
extends JobArguments {
    private JobArgument<String> mailImapHost = new JobArgument("mail.imap.host", false);
    private JobArgument<Integer> mailImapPort = new JobArgument("mail.imap.port", false);
    private JobArgument<String> mailImapUser = new JobArgument("mail.imap.user", false);
    private JobArgument<String> mailImapPassword = new JobArgument("mail.imap.password", false, (Object)"", SOSArgumentHelper.DisplayMode.MASKED);
    private JobArgument<Boolean> mailImapSSL = new JobArgument("mail.imap.ssl.enable", false, (Object)false);
    private JobArgument<String> mailPop3Host = new JobArgument("mail.pop3.host", false);
    private JobArgument<Integer> mailPop3Port = new JobArgument("mail.pop3.port", false);
    private JobArgument<String> mailPop3User = new JobArgument("mail.pop3.user", false);
    private JobArgument<String> mailPop3Password = new JobArgument("mail.pop3.password", false, (Object)"", SOSArgumentHelper.DisplayMode.MASKED);
    private JobArgument<Boolean> mailPop3SSL = new JobArgument("mail.pop3.ssl.enable", false, (Object)false);
    private JobArgument<SOSMailReceiver.Protocol> mailStoreProtocol = new JobArgument("mail.store.protocol", true);
    private JobArgument<List<String>> mailMessageFolder = new JobArgument("mail_source_folders", false, Collections.singletonList("INBOX"), SOSArgumentHelper.DisplayMode.UNMASKED);
    private JobArgument<Integer> maxMailsToProcess = new JobArgument("max_processed_mails", false, (Object)1000);
    private JobArgument<String> minMailAge = new JobArgument("min_mail_age", false, (Object)"0");
    private JobArgument<String> mailBodyPattern = new JobArgument("mail_body_pattern", false, (Object)"");
    private JobArgument<String> mailSubjectFilter = new JobArgument("mail_subject_filter", false, (Object)"");
    private JobArgument<String> mailSubjectPattern = new JobArgument("mail_subject_pattern", false, (Object)"");
    private JobArgument<String> mailFromFilter = new JobArgument("mail_from_filter", false, (Object)"");
    private JobArgument<List<ActionProcess>> mailAction = new JobArgument("mail_action", false, Collections.singletonList(ActionProcess.none));
    private JobArgument<ActionAfterProcess> afterProcessMail = new JobArgument("mail_post_action", false, (Object)ActionAfterProcess.none);
    private JobArgument<String> afterProcessMailDirectoryName = new JobArgument("mail_target_folder", false, (Object)"");
    private JobArgument<String> attachmentDirectoryName = new JobArgument("mail_attachments_directory", false, (Object)"");
    private JobArgument<Boolean> saveBodyAsAttachment = new JobArgument("body_as_attachment", false, (Object)false);
    private JobArgument<Boolean> mailOnlyUnseen = new JobArgument("only_unread_mails", false, (Object)true);
    private JobArgument<String> attachmentFileNamePattern = new JobArgument("attachment_file_name_pattern", false, (Object)"");
    private JobArgument<String> mailDirectoryName = new JobArgument("mail_file_directory", false, (Object)"");

    public MailInboxArguments() {
        super(new ASOSArguments[]{new CredentialStoreArguments()});
    }

    public List<JobArgument<?>> createRequiredMailArguments(SOSMailReceiver.Protocol protocol) {
        switch (protocol) {
            case imap: {
                return this.createRequiredIMAPArguments();
            }
            case pop3: {
                return this.createRequiredPOP3Arguments();
            }
        }
        return Collections.emptyList();
    }

    public List<JobArgument<?>> createRequiredMailArguments() {
        return this.createRequiredMailArguments((SOSMailReceiver.Protocol)this.mailStoreProtocol.getValue());
    }

    public void setDefaultMailPort(SOSMailReceiver.Protocol protocol) {
        switch (protocol) {
            case imap: {
                if (Boolean.TRUE != this.mailImapSSL.getValue()) break;
                this.mailImapPort.setDefaultValue((Object)993);
                break;
            }
            case pop3: {
                if (Boolean.TRUE != this.mailPop3SSL.getValue()) break;
                this.mailPop3Port.setDefaultValue((Object)995);
            }
        }
    }

    public void setDefaultMailPort() {
        switch ((SOSMailReceiver.Protocol)this.mailStoreProtocol.getValue()) {
            case imap: {
                if (Boolean.TRUE == this.mailImapSSL.getValue()) {
                    this.mailImapPort.setDefaultValue((Object)993);
                    break;
                }
                this.mailImapPort.setDefaultValue((Object)143);
                break;
            }
            case pop3: {
                if (Boolean.TRUE == this.mailPop3SSL.getValue()) {
                    this.mailPop3Port.setDefaultValue((Object)995);
                    break;
                }
                this.mailPop3Port.setDefaultValue((Object)110);
            }
        }
    }

    private List<JobArgument<?>> createRequiredIMAPArguments() {
        this.mailImapHost.setRequired(true);
        return Collections.singletonList(this.mailImapHost);
    }

    private List<JobArgument<?>> createRequiredPOP3Arguments() {
        this.mailPop3Host.setRequired(true);
        return Collections.singletonList(this.mailPop3Host);
    }

    public JobArgument<String> getMailHost() {
        if (((SOSMailReceiver.Protocol)this.mailStoreProtocol.getValue()).equals((Object)SOSMailReceiver.Protocol.imap)) {
            return this.mailImapHost;
        }
        return this.mailPop3Host;
    }

    public JobArgument<Integer> getMailPort() {
        if (((SOSMailReceiver.Protocol)this.mailStoreProtocol.getValue()).equals((Object)SOSMailReceiver.Protocol.imap)) {
            return this.mailImapPort;
        }
        return this.mailPop3Port;
    }

    public JobArgument<String> getMailUser() {
        if (((SOSMailReceiver.Protocol)this.mailStoreProtocol.getValue()).equals((Object)SOSMailReceiver.Protocol.imap)) {
            return this.mailImapUser;
        }
        return this.mailPop3User;
    }

    public JobArgument<Boolean> getMailSSL() {
        if (((SOSMailReceiver.Protocol)this.mailStoreProtocol.getValue()).equals((Object)SOSMailReceiver.Protocol.imap)) {
            return this.mailImapSSL;
        }
        return this.mailPop3SSL;
    }

    public JobArgument<SOSMailReceiver.Protocol> getMailProtocol() {
        return this.mailStoreProtocol;
    }

    public JobArgument<String> getMailPassword() {
        if (((SOSMailReceiver.Protocol)this.mailStoreProtocol.getValue()).equals((Object)SOSMailReceiver.Protocol.imap)) {
            return this.mailImapPassword;
        }
        return this.mailPop3Password;
    }

    public JobArgument<Integer> getMaxMailsToProcess() {
        return this.maxMailsToProcess;
    }

    public JobArgument<List<ActionProcess>> getAction() {
        return this.mailAction;
    }

    public JobArgument<ActionAfterProcess> getAfterProcessMail() {
        return this.afterProcessMail;
    }

    public JobArgument<String> getAfterProcessMailDirectoryName() {
        return this.afterProcessMailDirectoryName;
    }

    public JobArgument<String> getAttachmentDirectoryName() {
        return this.attachmentDirectoryName;
    }

    public JobArgument<Boolean> getSaveBodyAsAttachment() {
        return this.saveBodyAsAttachment;
    }

    public JobArgument<Boolean> getMailOnlyUnseen() {
        return this.mailOnlyUnseen;
    }

    public JobArgument<String> getMailBodyPattern() {
        return this.mailBodyPattern;
    }

    public JobArgument<String> getMailSubjectFilter() {
        return this.mailSubjectFilter;
    }

    public JobArgument<String> getMailSubjectPattern() {
        return this.mailSubjectPattern;
    }

    public JobArgument<String> getMailFromFilter() {
        return this.mailFromFilter;
    }

    public JobArgument<String> getAttachmentFileNamePattern() {
        return this.attachmentFileNamePattern;
    }

    public JobArgument<String> getMailDirectoryName() {
        return this.mailDirectoryName;
    }

    public JobArgument<List<String>> getMailMessageFolder() {
        return this.mailMessageFolder;
    }

    public JobArgument<String> getMinMailAge() {
        return this.minMailAge;
    }

    public static enum ActionProcess {
        none,
        dump,
        dumpAttachments,
        dump_attachments;

    }

    public static enum ActionAfterProcess {
        none,
        move,
        copy,
        delete,
        markAsRead,
        mark_as_read;

    }
}

