/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.monitoring;

import com.sos.commons.exception.SOSException;
import com.sos.jitl.jobs.monitoring.MonitoringJobArguments;
import com.sos.jitl.jobs.monitoring.classes.MonitoringCheckReturn;
import com.sos.jitl.jobs.monitoring.classes.MonitoringChecker;
import com.sos.jitl.jobs.monitoring.classes.MonitoringParameters;
import com.sos.jitl.jobs.monitoring.classes.MonitoringWebserviceExecuter;
import com.sos.jitl.jobs.sap.common.Globals;
import com.sos.joc.model.agent.AgentV;
import com.sos.joc.model.jitl.monitoring.MonitoringControllerStatus;
import com.sos.joc.model.jitl.monitoring.MonitoringJocStatus;
import com.sos.joc.model.jitl.monitoring.MonitoringStatus;
import com.sos.joc.model.order.OrdersHistoricSummary;
import com.sos.joc.model.order.OrdersSummary;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExecuteMonitoring {
    private MonitoringJobArguments args;
    private Map<String, DetailValue> jobResources;
    private OrderProcessStepLogger logger;

    public ExecuteMonitoring(OrderProcessStep<MonitoringJobArguments> step) {
        this.args = (MonitoringJobArguments)step.getDeclaredArguments();
        this.jobResources = step.getJobResourcesArgumentsAsNameDetailValueMap();
        this.logger = step.getLogger();
    }

    public MonitoringStatus getStatusInformations() throws Exception {
        ApiExecutor apiExecutor = new ApiExecutor(this.logger);
        apiExecutor.setJobResources(this.jobResources);
        String accessToken = null;
        try {
            ApiResponse apiResponse = apiExecutor.login();
            accessToken = apiResponse.getAccessToken();
            MonitoringWebserviceExecuter monitoringWebserviceExecuter = new MonitoringWebserviceExecuter(this.logger, apiExecutor);
            MonitoringControllerStatus monitoringControllerStatus = monitoringWebserviceExecuter.getControllerStatus(accessToken, this.args.getControllerId());
            MonitoringJocStatus monitoringJocStatus = monitoringWebserviceExecuter.getJS7JOCInstance(accessToken, this.args.getControllerId());
            List<AgentV> agentStatus = monitoringWebserviceExecuter.getJS7AgentStatus(accessToken, this.args.getControllerId());
            OrdersSummary ordersSummary = monitoringWebserviceExecuter.getJS7OrderSnapshot(accessToken, this.args.getControllerId());
            OrdersHistoricSummary ordersHistoricSummary = monitoringWebserviceExecuter.getJS7OrderSummary(accessToken, this.args.getControllerId());
            MonitoringStatus monitoringStatus = new MonitoringStatus();
            monitoringStatus.setAgentStatus(agentStatus);
            monitoringStatus.setControllerStatus(monitoringControllerStatus);
            monitoringStatus.setFrom(this.args.getFrom());
            monitoringStatus.setJocStatus(monitoringJocStatus);
            monitoringStatus.setOrderSnapshot(ordersSummary);
            monitoringStatus.setOrderSummary(ordersHistoricSummary);
            MonitoringStatus monitoringStatus2 = monitoringStatus;
            return monitoringStatus2;
        }
        catch (Throwable e) {
            this.logger.error(e);
            throw e;
        }
        finally {
            if (accessToken != null) {
                apiExecutor.logout(accessToken);
            }
            apiExecutor.close();
        }
    }

    private List<Path> getSortedDirectory(String dir) throws IOException {
        try (Stream<Path> fileStream = Files.list(Paths.get(dir, new String[0]));){
            List<Path> list = fileStream.map(Path::toFile).sorted(Comparator.comparing(File::lastModified)).map(File::toPath).collect(Collectors.toList());
            return list;
        }
    }

    public MonitoringParameters result2File(MonitoringStatus monitoringStatus, MonitoringParameters monitoringParameters, Integer resultCount) throws IOException {
        Files.createDirectories(Paths.get(this.args.getMonitorReportDir(), new String[0]), new FileAttribute[0]);
        String filename = resultCount == 0 ? this.args.getMonitorReportDir() + "/monitor." + monitoringParameters.getMonitorFileReportDate() + ".notice.json" : this.args.getMonitorReportDir() + "/monitor." + monitoringParameters.getMonitorFileReportDate() + ".alert.json";
        monitoringParameters.setMonitorReportFile(filename);
        this.logger.debug((Object)("Report Filename: " + filename));
        String output = Globals.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)monitoringStatus);
        try (PrintWriter outWriter = new PrintWriter(filename);){
            this.logger.info((Object)output);
            outWriter.println(output);
        }
        catch (Throwable e) {
            this.logger.error(e);
        }
        long count = 0L;
        try (Stream<Path> files = Files.list(Paths.get(this.args.getMonitorReportDir(), new String[0]));){
            count = files.count();
        }
        if (count > this.args.getMonitorReportMaxFiles()) {
            List<Path> reportfiles = this.getSortedDirectory(this.args.getMonitorReportDir());
            int i = 0;
            while ((long)i < this.args.getMonitorReportMaxFiles() - 1L && count > this.args.getMonitorReportMaxFiles()) {
                Files.delete(reportfiles.get(i));
                --count;
                ++i;
            }
        }
        return monitoringParameters;
    }

    public MonitoringCheckReturn checkStatusInformation(MonitoringStatus monitoringStatus, MonitoringParameters monitoringParameters) throws SOSException {
        MonitoringChecker montitoringChecker = new MonitoringChecker(this.logger);
        return montitoringChecker.doCheck(monitoringStatus, monitoringParameters, this.args.getFrom());
    }
}

