/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.runreports.classes;

import com.sos.jitl.jobs.runreports.RunReportJobArguments;
import com.sos.jitl.jobs.runreports.classes.RunReportsWebserviceExecuter;
import com.sos.joc.model.common.Folder;
import com.sos.joc.model.reporting.Report;
import com.sos.joc.model.reporting.Reports;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RunReportImpl {
    private OrderProcessStepLogger logger;
    private RunReportJobArguments args;
    private Map<String, DetailValue> jobResources;

    public RunReportImpl(OrderProcessStep<RunReportJobArguments> step) {
        this.args = (RunReportJobArguments)step.getDeclaredArguments();
        this.jobResources = step.getJobResourcesArgumentsAsNameDetailValueMap();
        this.logger = step.getLogger();
    }

    public void execute() throws Exception {
        ApiExecutor apiExecutor = new ApiExecutor(this.logger);
        apiExecutor.setJobResources(this.jobResources);
        String accessToken = null;
        try {
            ApiResponse apiResponse = apiExecutor.login();
            accessToken = apiResponse.getAccessToken();
            RunReportsWebserviceExecuter runReportsWebserviceExecuter = new RunReportsWebserviceExecuter(this.logger, apiExecutor);
            HashSet<String> reportPaths = new HashSet<String>();
            if (this.logger.isDebugEnabled() && this.args.getReportPaths() != null && this.args.getReportPaths().getValue() != null) {
                for (String report : (List)this.args.getReportPaths().getValue()) {
                    this.logger.debug((Object)("Add report from reportPaths: " + report));
                }
            }
            if (this.args.getReportPaths().getValue() != null) {
                reportPaths.addAll((Collection)this.args.getReportPaths().getValue());
            }
            ArrayList<Folder> folders = new ArrayList<Folder>();
            if (!(this.args.getReportFolders().getValue() != null && ((List)this.args.getReportFolders().getValue()).size() != 0 || this.args.getReportPaths().getValue() != null && ((List)this.args.getReportPaths().getValue()).size() != 0)) {
                Folder folder = new Folder();
                folder.setFolder("/");
                folder.setRecursive(Boolean.valueOf(true));
                folders.add(folder);
            } else if (this.args.getReportFolders().getValue() != null) {
                for (String inFolder : (List)this.args.getReportFolders().getValue()) {
                    Folder folder = new Folder();
                    boolean recursive = false;
                    this.logger.debug((Object)"Add reports /*: ");
                    if (inFolder.endsWith("/*")) {
                        recursive = true;
                        inFolder = inFolder.substring(0, inFolder.length() - 2);
                    }
                    folder.setFolder(inFolder);
                    folder.setRecursive(Boolean.valueOf(recursive));
                    folders.add(folder);
                }
            }
            if (folders.size() > 0) {
                Reports reports = runReportsWebserviceExecuter.getReports(accessToken, folders);
                for (Report report : reports.getReports()) {
                    this.logger.debug((Object)("Add report from folder: " + report.getPath()));
                    reportPaths.add(report.getPath());
                }
            }
            runReportsWebserviceExecuter.generateReports(accessToken, reportPaths);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (accessToken != null) {
                apiExecutor.logout(accessToken);
            }
            apiExecutor.close();
        }
    }
}

