/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.util.SOSClassUtil;
import sos.util.SOSFile;

public class SOSConnectionFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSConnectionFileProcessor.class);
    SOSConnection connection = null;
    String settingsFilename = null;
    String fileSpec = "^(.*)";
    boolean hasDirectory = false;
    boolean commitAtEnd = false;
    private ArrayList<String> successFiles;
    private LinkedHashMap<String, String> errorFiles;

    public SOSConnectionFileProcessor(SOSConnection sosConnection) throws Exception {
        this.setConnection(sosConnection);
        this.init();
    }

    public SOSConnectionFileProcessor(String settingsFilename) throws Exception {
        this.setSettingsFilename(settingsFilename);
        this.init();
    }

    public void init() throws Exception {
        try {
            if (this.getConnection() == null && (this.getSettingsFilename() == null || this.getSettingsFilename().trim().isEmpty())) {
                throw new Exception("no connection and no settings filename were given for connection");
            }
            LOGGER.debug("DB Connecting.. .");
            this.setConnection(SOSConnection.createInstance(this.getSettingsFilename()));
            this.getConnection().connect();
            LOGGER.debug("DB Connected");
        }
        catch (Exception e) {
            throw new Exception("connect to database failed: " + e.toString(), e);
        }
    }

    public void process(File inputFile, String fileSpec) throws Exception {
        this.setFileSpec(fileSpec);
        this.process(inputFile);
    }

    private void initCounters() {
        this.errorFiles = new LinkedHashMap();
        this.successFiles = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File inputFile) throws Exception {
        block37: {
            String methodName = SOSClassUtil.getMethodName();
            boolean isEnd = false;
            try {
                if (inputFile.isDirectory()) {
                    int i;
                    LOGGER.info(String.format("%s: process directory %s, fileSpec = %s", methodName, inputFile.getAbsolutePath(), this.getFileSpec()));
                    this.hasDirectory = true;
                    this.initCounters();
                    Vector filelist = SOSFile.getFilelist((String)inputFile.getAbsolutePath(), (String)this.getFileSpec(), (int)0);
                    Iterator iterator = filelist.iterator();
                    while (iterator.hasNext()) {
                        this.process((File)iterator.next());
                    }
                    isEnd = true;
                    LOGGER.info(String.format("%s: directory proccessed (total = %s, success = %s, error = %s) %s", methodName, filelist.size(), this.successFiles.size(), this.errorFiles.size(), inputFile.getAbsolutePath()));
                    if (!this.successFiles.isEmpty()) {
                        LOGGER.info(String.format("%s:   success:", methodName));
                        for (i = 0; i < this.successFiles.size(); ++i) {
                            LOGGER.info(String.format("%s:     %s) %s", methodName, i + 1, this.successFiles.get(i)));
                        }
                    }
                    if (!this.errorFiles.isEmpty()) {
                        LOGGER.info(String.format("%s:   error:", methodName));
                        i = 1;
                        for (Map.Entry<String, String> entry : this.errorFiles.entrySet()) {
                            LOGGER.info(String.format("%s:     %s) %s: %s", methodName, i, entry.getKey(), entry.getValue()));
                            ++i;
                        }
                    }
                    break block37;
                }
                FileReader fr = null;
                BufferedReader br = null;
                StringBuilder sb = new StringBuilder();
                LOGGER.info(String.format("%s: process file %s", methodName, inputFile.getAbsolutePath()));
                try {
                    fr = new FileReader(inputFile.getAbsolutePath());
                    br = new BufferedReader(fr);
                    String nextLine = "";
                    while ((nextLine = br.readLine()) != null) {
                        sb.append(nextLine);
                        sb.append("\n");
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.getConnection().executeStatements(sb.toString());
                if (!this.hasDirectory) {
                    isEnd = true;
                }
                this.successFiles.add(inputFile.getAbsolutePath());
                LOGGER.info(String.format("%s: file successfully processed %s", methodName, inputFile.getAbsolutePath()));
            }
            catch (Exception e) {
                this.errorFiles.put(inputFile.getAbsolutePath(), e.getMessage());
                LOGGER.warn(String.format("%s: an error occurred processing file [%s]: %s", methodName, inputFile.getAbsolutePath(), e.toString()), (Throwable)e);
            }
            finally {
                try {
                    if (this.getConnection() != null && isEnd) {
                        if (this.isCommitAtEnd()) {
                            this.getConnection().commit();
                        } else {
                            this.getConnection().executeUpdate("ROLLBACK");
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getParamValue(String param) {
        String[] arr = param.split("=");
        if (arr.length > 1) {
            return arr[1].trim();
        }
        return param;
    }

    public SOSConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SOSConnection connection) {
        this.connection = connection;
    }

    public String getSettingsFilename() {
        return this.settingsFilename;
    }

    public void setSettingsFilename(String settingsFilename) {
        this.settingsFilename = settingsFilename;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(String fileSpec) {
        this.fileSpec = fileSpec;
    }

    public boolean isCommitAtEnd() {
        return this.commitAtEnd;
    }

    public void setCommitAtEnd(boolean commitAtEnd) {
        this.commitAtEnd = commitAtEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: SOSConnectionFileProcessor configuration-file  path  [file-specification]  [log-level] [-commit-at-end|-auto-commit|-execute-batch|batch-size=xxx]");
            return;
        }
        SOSConnectionFileProcessor processor = null;
        int exitCode = 0;
        boolean logToStdErr = false;
        try {
            String settingsFile = args[0];
            logToStdErr = Arrays.asList(args).contains("-execute-from-setup");
            processor = new SOSConnectionFileProcessor(settingsFile);
            File inputFile = null;
            for (int i = 0; i < args.length; ++i) {
                String param = args[i].trim();
                System.out.println(String.format("  %s) %s", i + 1, param));
                if (i == 1) {
                    inputFile = new File(param);
                    continue;
                }
                if (i == 2) {
                    processor.setFileSpec(param);
                    continue;
                }
                if (i <= 3) continue;
                if ("-commit-at-end".equalsIgnoreCase(param)) {
                    processor.setCommitAtEnd(true);
                    continue;
                }
                if ("-auto-commit".equalsIgnoreCase(param)) {
                    processor.getConnection().setAutoCommit(true);
                    continue;
                }
                if ("-execute-batch".equalsIgnoreCase(param)) {
                    processor.getConnection().setUseExecuteBatch(true);
                    continue;
                }
                if (param.startsWith("batch-size")) {
                    int batchSize = processor.getConnection().getBatchSize();
                    try {
                        batchSize = Integer.parseInt(processor.getParamValue(param));
                    }
                    catch (Exception ex) {
                        System.out.println(String.format("   error: invalid value of the param %s", param));
                        System.out.println(String.format("          batch-size setted to default value = %s", batchSize));
                    }
                    processor.getConnection().setBatchSize(batchSize);
                    continue;
                }
                if (!"-execute-from-setup".equalsIgnoreCase(param)) continue;
                processor.getConnection().setUseExecuteBatch(true);
                logToStdErr = true;
            }
            processor.process(inputFile);
            if (processor.errorFiles != null) {
                exitCode = processor.errorFiles.size();
                if (logToStdErr && !processor.errorFiles.isEmpty()) {
                    Map.Entry<String, String> entry = processor.errorFiles.entrySet().iterator().next();
                    System.err.println(String.format("%s: %s", entry.getKey(), entry.getValue()));
                }
            }
            if (logToStdErr && processor.successFiles != null && !processor.successFiles.isEmpty()) {
                System.err.println(String.format("%s processed successfully", processor.successFiles.get(0)));
            }
        }
        catch (Exception e) {
            exitCode = 1;
            if (logToStdErr) {
                e.printStackTrace(System.err);
            } else {
                e.printStackTrace(System.out);
            }
        }
        finally {
            if (processor != null && processor.getConnection() != null) {
                try {
                    processor.getConnection().disconnect();
                }
                catch (Exception exception) {}
            }
        }
        System.exit(exitCode);
    }
}

