/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import javax.naming.InitialContext;
import javax.sql.DataSource;
import sos.connection.SOSConnection;

public class SOSConnectionPool {
    private InitialContext initCtx = null;
    private DataSource dataSource = null;
    private String dataSourceName = null;
    private String sosConnectionClassName = null;
    private boolean lookupCalled = false;

    public SOSConnectionPool(String dataSourceName) throws Exception {
        if (dataSourceName == null || dataSourceName.isEmpty()) {
            throw new Exception("missing datasource name!!");
        }
        this.dataSourceName = dataSourceName;
        this.lookup();
        this.lookupCalled = true;
    }

    public SOSConnectionPool(String dataSourceName, String sosConnectionClassName) throws Exception {
        this(dataSourceName);
        if (sosConnectionClassName == null || sosConnectionClassName.isEmpty()) {
            throw new Exception("missing sosconnection class name!!");
        }
        this.sosConnectionClassName = sosConnectionClassName;
        this.lookupCalled = true;
    }

    public SOSConnectionPool() {
        this.lookupCalled = false;
    }

    private void lookup() throws Exception {
        try {
            this.initCtx = new InitialContext();
            this.dataSource = (DataSource)this.initCtx.lookup("java:comp/env/" + this.dataSourceName);
        }
        catch (Exception e) {
            throw new Exception("Could not find datasource for [" + this.dataSourceName + "], " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOSConnection getConnection() throws Exception {
        if (!this.lookupCalled) {
            if (this.dataSourceName == null || this.dataSourceName.isEmpty()) {
                throw new Exception("missing datasource name!!");
            }
            if (this.sosConnectionClassName == null || this.sosConnectionClassName.isEmpty()) {
                throw new Exception("missing sosconnection class name!!");
            }
            this.lookup();
        }
        DataSource dataSource = this.getDataSource();
        synchronized (dataSource) {
            SOSConnection retConnection = null;
            retConnection = SOSConnection.createInstance(this.getSosConnectionClassName(), this.getDataSource().getConnection());
            retConnection.prepare(retConnection.getConnection());
            return retConnection;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void close() {
        try {
            if (this.initCtx != null) {
                this.initCtx.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSosConnectionClassName() {
        return this.sosConnectionClassName;
    }

    public void setSosConnectionClassName(String sosConnectionClassName) {
        this.sosConnectionClassName = sosConnectionClassName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

