/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import java.sql.DatabaseMetaData;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;

public class SOSConnectionVersionLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSConnectionVersionLimiter.class);
    private HashSet excludedVersions = new HashSet();
    private HashSet supportedVersions = new HashSet();
    private DBVersion minSupportedVersion = null;
    private DBVersion maxSupportedVersion = null;
    private DBVersion excludedFromVersion = null;
    private DBVersion excludedThroughVersion = null;
    public static final int CHECK_OFF = 0;
    public static final int CHECK_NORMAL = 1;
    public static final int CHECK_STRICT = 2;
    public static final int VERSION_EXCLUDED = 0;
    public static final int VERSION_UNTESTED = 1;
    public static final int VERSION_SUPPORTED = 2;

    public void addExcludedVersion(int majorVersion, int minorVersion) {
        DBVersion version = new DBVersion(majorVersion, minorVersion);
        this.excludedVersions.add(version);
    }

    public void addExcludedVersion(String version) {
        this.excludedVersions.add(version);
    }

    public void addSupportedVersion(int majorVersion, int minorVersion) {
        DBVersion version = new DBVersion(majorVersion, minorVersion);
        this.supportedVersions.add(version);
    }

    public void addSupportedVersion(String version) {
        this.supportedVersions.add(version);
    }

    public void setMaxSupportedVersion(int majorVersion, int minorVersion) {
        this.maxSupportedVersion = new DBVersion(majorVersion, minorVersion);
    }

    public void setExcludedThroughVersion(int majorVersion, int minorVersion) {
        this.excludedThroughVersion = new DBVersion(majorVersion, minorVersion);
    }

    public void setMinSupportedVersion(int majorVersion, int minorVersion) {
        this.minSupportedVersion = new DBVersion(majorVersion, minorVersion);
    }

    public void setExcludedFromVersion(DBVersion excludedFromVersion) {
        this.excludedFromVersion = excludedFromVersion;
    }

    public int check(SOSConnection conn) throws BadDatabaseVersionException {
        return this.check(conn, conn.getCompatibility());
    }

    public int check(SOSConnection conn, int compatibility) throws BadDatabaseVersionException {
        int major = -1;
        int minor = 0;
        boolean excluded = false;
        boolean untested = false;
        String sDbVersion = "";
        DBVersion db = null;
        Exception lastError = null;
        String shortVersion = "";
        try {
            DatabaseMetaData meta = conn.getConnection().getMetaData();
            try {
                major = meta.getDatabaseMajorVersion();
                minor = meta.getDatabaseMinorVersion();
                conn.setMajorVersion(major);
                conn.setMinorVersion(minor);
                LOGGER.debug("DatabaseMajorVersion: " + major);
                LOGGER.debug("DatabaseMinorVersion: " + minor);
            }
            catch (AbstractMethodError ex) {
                lastError = new Exception(ex);
            }
            catch (Exception ex) {
                lastError = ex;
            }
            try {
                sDbVersion = meta.getDatabaseProductVersion();
                conn.setProductVersion(sDbVersion);
                LOGGER.debug("DatabaseProductVersion: " + sDbVersion);
            }
            catch (Exception ex) {
                lastError = ex;
            }
            if (major == -1 && sDbVersion.isEmpty()) {
                throw new Exception("Failed to get any version information from the database: " + lastError);
            }
            if (major != -1) {
                db = new DBVersion(major, minor);
            } else {
                try {
                    major = conn.parseMajorVersion(sDbVersion);
                    minor = conn.parseMinorVersion(sDbVersion);
                    conn.setMajorVersion(major);
                    conn.setMinorVersion(minor);
                    db = new DBVersion(major, minor);
                }
                catch (Exception e) {
                    LOGGER.info("Error occured: " + e);
                }
            }
            shortVersion = db != null ? db.toString() : sDbVersion;
            excluded = this.isExcludedVersion(db, sDbVersion);
            untested = this.isUntestedVersion(db, sDbVersion);
            LOGGER.debug("Excluded Database Version: " + excluded);
            LOGGER.debug("Untested Database Version: " + untested);
        }
        catch (Exception e) {
            try {
                if (compatibility != 0) {
                    LOGGER.warn("Error occured checking database version: " + e);
                } else {
                    LOGGER.info("Error occured checking database version: " + e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (excluded) {
            if (compatibility == 2 || compatibility == 1) {
                throw new BadDatabaseVersionException(0, shortVersion);
            }
            return 0;
        }
        if (untested) {
            if (compatibility == 2) {
                throw new BadDatabaseVersionException(1, shortVersion);
            }
            return 1;
        }
        return 2;
    }

    private boolean isExcludedVersion(DBVersion db, String sDbVersion) {
        boolean rc = false;
        if (db != null) {
            if (this.excludedVersions.contains(db)) {
                return true;
            }
            if (this.supportedVersions.contains(db)) {
                return false;
            }
            if (this.excludedFromVersion != null && this.excludedFromVersion.compareTo(db) <= 0) {
                rc = true;
            }
            if (this.excludedThroughVersion != null && this.excludedThroughVersion.compareTo(db) >= 0) {
                rc = true;
            }
        }
        if (sDbVersion != null) {
            if (this.excludedVersions.contains(sDbVersion)) {
                return true;
            }
            if (this.supportedVersions.contains(sDbVersion)) {
                return false;
            }
        }
        return rc;
    }

    private boolean isUntestedVersion(DBVersion db, String sDbVersion) {
        boolean rc = false;
        if (db != null) {
            if (this.supportedVersions.contains(db)) {
                return false;
            }
            if (this.minSupportedVersion != null && this.minSupportedVersion.compareTo(db) > 0) {
                rc = true;
            }
            if (this.maxSupportedVersion != null && this.maxSupportedVersion.compareTo(db) < 0) {
                rc = true;
            }
        }
        if (sDbVersion != null && this.supportedVersions.contains(sDbVersion)) {
            return false;
        }
        return rc;
    }

    public class BadDatabaseVersionException
    extends Exception {
        private static final long serialVersionUID = -5129710619578262940L;
        private int reason = 0;
        private String message = "";

        public BadDatabaseVersionException(int reason, String version) {
            this.reason = reason;
            if (reason == 0) {
                this.message = "This database Version (" + version + ") is an excluded version.";
            }
            if (reason == 1) {
                this.message = "This database Version (" + version + ") is an untested version.";
            }
        }

        public int getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public class DBVersion
    implements Comparable {
        private int majorVersion;
        private int minorVersion;

        public DBVersion(int majorVersion, int minorVersion) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DBVersion) {
                DBVersion other = (DBVersion)obj;
                return this.getMajorVersion() == other.getMajorVersion() && this.getMinorVersion() == other.getMinorVersion();
            }
            return super.equals(obj);
        }

        public int compareTo(Object o) {
            DBVersion other = (DBVersion)o;
            if (other.getMajorVersion() > this.getMajorVersion()) {
                return -1;
            }
            if (other.getMajorVersion() < this.getMajorVersion()) {
                return 1;
            }
            if (other.getMinorVersion() > this.getMinorVersion()) {
                return -1;
            }
            if (other.getMinorVersion() < this.getMinorVersion()) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return this.majorVersion * 100 + this.minorVersion;
        }

        public String toString() {
            return this.getMajorVersion() + "." + this.getMinorVersion();
        }
    }
}

