/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.connection.SOSConnectionVersionLimiter;
import sos.connection.SequenceReader;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSFbSQLConnection
extends SOSConnection
implements SequenceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFbSQLConnection.class);
    private static final String[] REPLACEMENT = new String[]{"LOWER", "UPPER", "CURRENT_TIMESTAMP", "FOR UPDATE WITH LOCK"};
    private static final SOSConnectionVersionLimiter VERSION_LIMITER = new SOSConnectionVersionLimiter();

    public SOSFbSQLConnection(Connection connection) throws Exception {
        super(connection);
    }

    public SOSFbSQLConnection(String configFileName) throws Exception {
        super(configFileName);
    }

    public SOSFbSQLConnection(String driver, String url, String dbuser, String dbpassword) throws Exception {
        super(driver, url, dbuser, dbpassword);
    }

    @Override
    public void connect() throws Exception {
        Properties properties = new Properties();
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (SOSString.isEmpty((String)this.url)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database url.");
        }
        if (SOSString.isEmpty((String)this.driver)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database driver.");
        }
        if (SOSString.isEmpty((String)this.dbuser)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database user.");
        }
        if (SOSString.isEmpty((String)this.dbpassword)) {
            this.dbpassword = "";
        }
        properties.setProperty("user", this.dbuser);
        properties.setProperty("password", this.dbpassword);
        Driver driver = (Driver)Class.forName(this.driver).newInstance();
        this.connection = driver.connect(this.url, properties);
        if (this.connection == null) {
            throw new Exception("can't connect to database");
        }
        VERSION_LIMITER.check(this);
        LOGGER.debug(".. successfully connected to " + this.url);
        this.prepare(this.connection);
    }

    @Override
    public void prepare(Connection connection) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        Statement stmt = null;
        try {
            if (connection == null) {
                throw new Exception("can't connect to database");
            }
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(4);
            connection.rollback();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String toDate(String dateString) throws Exception {
        if (SOSString.isEmpty((String)dateString)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": dateString has no value.");
        }
        return "CAST('" + dateString + "' AS TIMESTAMP)";
    }

    @Override
    protected GregorianCalendar getDateTime(String format) throws Exception {
        GregorianCalendar gc = new GregorianCalendar();
        String timestamp = this.getSingleValue("select FIRST 1 CURRENT_TIMESTAMP from RDB$DATABASE");
        if (timestamp.length() > 19) {
            timestamp = timestamp.substring(0, 19);
        }
        Date date = SOSDate.getDate((String)timestamp, (String)format);
        gc.setTime(date);
        return gc;
    }

    @Override
    protected String replaceCasts(String inputString) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        Pattern pattern = Pattern.compile("(\\s*%cast\\s*)*\\s*(\\()*\\s*(\\s*%cast\\s*)+\\s*(\\(\\s*\\S+\\s*(\\S+?).*?)\\)(\\s*(\\+|\\-)*[0-9]*\\s*\\S*(\\)))*");
        Matcher matcher = pattern.matcher(inputString);
        StringBuffer buffer = new StringBuffer();
        String replaceString = null;
        LOGGER.trace("..inputString [" + inputString + "]");
        while (matcher.find()) {
            String token;
            replaceString = matcher.group().toLowerCase();
            if (matcher.group(1) != null && matcher.group(6) != null) {
                token = matcher.group(6).replaceFirst("\\)", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", " as varchar(1000)");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", " as character");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", " as integer");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", " as timestamp");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", " as timestamp");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                }
            }
            if (matcher.group(3) != null && matcher.group(4) != null) {
                token = matcher.group(4).replaceFirst("\\(", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", " as varchar(1000)");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", " as character");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", " as integer");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", " as timestamp");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", " as timestamp");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                }
            }
            replaceString = replaceString.toUpperCase();
            matcher.appendReplacement(buffer, replaceString);
        }
        matcher.appendTail(buffer);
        LOGGER.debug(".. result [" + buffer.toString() + "]");
        return buffer.toString();
    }

    @Override
    protected String getLastSequenceQuery(String sequence) {
        return "SELECT GEN_ID(" + sequence + ", 0) FROM RDB$DATABASE;";
    }

    @Override
    public String getNextSequenceValue(String sequence) throws Exception {
        return this.getSingleValue("SELECT GEN_ID(" + sequence + ", 1) FROM RDB$DATABASE;");
    }

    @Override
    protected boolean prepareGetStatements(StringBuffer contentSB, StringBuffer splitSB, StringBuffer endSB) throws Exception {
        if (contentSB == null) {
            throw new Exception("contentSB is null");
        }
        if (splitSB == null) {
            throw new Exception("splitSB is null");
        }
        if (endSB == null) {
            throw new Exception("endSB is null");
        }
        StringBuffer patterns = new StringBuffer("set+[\\s]*term[inator]*[\\s]*(.*);");
        Pattern p = Pattern.compile(patterns.toString());
        Matcher matcher = p.matcher(contentSB.toString().toLowerCase().trim());
        if (matcher.find()) {
            splitSB.append("\\" + matcher.group(1));
            String strContent = contentSB.toString().replaceAll("(?i)set+[\\s]*term[inator]*[\\s]*.*\\n", "");
            contentSB.delete(0, contentSB.length());
            contentSB.append(strContent);
        } else {
            splitSB.append("\n/\n");
        }
        endSB.append("");
        return true;
    }

    @Override
    public String[] getReplacement() {
        return REPLACEMENT;
    }

    static {
        VERSION_LIMITER.addSupportedVersion(1, 5);
        VERSION_LIMITER.setExcludedThroughVersion(1, 4);
    }
}

