/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.connection.SOSConnectionVersionLimiter;
import sos.connection.SequenceReader;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSOracleConnection
extends SOSConnection
implements SequenceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSOracleConnection.class);
    private static final String[] REPLACEMENT = new String[]{"LOWER", "UPPER", "SYSDATE", "FOR UPDATE"};
    private static final SOSConnectionVersionLimiter VERSION_LIMITER = new SOSConnectionVersionLimiter();

    public SOSOracleConnection(Connection connection) throws Exception {
        super(connection);
    }

    public SOSOracleConnection(String configFileName) throws Exception {
        super(configFileName);
    }

    public SOSOracleConnection(String driver, String url, String dbuser, String dbpassword) throws Exception {
        super(driver, url, dbuser, dbpassword);
    }

    @Override
    public void connect() throws Exception {
        Properties properties = new Properties();
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (SOSString.isEmpty((String)this.url)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database url.");
        }
        if (SOSString.isEmpty((String)this.driver)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database driver.");
        }
        if (!SOSString.isEmpty((String)this.dbuser) && !"[SSO]".equalsIgnoreCase(this.dbuser)) {
            properties.setProperty("user", this.dbuser);
            properties.setProperty("password", this.dbpassword);
        }
        Driver driver = (Driver)Class.forName(this.driver).newInstance();
        this.connection = driver.connect(this.url, properties);
        if (this.connection == null) {
            throw new Exception("can't connect to database");
        }
        LOGGER.debug(".. successfully connected to " + this.url);
        VERSION_LIMITER.check(this);
        this.prepare(this.connection);
    }

    @Override
    public void prepare(Connection connection) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        Statement stmt = null;
        try {
            if (connection == null) {
                throw new Exception("can't connect to database");
            }
            connection.setAutoCommit(false);
            connection.rollback();
            stmt = connection.createStatement();
            String nlsNumericCharacters = "ALTER SESSION SET NLS_NUMERIC_CHARACTERS='.,'";
            String nlsDateFormat = "ALTER SESSION SET NLS_DATE_FORMAT='YYYY-MM-DD HH24:MI:SS'";
            String nlsSort = "ALTER SESSION SET NLS_SORT='BINARY'";
            stmt.addBatch(nlsNumericCharacters);
            stmt.addBatch(nlsDateFormat);
            stmt.addBatch(nlsSort);
            stmt.executeBatch();
            LOGGER.trace(".. " + nlsNumericCharacters + " successfully set.");
            LOGGER.trace(".. " + nlsDateFormat + " successfully set.");
            LOGGER.trace(".. " + nlsSort + " successfully set.");
            CallableStatement enableStmt = null;
            enableStmt = this.getConnection().prepareCall("begin dbms_output.enable(10000); end;");
            enableStmt.executeUpdate();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public long updateBlob(String tableName, String columnName, byte[] data, String condition) throws Exception {
        long totalBytesRead = 0L;
        Statement stmt = null;
        StringBuilder query = null;
        String theQuery = null;
        int chunkSize = 0;
        ByteArrayInputStream in = null;
        ResultSet rs = null;
        OutputStream out = null;
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (SOSString.isEmpty((String)tableName)) {
                throw new Exception("tableName is null.");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new Exception("columnName is null.");
            }
            if (data.length <= 0) {
                throw new Exception("data has no value.");
            }
            in = new ByteArrayInputStream(data);
            this.connection.setAutoCommit(false);
            query = new StringBuilder();
            query.append("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            if (this.fieldNameUpperCase) {
                query.append(" SET \"");
                query.append(columnName.toUpperCase());
                query.append("\" = empty_blob() ");
            } else {
                query.append(" SET ");
                query.append(columnName);
                query.append(" = empty_blob() ");
            }
            condition = !SOSString.isEmpty((String)condition) ? " WHERE " + condition : "";
            query.append(condition);
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.trace(".. " + theQuery);
            stmt = this.connection.createStatement();
            stmt.execute(theQuery);
            stmt.close();
            stmt = null;
            query = new StringBuilder();
            query.append("SELECT ");
            if (this.fieldNameUpperCase) {
                query.append("\"");
                query.append(columnName.toUpperCase());
                query.append("\"");
            } else {
                query.append(columnName);
            }
            query.append(" FROM ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            query.append(condition);
            query.append(" FOR UPDATE");
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.trace(".. " + theQuery);
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(theQuery);
            if (rs.next()) {
                BLOB blob = (BLOB)rs.getBlob(1);
                out = blob.getBinaryOutputStream();
                chunkSize = blob.getChunkSize();
                LOGGER.trace(".. current chunk size: " + chunkSize);
                byte[] buffer = new byte[chunkSize];
                int bytesRead = 0;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesRead += (long)bytesRead;
                }
            } else {
                throw new Exception("failed: no blob found: " + theQuery);
            }
            LOGGER.debug(".. blob successfully updated.");
        }
        catch (Exception e) {
            if (this.connection != null) {
                this.connection.rollback();
            }
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return totalBytesRead;
    }

    @Override
    public long updateBlob(String tableName, String columnName, String fileName, String condition) throws Exception {
        long totalBytesRead = 0L;
        OutputStream out = null;
        InputStream in = null;
        StringBuilder query = null;
        Statement stmt = null;
        ResultSet rs = null;
        String theQuery = null;
        int chunkSize = 0;
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (SOSString.isEmpty((String)tableName)) {
                throw new Exception("tableName is null.");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new Exception("columnName is null.");
            }
            if (SOSString.isEmpty((String)fileName)) {
                throw new Exception("fileName is null.");
            }
            File file = new File(fileName);
            if (!file.exists()) {
                throw new Exception("file doesn't exist.");
            }
            in = new FileInputStream(file);
            this.connection.setAutoCommit(false);
            query = new StringBuilder();
            query.append("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            if (this.fieldNameUpperCase) {
                query.append(" SET \"");
                query.append(columnName.toUpperCase());
                query.append("\" = empty_blob() ");
            } else {
                query.append(" SET ");
                query.append(columnName);
                query.append(" = empty_blob() ");
            }
            condition = !SOSString.isEmpty((String)condition) ? " WHERE " + condition : "";
            query.append(condition);
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.trace(".. " + theQuery);
            stmt = this.connection.createStatement();
            stmt.execute(theQuery);
            query = new StringBuilder();
            query.append("SELECT ");
            if (this.fieldNameUpperCase) {
                query.append("\"");
                query.append(columnName.toUpperCase());
                query.append("\"");
            } else {
                query.append(columnName);
            }
            query.append(" FROM ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            query.append(" ");
            query.append(condition);
            query.append(" FOR UPDATE");
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.trace(".. select the BLOB: " + theQuery);
            rs = stmt.executeQuery(theQuery);
            if (rs.next()) {
                BLOB blob = (BLOB)rs.getBlob(1);
                out = blob.getBinaryOutputStream();
                chunkSize = blob.getChunkSize();
                LOGGER.trace(".. current chunk size: " + chunkSize);
                byte[] buffer = new byte[chunkSize];
                int bytesRead = 0;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesRead += (long)bytesRead;
                }
            } else {
                throw new Exception("failed: no blob found: " + theQuery);
            }
            LOGGER.debug(".. blob successfully updated.");
        }
        catch (Exception e) {
            if (this.connection != null) {
                this.connection.rollback();
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.toString(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return totalBytesRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getBlob(String query, String fileName) throws Exception {
        InputStream in = null;
        FileOutputStream out = null;
        ResultSet rs = null;
        Statement stmt = null;
        long readBytes = 0L;
        int len = 0;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, REPLACEMENT);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (rs.next()) {
                in = rs.getBinaryStream(1);
                if (in == null) {
                    long l = readBytes;
                    return l;
                }
                byte[] buff = new byte[1024];
                len = in.read(buff);
                if (len <= 0) {
                    LOGGER.trace(".. blob column has 0 bytes.");
                    long l = readBytes;
                    return l;
                }
                out = new FileOutputStream(fileName);
                out.write(buff, 0, len);
                readBytes += (long)len;
                while (0 < (len = in.read(buff))) {
                    out.write(buff, 0, len);
                    readBytes += (long)len;
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
            return readBytes;
        }
        catch (Exception e) {
            if (profiler == null) throw e;
            try {
                profiler.stop("ERROR", e.toString());
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBlob(String query) throws Exception {
        ByteArrayOutputStream out = null;
        BufferedInputStream in = null;
        ResultSet rs = null;
        Statement stmt = null;
        byte[] result = new byte[]{};
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, REPLACEMENT);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt = this.connection.createStatement();
            LOGGER.debug(".. " + query);
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                Blob blob = rs.getBlob(1);
                if (blob == null) {
                    LOGGER.trace(".. ResultSet returns NULL value.");
                    byte[] byArray = result;
                    return byArray;
                }
                byte[] data = new byte[(int)blob.length()];
                out = new ByteArrayOutputStream((int)blob.length());
                in = new BufferedInputStream(blob.getBinaryStream());
                if (in == null) {
                    LOGGER.trace(".. ResultSet InputStream returns NULL value.");
                    byte[] byArray = result;
                    return byArray;
                }
                int bytesRead = in.read(data, 0, data.length);
                if (bytesRead != -1) {
                    out.write(data, 0, bytesRead);
                    result = out.toByteArray();
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
            return result;
        }
        catch (Exception e) {
            if (profiler == null) throw e;
            try {
                profiler.stop("ERROR", e.toString());
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public long getClob(String query, String fileName) throws Exception {
        OutputStreamWriter out = null;
        Reader in = null;
        File file = null;
        ResultSet rs = null;
        Statement stmt = null;
        int bytesRead = 0;
        long totalBytesRead = 0L;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, REPLACEMENT);
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                in = rs.getCharacterStream(1);
                if (in == null) {
                    LOGGER.trace(".. ResultSet returns NULL value.");
                    long l = totalBytesRead;
                    return l;
                }
                file = new File(fileName);
                out = new FileWriter(file);
                char[] buffer = new char[32];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesRead += (long)bytesRead;
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return totalBytesRead;
    }

    @Override
    public String getClob(String query) throws Exception {
        Reader in = null;
        ResultSet rs = null;
        Statement stmt = null;
        int bytesRead = 0;
        StringBuilder sb = new StringBuilder();
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method is not called");
            }
            query = this.normalizeStatement(query, REPLACEMENT);
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                in = rs.getCharacterStream(1);
                if (in == null) {
                    LOGGER.trace(".. ResultSet returns NULL value.");
                    String string = sb.toString();
                    return string;
                }
                while ((bytesRead = in.read()) != -1) {
                    sb.append((char)bytesRead);
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    @Override
    public long updateClob(String tableName, String columnName, File file, String condition) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer query = null;
        long totalBytesWritten = 0L;
        int bytesRead = 0;
        String theQuery = null;
        InputStreamReader in = null;
        Writer out = null;
        CLOB clob = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (SOSString.isEmpty((String)tableName)) {
                throw new NullPointerException("tableName is null.");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new NullPointerException("columnName is null.");
            }
            if (!file.exists()) {
                throw new Exception("file doesn't exist.");
            }
            query = new StringBuffer("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            if (this.fieldNameUpperCase) {
                query.append(" SET \"");
                query.append(columnName.toUpperCase());
                query.append("\" = empty_clob() ");
            } else {
                query.append(" SET ");
                query.append(columnName);
                query.append(" = empty_clob() ");
            }
            condition = !SOSString.isEmpty((String)condition) ? " WHERE " + condition : "";
            query.append(condition);
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            stmt = this.connection.createStatement();
            stmt.executeUpdate(theQuery);
            try {
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                throw new Exception("an error occurred closing the statement: " + e);
            }
            stmt = this.connection.createStatement();
            if (this.fieldNameUpperCase) {
                query = new StringBuffer("SELECT \"");
                query.append(columnName.toUpperCase());
                query.append("\" FROM ");
            } else {
                query = new StringBuffer("SELECT ");
                query.append(columnName);
                query.append(" FROM ");
            }
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            query.append(" ");
            query.append(condition);
            query.append(" for update nowait");
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            rs = stmt.executeQuery(theQuery);
            if (rs.next()) {
                clob = (CLOB)rs.getClob(1);
            }
            in = new FileReader(file);
            char[] buffer = new char[clob.getBufferSize()];
            out = clob.getCharacterOutputStream();
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                totalBytesWritten += (long)bytesRead;
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return totalBytesWritten;
    }

    @Override
    public long updateClob(String tableName, String columnName, String data, String condition) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer query = null;
        long totalBytesWritten = 0L;
        int bytesRead = 0;
        int bufferSize = 0;
        String theQuery = null;
        Writer out = null;
        StringReader in = null;
        CLOB clob = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception("sorry, there is no successful connection established. may be the connect method is not called");
            }
            if (SOSString.isEmpty((String)tableName)) {
                throw new NullPointerException("tableName is null.");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new NullPointerException("columnName is null.");
            }
            if (SOSString.isEmpty((String)data)) {
                throw new Exception("data has null value.");
            }
            query = new StringBuffer("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            if (this.fieldNameUpperCase) {
                query.append(" SET \"");
                query.append(columnName.toUpperCase());
                query.append("\" = empty_clob() ");
            } else {
                query.append(" SET ");
                query.append(columnName);
                query.append(" = empty_clob() ");
            }
            condition = !SOSString.isEmpty((String)condition) ? " WHERE " + condition : "";
            query.append(condition);
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            stmt = this.connection.createStatement();
            stmt.executeUpdate(theQuery);
            try {
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                throw new Exception(" an error occurred closing the statement: " + e);
            }
            stmt = this.connection.createStatement();
            if (this.fieldNameUpperCase) {
                query = new StringBuffer("SELECT \"");
                query.append(columnName.toUpperCase());
                query.append("\" FROM ");
            } else {
                query = new StringBuffer("SELECT ");
                query.append(columnName);
                query.append(" FROM ");
            }
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            query.append(" ");
            query.append(condition);
            query.append(" for update nowait");
            theQuery = this.normalizeStatement(query.toString(), REPLACEMENT);
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            rs = stmt.executeQuery(theQuery);
            if (rs.next()) {
                clob = (CLOB)rs.getClob(1);
            }
            bufferSize = clob.getBufferSize();
            char[] buffer = new char[bufferSize];
            out = clob.getCharacterOutputStream();
            in = new StringReader(data);
            while ((bytesRead = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, bytesRead);
                totalBytesWritten += (long)bytesRead;
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return totalBytesWritten;
    }

    @Override
    public String toDate(String dateString) throws Exception {
        if (SOSString.isEmpty((String)dateString)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": dateString has no value.");
        }
        return "to_date('" + dateString + "','YYYY-MM-DD HH24:MI:SS')";
    }

    public Vector getOutput() throws Exception {
        Vector<String> out = new Vector<String>();
        CallableStatement stmt = null;
        try {
            String getLineSql = "begin dbms_output.get_line(?,?); end;";
            stmt = this.getConnection().prepareCall(getLineSql);
            boolean hasMore = true;
            stmt.registerOutParameter(1, 12);
            stmt.registerOutParameter(2, 4);
            while (hasMore) {
                stmt.execute();
                hasMore = stmt.getInt(2) == 0;
                if (!hasMore) continue;
                out.add(stmt.getString(1));
            }
        }
        catch (Exception e) {
            throw new Exception("error occurred reading output: " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (Exception exception) {}
            }
        }
        return out;
    }

    @Override
    protected GregorianCalendar getDateTime(String format) throws Exception {
        GregorianCalendar gc = new GregorianCalendar();
        String timestamp = this.getSingleValue("select SYSDATE from dual");
        if (timestamp.length() > 19) {
            timestamp = timestamp.substring(0, 19);
        }
        Date date = SOSDate.getDate((String)timestamp, (String)format);
        gc.setTime(date);
        return gc;
    }

    @Override
    protected String replaceCasts(String inputString) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        Pattern pattern = Pattern.compile("(\\s*%cast\\s*)*\\s*(\\()*\\s*(\\s*%cast\\s*)+\\s*(\\(\\s*\\S+\\s*(\\S+?).*?)\\)(\\s*(\\+|\\-)*[0-9]*\\s*\\S*(\\)))*");
        Matcher matcher = pattern.matcher(inputString);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String token;
            String replaceString = matcher.group().toLowerCase();
            if (matcher.group(1) != null && matcher.group(6) != null) {
                token = matcher.group(6).replaceFirst("\\)", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", ")");
                    replaceString = replaceString.replaceFirst("%cast", "TRIM(TO_CHAR");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", "");
                    replaceString = replaceString.replaceFirst("%cast", "TO_CHAR");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", "");
                    replaceString = replaceString.replaceFirst("%cast", "TO_NUMBER");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_DATE");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_DATE");
                }
            }
            if (matcher.group(3) != null && matcher.group(4) != null) {
                token = matcher.group(4).replaceFirst("\\(", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", ")");
                    replaceString = replaceString.replaceAll("%cast", "TRIM(TO_CHAR");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", "");
                    replaceString = replaceString.replaceAll("%cast", "TO_CHAR");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", "");
                    replaceString = replaceString.replaceAll("%cast", "TO_NUMBER");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_DATE");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_DATE");
                }
            }
            replaceString = replaceString.toUpperCase();
            matcher.appendReplacement(buffer, replaceString);
        }
        matcher.appendTail(buffer);
        LOGGER.debug(".. result [" + buffer.toString() + "]");
        return buffer.toString();
    }

    @Override
    protected String getLastSequenceQuery(String sequence) {
        return "SELECT " + sequence + ".currval FROM DUAL";
    }

    @Override
    public String getNextSequenceValue(String sequence) throws Exception {
        return this.getSingleValue("SELECT " + sequence + ".nextval FROM DUAL");
    }

    @Override
    public int parseMajorVersion(String productVersion) throws Exception {
        String[] oraSplit = productVersion.split("Release");
        if (oraSplit.length > 1) {
            productVersion = oraSplit[1];
        }
        return super.parseMajorVersion(productVersion);
    }

    @Override
    public int parseMinorVersion(String productVersion) throws Exception {
        String[] oraSplit = productVersion.split("Release");
        if (oraSplit.length > 1) {
            productVersion = oraSplit[1];
        }
        return super.parseMinorVersion(productVersion);
    }

    @Override
    protected boolean prepareGetStatements(StringBuffer contentSB, StringBuffer splitSB, StringBuffer endSB) throws Exception {
        if (contentSB == null) {
            throw new Exception("contentSB is null");
        }
        if (splitSB == null) {
            throw new Exception("splitSB is null");
        }
        if (endSB == null) {
            throw new Exception("endSB is null");
        }
        splitSB.append("\n/\n");
        endSB.append("");
        return true;
    }

    @Override
    public String[] getReplacement() {
        return REPLACEMENT;
    }

    static {
        VERSION_LIMITER.addSupportedVersion(8, 1);
        VERSION_LIMITER.addSupportedVersion(9, 2);
        VERSION_LIMITER.setMinSupportedVersion(10, 0);
        VERSION_LIMITER.setMaxSupportedVersion(10, 2);
    }
}

