/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.connection.SOSConnectionVersionLimiter;
import sos.connection.SequenceReader;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSPgSQLConnection
extends SOSConnection
implements SequenceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSPgSQLConnection.class);
    private static final String[] REPLACEMENT = new String[]{"LOWER", "UPPER", "CURRENT_TIMESTAMP", "FOR UPDATE"};
    private static final SOSConnectionVersionLimiter VERSION_LIMITER = new SOSConnectionVersionLimiter();

    public SOSPgSQLConnection(Connection connection) throws Exception {
        super(connection);
        this.prepare(connection);
    }

    public SOSPgSQLConnection(String configFileName) throws Exception {
        super(configFileName);
    }

    public SOSPgSQLConnection(String driver, String url, String dbuser, String dbpassword) throws Exception {
        super(driver, url, dbuser, dbpassword);
    }

    @Override
    public void connect() throws Exception {
        Properties properties = new Properties();
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (SOSString.isEmpty((String)this.url)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database url.");
        }
        if (SOSString.isEmpty((String)this.driver)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database driver.");
        }
        if (!SOSString.isEmpty((String)this.dbuser) && !"[SSO]".equalsIgnoreCase(this.dbuser)) {
            if (SOSString.isEmpty((String)this.dbpassword)) {
                this.dbpassword = "";
            }
            properties.setProperty("user", this.dbuser);
            properties.setProperty("password", this.dbpassword);
        }
        Driver driver = (Driver)Class.forName(this.driver).newInstance();
        this.connection = driver.connect(this.url, properties);
        if (this.connection == null) {
            throw new Exception("can't connect to database");
        }
        VERSION_LIMITER.check(this);
        LOGGER.debug(".. successfully connected to " + this.url);
        this.prepare(this.connection);
    }

    @Override
    public void prepare(Connection connection) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        Statement stmt = null;
        try {
            if (connection == null) {
                throw new Exception("can't connect to database");
            }
            connection.setAutoCommit(false);
            connection.rollback();
            stmt = connection.createStatement();
            String numericCharacters = "SELECT set_config('lc_numeric', '', true)";
            String dateStyle = "SELECT set_config('datestyle', 'ISO, YMD', true)";
            String defaultTransactionIsolation = "SELECT set_config('default_transaction_isolation', 'repeatable read', true)";
            stmt.execute(numericCharacters);
            LOGGER.trace(".. " + numericCharacters + " successfully set.");
            stmt.execute(dateStyle);
            LOGGER.trace(".. " + dateStyle + " successfully set.");
            stmt.execute(defaultTransactionIsolation);
            LOGGER.trace(".. " + defaultTransactionIsolation + " successfully set.");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String toDate(String dateString) throws Exception {
        if (SOSString.isEmpty((String)dateString)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": dateString has no value.");
        }
        return "TO_TIMESTAMP('" + dateString + "','YYYY-MM-DD HH24:MI:SS')";
    }

    @Override
    protected GregorianCalendar getDateTime(String format) throws Exception {
        GregorianCalendar gc = new GregorianCalendar();
        String timestamp = this.getSingleValue("select CURRENT_TIMESTAMP");
        if (timestamp.length() > 19) {
            timestamp = timestamp.substring(0, 19);
        }
        Date date = SOSDate.getDate((String)timestamp, (String)format);
        gc.setTime(date);
        return gc;
    }

    @Override
    protected String replaceCasts(String inputString) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        Pattern pattern = Pattern.compile("(\\s*%cast\\s*)*\\s*(\\()*\\s*(\\s*%cast\\s*)+\\s*(\\(\\s*\\S+\\s*(\\S+?).*?)\\)(\\s*(\\+|\\-)*[0-9]*\\s*\\S*(\\)))*");
        Matcher matcher = pattern.matcher(inputString);
        StringBuffer buffer = new StringBuffer();
        String replaceString = null;
        LOGGER.trace("..inputString [" + inputString + "]");
        while (matcher.find()) {
            String token;
            replaceString = matcher.group().toLowerCase();
            if (matcher.group(1) != null && matcher.group(6) != null) {
                token = matcher.group(6).replaceFirst("\\)", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", ",'999999999999999999')");
                    replaceString = replaceString.replaceFirst("%cast", "TRIM(TO_CHAR");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", ",'999999999999999999'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_CHAR");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", ",'999999999999999999'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_NUMBER");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_TIMESTAMP");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_TIMESTAMP");
                }
            }
            if (matcher.group(3) != null && matcher.group(4) != null) {
                token = matcher.group(4).replaceFirst("\\(", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", ",'999999999999999999')");
                    replaceString = replaceString.replaceAll("%cast", "TRIM(TO_CHAR");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", ",'999999999999999999'");
                    replaceString = replaceString.replaceAll("%cast", "TO_CHAR");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", ",'999999999999999999'");
                    replaceString = replaceString.replaceAll("%cast", "TO_NUMBER");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_TIMESTAMP");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", ",'yyyy-mm-dd HH24:MI:SS'");
                    replaceString = replaceString.replaceFirst("%cast", "TO_TIMESTAMP");
                }
            }
            replaceString = replaceString.toUpperCase();
            matcher.appendReplacement(buffer, replaceString);
        }
        matcher.appendTail(buffer);
        LOGGER.debug(".. result [" + buffer.toString() + "]");
        return buffer.toString();
    }

    @Override
    protected String getLastSequenceQuery(String sequence) {
        return "SELECT currval('" + sequence + "');";
    }

    @Override
    public String getNextSequenceValue(String sequence) throws Exception {
        return this.getSingleValue("SELECT nextval('" + sequence + "')");
    }

    public Vector<String> getOutput() throws Exception {
        Vector<String> out = new Vector<String>();
        for (SQLWarning warning = this.getConnection().getWarnings(); warning != null; warning = warning.getNextWarning()) {
            out.add(warning.getMessage());
        }
        return out;
    }

    @Override
    protected boolean prepareGetStatements(StringBuffer contentSB, StringBuffer splitSB, StringBuffer endSB) throws Exception {
        if (contentSB == null) {
            throw new Exception("contentSB is null");
        }
        if (splitSB == null) {
            throw new Exception("splitSB is null");
        }
        if (endSB == null) {
            throw new Exception("endSB is null");
        }
        splitSB.append("\\$\\${1}[\\s]+(LANGUAGE|language){1}[\\s]+(plpgsql|PLPGSQL){1}[\\s]*;");
        endSB.append("$$ LANGUAGE plpgsql;");
        return false;
    }

    @Override
    public String[] getReplacement() {
        return REPLACEMENT;
    }

    static {
        VERSION_LIMITER.addSupportedVersion(8, 0);
        VERSION_LIMITER.addSupportedVersion(8, 1);
        VERSION_LIMITER.setExcludedThroughVersion(7, 999);
    }
}

