/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz;

import com.google.common.io.Files;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.graphviz.Graph;
import com.sos.graphviz.enums.FileType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphIO.class);
    public static final String NAME = System.getProperty("os.name");
    public static final boolean IS_WINDOWS = NAME.startsWith("Windows");
    private static String DOT = IS_WINDOWS ? "dot.exe" : "dot";
    private String tempDir = System.getProperty("java.io.tmpdir") + "/graphviz/";
    private String dotDir = null;
    private final Graph graph;

    public GraphIO(Graph graph) {
        this.graph = graph;
    }

    public void setDotExecFileName(String pstrDotExecFileName) {
        if (!new File(pstrDotExecFileName).exists()) {
            throw new JobSchedulerException(String.format("Dot-executable '%1$s' not found", pstrDotExecFileName));
        }
        DOT = pstrDotExecFileName;
    }

    public String getDotExecFileName() {
        return DOT;
    }

    public void writeGraphToFile(FileType type, String file) throws IOException {
        File to = new File(file);
        this.writeGraphToFile(type, to);
    }

    public void writeGraphToFile(FileType type, File to) throws IOException {
        LOGGER.trace("Write graph to file " + to.getAbsolutePath() + ".");
        FileOutputStream fos = new FileOutputStream(to);
        File dot = this.writeDotSourceToTemporaryFile(this.graph.getSource());
        fos.write(this.getGraph(dot, type));
        fos.flush();
        fos.close();
        if (this.getDotDir() != null) {
            String targetName = GraphIO.replaceLast(to.getName(), this.getFileExtension(to.getName()), "dot");
            File targetFile = new File(this.getDotDir(), targetName);
            LOGGER.trace("try to move {} to {}.", (Object)dot.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
            Files.move((File)dot, (File)targetFile);
        } else {
            this.deleteDotFile(dot);
        }
    }

    private static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }

    private String getFileExtension(String file) {
        int i = file.lastIndexOf(".");
        return i > 0 ? file.substring(i + 1) : "???";
    }

    private void deleteDotFile(File dotFile) {
        if (dotFile != null && !dotFile.delete()) {
            LOGGER.warn(dotFile.getAbsolutePath() + " could not be deleted!");
        }
    }

    private byte[] getGraph(File dotFile, FileType type) {
        byte[] imgStream = null;
        if (dotFile != null) {
            imgStream = this.getImgStream(dotFile, type.name());
        }
        return imgStream;
    }

    private byte[] getImgStream(File dot, String type) {
        byte[] imgStream = null;
        try {
            File img = File.createTempFile("graph_", "." + type, new File(this.getTempDir()));
            img.deleteOnExit();
            Runtime rt = Runtime.getRuntime();
            String[] args = new String[]{DOT, "-T" + type, dot.getAbsolutePath(), "-o", img.getAbsolutePath(), "-Gcharset=latin1"};
            String cmd = this.getCommandString(args);
            LOGGER.trace("About to execute: " + cmd);
            Process p = rt.exec(args);
            InputStream stderrIs = p.getErrorStream();
            InputStreamReader stderrReader = new InputStreamReader(stderrIs);
            BufferedReader stderr = new BufferedReader(stderrReader);
            String line = null;
            while ((line = stderr.readLine()) != null) {
                if (line.startsWith("Warning:")) {
                    LOGGER.warn(line);
                    continue;
                }
                LOGGER.error(line);
            }
            int exitVal = p.waitFor();
            if (exitVal != 0) {
                LOGGER.error(String.format("Process '%1$s' ends with cc=%2$s", cmd, exitVal));
                throw new RuntimeException(cmd + " ends with cc=" + exitVal);
            }
            FileInputStream in = new FileInputStream(img.getAbsolutePath());
            imgStream = new byte[in.available()];
            in.read(imgStream);
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Error: in I/O processing of tempfile in dir " + this.getTempDir() + "\n       or in calling external command", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            LOGGER.error("Error: the execution of the external program was interrupted", (Throwable)ie);
        }
        return imgStream;
    }

    private String getCommandString(String[] args) {
        StringBuilder b = new StringBuilder();
        for (String s : args) {
            b.append(s + " ");
        }
        return b.toString();
    }

    private File writeDotSourceToTemporaryFile(String content) throws IOException {
        File objF = new File(this.getTempDir());
        if (!objF.exists()) {
            objF.mkdirs();
        }
        File temp = File.createTempFile("graphviz_", ".dot.tmp", objF);
        try {
            FileWriter fout = new FileWriter(temp);
            fout.write(content);
            fout.close();
        }
        catch (Exception e) {
            LOGGER.error("Error: I/O error while writing the dot source to temp file {}.", (Object)temp.getAbsolutePath(), (Object)e);
            return null;
        }
        return temp;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public String getDotDir() {
        return this.dotDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setDotDir(String dotDir) {
        this.dotDir = dotDir;
    }
}

