/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz;

import com.sos.graphviz.GraphvizObject;
import com.sos.graphviz.GraphvizObjectWithId;
import com.sos.graphviz.IGraphvizObject;
import com.sos.graphviz.SingleNodeProperties;

public class Node
extends GraphvizObjectWithId
implements IGraphvizObject {
    private final String name;
    private SingleNodeProperties nodeProperties;

    protected Node(String name) {
        super(name, name + " [", "]");
        this.name = name;
        this.nodeProperties = null;
    }

    @Override
    public GraphvizObject getProperties() {
        if (this.nodeProperties == null) {
            this.nodeProperties = new SingleNodeProperties(this.name);
        }
        return this.nodeProperties;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSource() {
        return this.nodeProperties == null ? this.getName() + "\n" : super.getSource();
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeProperties != null) {
            sb.append(this.nodeProperties.getContent());
        }
        return sb.toString();
    }

    public SingleNodeProperties getSingleNodeProperties() {
        return (SingleNodeProperties)this.getProperties();
    }
}

