/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz;

public class RGBColor {
    private final Integer red;
    private final Integer green;
    private final Integer blue;
    private final String hexString;

    public RGBColor(String hexString) {
        Integer bigint = Integer.parseInt(hexString.substring(1), 16);
        this.red = bigint >> 16 & 0xFF;
        this.green = bigint >> 8 & 0xFF;
        this.blue = bigint & 0xFF;
        this.hexString = hexString;
    }

    public RGBColor(Integer red, Integer green, Integer blue) {
        this.hexString = "#" + this.componentToHex(red) + this.componentToHex(green) + this.componentToHex(blue);
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    private String componentToHex(Integer c) {
        String hex = Integer.toString(16);
        return hex.length() == 1 ? "0" + hex : hex;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public String getHexString() {
        return this.hexString;
    }
}

