/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

public class SOSCommandResult {
    private final StringBuilder stdOut;
    private final StringBuilder stdErr;
    private String command;
    private Integer exitCode;
    private Throwable exception;

    public SOSCommandResult(String cmd) {
        this.command = cmd;
        this.stdOut = new StringBuilder();
        this.stdErr = new StringBuilder();
    }

    public void setCommand(String val) {
        this.command = val;
    }

    public String getCommand() {
        return this.command;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer val) {
        this.exitCode = val;
    }

    public String getStdOut() {
        return this.stdOut.toString();
    }

    public void addStdOut(String val) {
        this.stdOut.append(val);
    }

    public boolean hasStdOut() {
        return this.stdOut.length() > 0;
    }

    public String getStdErr() {
        return this.stdErr.toString();
    }

    public void addStdErr(String val) {
        this.stdErr.append(val);
    }

    public boolean hasStdErr() {
        return this.stdErr.length() > 0;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable val) {
        this.exception = val;
    }

    public boolean hasError() {
        return this.hasError(false);
    }

    public boolean hasError(boolean checkStdError) {
        if (this.exception != null) {
            return true;
        }
        if (this.exitCode != null && this.exitCode > 0) {
            return true;
        }
        return checkStdError && this.stdErr.length() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.command).append("]");
        sb.append("[exitCode=").append(this.exitCode).append("]");
        sb.append("[std:out=").append(this.stdOut.toString().trim()).append("]");
        sb.append("[std:err=").append(this.stdErr.toString().trim()).append("]");
        if (this.exception != null) {
            sb.append("[exception=").append(this.exception.toString()).append("]");
        }
        return sb.toString();
    }
}

