/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public abstract class SOSCommonProvider
extends SOSVFSMessageCodes
implements ISOSProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSCommonProvider.class);
    protected String user = "";
    protected String host = "";
    protected int port = 0;
    protected String reply = "OK";
    private List<SOSFileEntry> directoryFiles = null;
    private int directoryFilesCount = 0;
    private boolean directoryFilesCountExceeded = false;
    private List<SOSFileEntry> directorySubFolders = null;
    private SOSBaseOptions baseOptions = null;
    private SOSProviderOptions providerOptions = null;

    public SOSCommonProvider() {
        super("SOSVirtualFileSystem");
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        if (options == null) {
            throw new Exception("providerOptions is null");
        }
        this.providerOptions = options;
        this.user = this.providerOptions.user.getValue();
        this.host = this.providerOptions.host.getValue();
        this.port = this.providerOptions.port.value();
    }

    @Override
    public void reconnect() {
        if (!this.isConnected()) {
            try {
                this.connect(this.providerOptions);
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JobSchedulerException((Throwable)e);
            }
        }
    }

    @Override
    public void disconnect() {
    }

    @Override
    public List<SOSFileEntry> getFileList(String folder, int maxFiles, boolean recursive, Pattern fileNamePattern, Pattern excludedDirectoriesPattern, boolean checkIfExists, String integrityHashType, int recLevel) throws Exception {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        if (recLevel == 0) {
            this.directoryFiles = new ArrayList<SOSFileEntry>();
            this.directoryFilesCount = 0;
            this.directoryFilesCountExceeded = false;
        }
        List entries = null;
        String path = folder.trim();
        if (path.isEmpty()) {
            path = ".";
        }
        try {
            entries = this.listNames(path, maxFiles, checkIfExists, checkIfExists);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (entries == null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]entries=null", path));
            }
            return this.directoryFiles;
        }
        for (SOSFileEntry entry : entries) {
            if (maxFiles > 0 && this.directoryFilesCount >= maxFiles) {
                if (!this.directoryFilesCountExceeded) {
                    LOGGER.info(String.format("[skip]maxFiles=%s exceeded", maxFiles));
                    this.directoryFilesCountExceeded = true;
                }
                return this.directoryFiles;
            }
            if (!this.isNotHiddenFile(entry.getFilename())) {
                if (!isDebugEnabled) continue;
                LOGGER.debug(String.format("[%s][entry is hidden]%s continue", path, entry.getFilename()));
                continue;
            }
            if (entry.isDirectory()) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][directory]%s", path, SOSString.toString((Object)entry)));
                }
                if (!recursive) continue;
                if (excludedDirectoriesPattern != null && excludedDirectoriesPattern.matcher(entry.getDirectoryPath()).find()) {
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][directory][match][excludedDirectories=%s]%s", path, excludedDirectoriesPattern.pattern(), entry.getFullPath()));
                    continue;
                }
                this.getFileList(entry.getFullPath(), maxFiles, recursive, fileNamePattern, excludedDirectoriesPattern, checkIfExists, integrityHashType, ++recLevel);
                continue;
            }
            if (isTraceEnabled) {
                LOGGER.trace(String.format("[%s][file]%s", path, SOSString.toString((Object)entry)));
            }
            if (integrityHashType != null && entry.getFilename().endsWith(integrityHashType) || !fileNamePattern.matcher(entry.getFilename()).find()) continue;
            this.directoryFiles.add(entry);
            ++this.directoryFilesCount;
        }
        return this.directoryFiles;
    }

    @Override
    public List<SOSFileEntry> getSubFolders(String folder, int maxFiles, boolean recursive, Pattern pattern, int recLevel) throws Exception {
        if (recLevel == 0) {
            this.directorySubFolders = new ArrayList<SOSFileEntry>();
        }
        List entries = null;
        String path = folder.trim();
        if (path.isEmpty()) {
            path = ".";
        }
        try {
            entries = this.listNames(path, maxFiles, false, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (entries == null) {
            return this.directorySubFolders;
        }
        for (SOSFileEntry entry : entries) {
            if (!entry.isDirectory()) continue;
            if (pattern.matcher(entry.getFilename()).find()) {
                this.directorySubFolders.add(entry);
            }
            if (!recursive) continue;
            this.getSubFolders(entry.getFullPath(), maxFiles, recursive, pattern, ++recLevel);
        }
        return this.directorySubFolders;
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace('\\', '/');
    }

    public static String normalizePath(String dir, String subPath) {
        String string = subPath = subPath == null ? "" : SOSCommonProvider.normalizePath(subPath);
        if (SOSString.isEmpty((String)dir)) {
            return subPath;
        }
        if ((dir = SOSCommonProvider.normalizePath(dir)).endsWith("/")) {
            if (subPath.startsWith("/")) {
                return dir.substring(0, dir.length() - 1) + subPath;
            }
            return dir + subPath;
        }
        return dir + subPath;
    }

    public static String normalizeDirectoryPath(String path) {
        String p = SOSCommonProvider.normalizePath(path);
        if (p == null) {
            return null;
        }
        return p.endsWith("/") ? p.substring(0, p.length() - 1) : p;
    }

    public static String getFullParentFromPath(String path) {
        if (path == null || path.equals("/")) {
            return null;
        }
        int li = path.lastIndexOf("/");
        return li > -1 ? path.substring(0, li) : null;
    }

    public static String getBaseNameFromPath(String path) {
        int li = path.lastIndexOf("/");
        return li > -1 ? path.substring(li + 1) : path;
    }

    @Override
    public long getFileSize(String fileName) {
        try {
            return this.size(SOSCommonProvider.normalizePath(fileName));
        }
        catch (Exception e) {
            LOGGER.trace(SOSVfs_E_134.params(new Object[]{"getFileSize"}) + ":" + e.toString(), (Throwable)e);
            return -1L;
        }
    }

    protected String getHostID(String msg) {
        return "(" + this.user + "@" + this.host + ":" + this.port + ") " + msg;
    }

    protected boolean logReply() {
        this.reply = this.getReplyString();
        if (!this.reply.trim().isEmpty()) {
            LOGGER.debug(this.reply);
        }
        return true;
    }

    public boolean isNotHiddenFile(String fileName) {
        return fileName != null && !".".equals(fileName) && !"..".equals(fileName) && !fileName.endsWith("/..") && !fileName.endsWith("/.");
    }

    protected String trimResponseCode(String response) throws Exception {
        if (response.length() < 5) {
            return response;
        }
        return response.substring(4).trim();
    }

    protected void closeObject(OutputStream os) {
        try {
            if (os != null) {
                os.flush();
                os.close();
                os = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void closeInput(InputStream is) {
        try {
            if (is != null) {
                is.close();
                is = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getReplyString() {
        return this.reply;
    }

    @Override
    public boolean fileExists(String filename) {
        return false;
    }

    @Override
    public boolean isNegativeCommandCompletion() {
        return false;
    }

    @Override
    public ISOSProviderFile getFile(String filename) {
        return null;
    }

    @Override
    public InputStream getInputStream(String fileName) {
        return null;
    }

    @Override
    public abstract OutputStream getOutputStream(String var1, boolean var2, boolean var3);

    @Override
    public void mkdir(String pathname) throws IOException {
        LOGGER.info("not implemented yet");
    }

    @Override
    public void rmdir(String folderName) throws IOException {
        LOGGER.info("not implemented yet");
    }

    @Override
    public void delete(String pathname, boolean checkIsDirectory) throws IOException {
        LOGGER.info("not implemented yet");
    }

    @Override
    public void rename(String from, String to) {
        LOGGER.info("not implemented yet");
    }

    @Override
    public void executeCommand(String cmd) throws Exception {
        LOGGER.info("not implemented yet");
    }

    @Override
    public void executeCommand(String cmd, SOSEnv env) throws Exception {
        LOGGER.info("not implemented yet");
    }

    protected long size(String fileName) throws Exception {
        LOGGER.info("not implemented yet");
        return -1L;
    }

    @Override
    public boolean isDirectory(String filename) {
        LOGGER.info("not implemented yet");
        return false;
    }

    @Override
    public boolean directoryExists(String filename) {
        LOGGER.info("not implemented yet");
        return false;
    }

    @Override
    public String getModificationDateTime(String fileName) {
        LOGGER.info("not implemented yet");
        return null;
    }

    @Override
    public boolean isSFTP() {
        return false;
    }

    @Override
    public boolean isHTTP() {
        return false;
    }

    @Override
    public SOSBaseOptions getBaseOptions() {
        return this.baseOptions;
    }

    @Override
    public void setBaseOptions(SOSBaseOptions val) {
        this.baseOptions = val;
    }

    @Override
    public SOSProviderOptions getProviderOptions() {
        return this.providerOptions;
    }
}

