/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonFile;
import com.sos.vfs.common.interfaces.ISOSProvider;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSCommonProviderFile
extends SOSCommonFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSCommonProviderFile.class);
    protected String fileName = "";

    public SOSCommonProviderFile() {
        super("SOSVirtualFileSystem");
    }

    public SOSCommonProviderFile(String path) {
        this();
        this.fileName = this.adjustFileSeparator(path);
    }

    @Override
    public boolean fileExists() {
        boolean result = false;
        if (this.getProvider().getFileSize(this.fileName) >= 0L) {
            result = true;
        }
        LOGGER.debug(String.format("[%s]%s", this.fileName, result));
        return result;
    }

    @Override
    public boolean directoryExists() {
        boolean result = this.getProvider().directoryExists(this.fileName);
        LOGGER.debug(String.format("[%s]%s", this.fileName, result));
        return result;
    }

    @Override
    public boolean delete(boolean checkIsDirectory) {
        try {
            this.getProvider().delete(this.fileName, checkIsDirectory);
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            SOSVfs_E_158.get();
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"delete()", this.fileName}), e);
        }
        return true;
    }

    @Override
    public InputStream getFileInputStream() {
        try {
            if (this.getInputStream() == null) {
                this.fileName = this.adjustRelativePathName(this.fileName);
                this.setInputStream(this.getProvider().getInputStream(this.fileName));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileInputStream()", this.fileName}), e);
        }
        return this.getInputStream();
    }

    protected String adjustRelativePathName(String path) {
        return path.replaceAll("\\\\", "/");
    }

    @Override
    public long getFileSize() {
        long lngFileSize = -1L;
        try {
            lngFileSize = this.getProvider().getFileSize(this.fileName);
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"getFileSize()"}), e);
        }
        return lngFileSize;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public boolean isDirectory() {
        return this.getProvider().isDirectory(this.fileName);
    }

    @Override
    public void rename(String newPath) {
        this.getProvider().rename(this.fileName, newPath);
    }

    @Override
    public void setProvider(ISOSProvider provider) {
        super.setProvider(provider);
    }

    @Override
    public void closeInput() {
        try {
            if (this.getInputStream() != null) {
                this.getInputStream().close();
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(ex.toString(), ex);
            }
        }
        finally {
            this.setInputStream(null);
        }
    }

    @Override
    public void closeOutput() {
        block9: {
            try {
                block10: {
                    if (this.getOutputStream() == null) break block9;
                    try {
                        this.getOutputStream().flush();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isDebugEnabled()) break block10;
                        LOGGER.debug("[closeOutput][flush]" + e.toString(), e);
                    }
                }
                this.getOutputStream().close();
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Throwable ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(ex.toString(), ex);
                }
            }
            finally {
                this.setOutputStream(null);
            }
        }
    }

    @Override
    public long setModificationDateTime(long dateTime) {
        return 0L;
    }

    @Override
    public long getModificationDateTime() {
        return 0L;
    }
}

